// ========================================================
//  Copyright (c)2005 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source: D:/home/r51406/___CVS/CVS_Server2/MM908Exxx/Kobi_IO.h,v $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: Exp $
//  Revision:     $Revision: 1.3 $
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  Hardware Description File (Register File)
//                for KOBI SMOS Chip
//
//
//  Notes:        used by SPI routines to read / write register
//
//
//
// ========================================================
#ifndef  KOBI_IO_H
#define  KOBI_IO_H

#include "Types.h"


// -----  Register  ----------------------------------------
// Write bits
#define   bwLINSL2   BIT7
#define   bwLINSL1   BIT6
#define   bwLINPU    BIT5
#define   bwHS3ON    BIT4
#define   bwHS2ON    BIT3
#define   bwHS1ON    BIT2
#define   bwMODE2    BIT1
#define   bwMODE1    BIT0
// -----  Register  ----------------------------------------
// read bits
#define   brINTSRC   BIT7
#define   brLINWU    BIT6
#define   brLINFAIL  BIT6
#define   brHVF      BIT5
#define   brLVF      BIT4
#define   brBATFAIL  BIT4
#define   brVDDT     BIT3
#define   brHSST     BIT2
#define   brL2       BIT1
#define   brL1       BIT0

#endif //KOBI_IO_H
