// ========================================================
//  Copyright (c)2005 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source: D:/home/r51406/___CVS/CVS_Server2/MM908Exxx/SHADOW_ADC.h,v $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: Exp $
//  Revision:     $Revision: 1.1.1.1 $
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  ADC support routines
//								for Shadow SMOS Chip
//
//
//  Notes:        
//
//
//
// ========================================================
#ifndef  SHADOW_ADC_H
#define  SHADOW_ADC_H

#include "SHADOW_IO.h"

// -----  Mapping of A/D channels  ------------------------
#define  ADC_CRHB1     (                  0)                // Current Recopy HB1 (LowSide)
#define  ADC_CRHB2     (               bSS0)                // Current Recopy HB2 (LowSide)
#define  ADC_CRHB3     (          bSS1     )                // Current Recopy HB3 (LowSide)
#define  ADC_CRHB4     (          bSS1|bSS0)                // Current Recopy HB4 (LowSide)
#define  ADC_CRHS1     (     bSS2          )                // Current Recopy HS1
#define  ADC_CRHS2     (     bSS2     |bSS0)                // Current Recopy HS2
#define  ADC_CRHS3     (     bSS2|bSS1     )                // Current Recopy HS3
#define  ADC_TEMP      (bSS3               )                // Die Temperature
#define  ADC_VSUP      (bSS3          |bSS0)                // VSUP Scaler  
#define  ADC_A0        (bSS3     |bSS1     )                // Analog input0
#define  ADC_A0CST     (bSS3     |bSS1|bSS0)                // A0CST
#define  ADC_EC        (bSS3|bSS2          )                // EC


void SMOS_ADMux(UINT8 channel);

#endif // SHADOW_ADC_H