// ========================================================
//  Copyright (c)2005 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source: D:/home/r51406/___CVS/CVS_Server2/MM908Exxx/SHADOW_IO.h,v $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: Exp $
//  Revision:     $Revision: 1.2 $
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  Hardware Description File (Register File)
//								for Shadow
//
//
//  Notes:        use SPI routines to read / write register
//
//
//
// ========================================================
#ifndef  SHADOW_IO_H
#define  SHADOW_IO_H

#include "Types.h"


// -----  Register  ----------------------------------------
#define erSYSCTL    0x00                                    // System Control
#define   bPSON     BIT7
#define   bSTP      BIT6
#define   bSLEEP    BIT5
#define   bHTRD     BIT4
#define   bTHIS     BIT3
#define   bVIS      BIT2
#define   bSRS1     BIT1
#define   bSRS0     BIT0


#define erHBOUT     0x01                                    // H-Bridge output
#define   bHB4_H    BIT7
#define   bHB4_L    BIT6
#define   bHB3_H    BIT5
#define   bHB3_L    BIT4
#define   bHB2_H    BIT3
#define   bHB2_L    BIT2
#define   bHB1_H    BIT1
#define   bHB1_L    BIT0


#define erHSOUT     0x02                                    // High Side Out
#define   bHVDDON   BIT7
#define   bHSPWM3   BIT5
#define   bHSPWM2   BIT4
#define   bHSPWM1   BIT3
#define   bHSON3    BIT2
#define   bHSON2    BIT1
#define   bHSON1    BIT0


#define erHBSCTL    0x03                                    // Half Bridges Status & Control
#define   bCRM      BIT7
#define   bHB4OC    BIT3
#define   bHB3OC    BIT2
#define   bHB2OC    BIT1
#define   bHB1OC    BIT0


#define erHSSCTL    0x04                                    // High Side Status
#define   bHVDDOCF  BIT7
#define   bHSOCF3   BIT2
#define   bHSOCF2   BIT1
#define   bHSOCF1   BIT0


#define erECSCTL    0x05                                    // EC Status & Control
#define   bECON     BIT7
#define   bECOLT    BIT6
#define   bECRON    BIT5
#define   bECOCF    BIT1
#define   bECOLF    BIT0



#define erECDACC    0x06                                    // EC D/A Converter
#define   bECDAC5   BIT5
#define   bECDAC4   BIT4
#define   bECDAC3   BIT3
#define   bECDAC2   BIT2
#define   bECDAC1   BIT1
#define   bECDAC0   BIT0



#define erHLSCTL    0x07                                    // H0/L0 Status & Control
#define   bL0F      BIT7
#define   bH0OCF    BIT4
#define   bH0F      BIT3
#define   bH0EN     BIT2
#define   bH0PE     BIT1
#define   bH0MS     BIT0



#define erA0MUCTL   0x08                                    // A0 / Multiplexer Config
#define   bCSON     BIT7
#define   bCSSEL1   BIT6
#define   bCSSEL0   BIT5
#define   bCSA      BIT4
#define   bSS3      BIT3
#define   bSS2      BIT2
#define   bSS1      BIT1
#define   bSS0      BIT0



#define erIMR       0x09                                    // Intrerrupt Mask
#define   bL0IE     BIT7
#define   bH0IE     BIT6
#define   bLINIE    BIT5
#define   bHTIE     BIT3
#define   bLVIE     BIT2
#define   bHVIE     BIT1
#define   bPSFIE    BIT0



#define erIFR       0x0A                                    // Interrupt Flag
#define   bL0IF     BIT7
#define   bH0IF     BIT6
#define   bLINIF    BIT5
#define   bHTIF     BIT3
#define   bLVIF     BIT2
#define   bHVIF     BIT1
#define   bPSFIF    BIT0



#define erWDCTL     0x0B                                    // WatchDog Status & Control
#define   bWDRE     BIT7
#define   bWDP1     BIT6
#define   bWDP0     BIT5
#define   bWDRST    BIT0
  

#define erSYSSTAT   0x0C                                    // System Status register
#define   bLINCL    BIT7
#define   bHTF      BIT6
#define   bVFF      BIT5
#define   bPHF      BIT4
#define   bHVDDF    BIT3
#define   bHSF      BIT2
#define   bHBF      BIT1
#define   bECF      BIT0


#define erRSR       0x0D                                    // Reset / WakeUp Status
#define   bPOR      BIT7
#define   bPINR     BIT6
#define   bWDR      BIT5
#define   bHTR      BIT4
#define   bLVR      BIT3
#define   bLINWF    BIT1
#define   bL0WF     BIT0


#define erSYSTEST   0x0E                                    // System Test Register
#define   bTTEST    BIT7
#define   bfuse3    BIT3
#define   bfuse2    BIT2
#define   bfuse1    BIT1
#define   bfuse0    BIT0

#define erSYSTRIM1  0x0F                                    // System Trim Register 1           
#define   bHVDDT1   BIT7
#define   bHVDDT0   BIT6
#define   bitrim3   BIT3
#define   bitrim2   BIT2
#define   bitrim1   BIT1
#define   bitrim0   BIT0

#define erSYSTRIM2  0x10                                    // System Trim Register 2                                    
#define   bCRHBHC1  BIT7
#define   bCRHBHC0  BIT6
#define   bCRHB5    BIT5
#define   bCRHB4    BIT4
#define   bCRHB3    BIT3
#define   bCRHB2    BIT2
#define   bCRHB1    BIT1
#define   bCRHB0    BIT0

#define erSYSTRIM3  0x11                                    // System Trim Register 3                                    
#define   bCRHSHC3  BIT7
#define   bCRHSHC2  BIT6
#define   bCRHS5    BIT5
#define   bCRHS4    BIT4
#define   bCRHS3    BIT3
#define   bCRHS2    BIT2
#define   bCRHS1    BIT1
#define   bCRHS0    BIT0

#endif //SHADOW_IO_H