// ========================================================
//  Copyright (c)2006 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source$
//  Author:       $Author$
//  Locker:       $Locker$
//  State:        $State$
//  Revision:     $Revision$
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  
//
//
//
//  Notes:        
//
//
//
// ========================================================
#define   FILTER_C 

#include "Filter.h"









// --------------------------------------------------------
// Globals
// --------------------------------------------------------

// --------------------------------------------------------
// Properties (private)
// --------------------------------------------------------
static UINT16 Current_Decel_Reading;    // Current deceleration reading
static UINT16 Last_Decel_Reading;       // Previous deceleration reading
static UINT16 Decel_Reading_Accum;      // Accumulated deceleration reading


// --------------------------------------------------------
// Methodes
// --------------------------------------------------------
void FilterInit(UINT16 newvalue)  {

  Last_Decel_Reading = newvalue;
//  Decel_Reading_Accum = Last_Decel_Reading;
#warning "modified !!!"
  Decel_Reading_Accum = Last_Decel_Reading*(UINT16)DIVIDER;
  
}
// --------------------------------------------------------
UINT16 Filter(UINT16 newvalue)  {
  UINT16 result;

  Current_Decel_Reading = newvalue;                                       // Update current reading
  Decel_Reading_Accum   = Decel_Reading_Accum + (Current_Decel_Reading - Last_Decel_Reading);
  //Decel_Value           = Decel_Reading_Accum/(TIME_CONST*SAMP_RATE);                       // Calculate new average
  result           = Decel_Reading_Accum/((UINT16)(DIVIDER));                       // Calculate new average
  Last_Decel_Reading    = result;                               // Update "last reading"

  return result;

}




