// ========================================================
//   Copyright (C) 2003 Motorola, Inc.
//   All Rights Reserved
//
//   The code is the property of Motorola GmbH Munich
//   Combined Technologies Operation
//   and is Motorola Confidential Proprietary Information.
//
//   The copyright notice above does not evidence any
//   actual or intended publication of such source code.
//
//
// Filename:     $Source: $
// Author:       $Author:  $
// Locker:       $Locker:  $
// State:        $State: Exp $
// Revision:     $Revision: $
//
// Functions:    
//
// History:      Use the CVS command log to display 
//               revision history information.
//
// Description:  Timer B Overflow used to generate "ticks"
//               in combination with a simple counter
//
//
// Notes:        
//
//
// ========================================================
#define   TIMERB_C 

#include "TimerB.h"
#include "ChipSets.h"
#include "l_api.h"
#include "types.h"




// --------------------------------------------------------
// Properties (public)
// --------------------------------------------------------
extern UINT8  LedOn;

// --------------------------------------------------------
// Properties (private)
// --------------------------------------------------------
static UINT8 fDutyCycle;
static UINT8 fDutyOn;
static UINT8 fPeriodCounter;

// --------------------------------------------------------
// --------------------------------------------------------
static union uWord fTemp;


// --------------------------------------------------------
// Methodes (public)
// --------------------------------------------------------
void TimerBInit(void)  {

  fPeriodCounter = 0;
  fDutyCycle = 0;
  fDutyOn = 0;
  
  rTBSC |= (bTRST|bTSTOP);                                  // Configure TimB, PS=1
  
  // set tick frequency  
  fTemp.Word = TIMBPERIOD;
  rTBMODH = fTemp.Byte.HiByte;
  rTBMODL = fTemp.Byte.LoByte;


  rTBSC |= bTOIE;                                           // enable TOV irq  
  rTBSC &= ~bTSTOP;                                         // start Timer B      
}
// --------------------------------------------------------
void TimerBEnable(void)  {

// still to do
  //rTBSC0 |= bMS0B;                                          // map to PTxx
  rTBSC &= ~bTSTOP;                                         // start Timer B      

}
// --------------------------------------------------------
void TimerBDisable(void)  {

// still to do
  //rTBSC0&= ~bMS0B;                                         // unmap to PTxx
  rTBSC |= bTSTOP;                                         // stop Timer B      
}
// --------------------------------------------------------
void TimerBSetDuty(UINT8 value)  {

  if(value>TICKSMAX)  {
    fDutyCycle = TICKSMAX;
  }else{
    fDutyCycle = value;
  }
}


// --------------------------------------------------------
// Methodes (private) - IRQ Servie
// --------------------------------------------------------

// --------------------------------------------------------
#pragma TRAP_PROC
void isrTIMBOvfl(void)  {        

  if(rTBSC&bTOF)  {                                        // test flag
    rTBSC &= ~bTOF;                                        // clear flag

    if(fPeriodCounter>=TICKSMAX)  {
      fPeriodCounter = 0;                                   // new period starts
      fDutyOn = fDutyCycle;

      if(fDutyOn>0)  {

//SPI_Write(erPOUT , SPI_RegValue(erPOUT)|bHS_ON);   

        SPI_Write(erHBOUT, LedOn);                         // turn on at start of period
      }else{
        // Off
      }
    }else{

      if(fPeriodCounter==fDutyOn)  {                       // turn off if duty high is reached

//SPI_Write(erPOUT , SPI_RegValue(erPOUT)&~bHS_ON);   


        SPI_Write(erHBOUT, 0);
      }

      fPeriodCounter++;
    }



    
    
  }
}  


