/****************************************************************************
 * FILE NAME: etpuc_decimate.c                 COPYRIGHT (c) FREESCALE 2006 *
 * DESCRIPTION:                                     All Rights Reserved     *
 * Simple eTPU decimation function                                          *
 *==========================================================================*
 * ORIGINAL AUTHOR: Geoff Emerson (r47354)                                  *
 * $Log: etpuc_decimate.c,v $
 * Revision 1.1  2006/06/14 10:42:20  r47354
 * Initial revision.
 *
 *........................................................................*
 ****************************************************************************/
#ifndef __ETPUC_H
#include <etpuc.h>          /*Defines eTPU hardware*/
#endif

#ifndef __ETPUC_COMMON_H
#include <eTPUc_common.h>   /*Standard way to use eTPU*/
#endif

/* DECIMATE Definitions */
/* Host Service Requests */
#define  DECIMATE_RUN 7

#define DECIMATION_AMOUNT 4

#ifdef DECIMATE_FUNCTION_NUMBER
#pragma ETPU_function DECIMATE, alternate @ DECIMATE_FUNCTION_NUMBER;
#else
#pragma ETPU_function DECIMATE, alternate;
#endif

/*------------------------------------------------------------------------*/
/* CHANNEL PARAMETERS: (host modifiable)                                  */
/*------------------------------------------------------------------------*/

void DECIMATE (unsigned int16 Input_Values[DECIMATION_AMOUNT * 2], unsigned int16 Decimated_Value, unsigned int16 Timestamp, 
               unsigned int32 Tcd_Daddr, unsigned int24 Tcd_Doff, unsigned int32 Ping_Pong_Address, unsigned int32 Ping_Pong_Length)

{
    static int8 x;  /*counter */
     if ( HostServiceRequest == DECIMATE_RUN )
      {
	
				Decimated_Value = 0;
				for (x=0; x< DECIMATION_AMOUNT] * 2 ; x=x+2)
				{
					Decimated_Value = Decimated_Value + Input_Values[x];
				}
				Timestamp = Input_Values[1]; 
				Decimated_Value = Decimated_Value / 4;
				
				/* and manipulate the DADDR in the TCD */

				Tcd_Daddr = Tcd_Doff + Tcd_Daddr;
				if ((int24 )Tcd_Daddr == (int24)(	Ping_Pong_Address + ( Ping_Pong_Length * 2 ) )	)	
				/* here a cast to 24 bits is used as eTPUC doesn't suppoprt 32 bit compares */
				{
					/* Destination address is at the end of the ping pong buffer; 
					   so set back to the start */
					Tcd_Daddr = Ping_Pong_Address;
				}
      }      

    /********************************************************************/
    /* THREAD NAME : ERROR_CODE                                         */
    /********************************************************************/
    /* 1. Call the Global error routine and end.                        */
    /********************************************************************/
	  else
	  {
#ifdef GLOBAL_ERROR_FUNC
		Global_Error_Func();
#else
		ClearAllLatches();
#endif
	  }
}

/* Information exported to Host CPU program */
#pragma write h, (::ETPUfilename (cpu/etpu_decimate_auto.h));
#pragma write h, (/****************************************************************);
#pragma write h, ( * WARNING this file is automatically generated DO NOT EDIT IT! *);
#pragma write h, ( *                                                              *);
#pragma write h, ( * FILE NAME: etpu_decimate_auto.h      COPYRIGHT (c) Freescale 2004 *);
#pragma write h, ( *                                      All Rights Reserved     *);
#pragma write h, ( * This file generated by:                                      *);
#pragma write h, ( * $RCSfile: etpuc_decimate.c,v $ $Revision: 1.1 $);
#pragma write h, ( *                                                              *);
#pragma write h, ( * This file provides an interface between eTPU code and CPU    *);
#pragma write h, ( * code. All references to the DECIMATE function should be made with *);
#pragma write h, ( * information in this file. This allows only symbolic          *);
#pragma write h, ( * information to be referenced which allows the eTPU code to be*);
#pragma write h, ( * optimized without effecting the CPU code.                    *);
#pragma write h, ( ****************************************************************/);
#pragma write h, (#ifndef _ETPU_DECIMATE_AUTO_H_ );
#pragma write h, (#define _ETPU_DECIMATE_AUTO_H_ );
#pragma write h, ( );
#pragma write h, (/* Function Configuration Information */);
#pragma write h, (::ETPUliteral(#define FS_ETPU_DECIMATE_FUNCTION_NUMBER) ::ETPUfunctionnumber(DECIMATE) );
#pragma write h, (::ETPUliteral(#define FS_ETPU_DECIMATE_TABLE_SELECT) ::ETPUentrytype(DECIMATE) );
#pragma write h, (::ETPUliteral(#define FS_ETPU_DECIMATE_NUM_PARMS) ::ETPUram(DECIMATE) );
#pragma write h, ( );
#pragma write h, (/* Host Service Request Definitions */);
#pragma write h, (::ETPUliteral(#define FS_ETPU_DECIMATE_RUN) DECIMATE_RUN  );
#pragma write h, ( );
#pragma write h, (/* Parameter Definitions */);
#pragma write h, (::ETPUliteral(#define FS_ETPU_DECIMATE_INPUT_VALUES) ::ETPUlocation (DECIMATE, Input_Values) );
#pragma write h, (::ETPUliteral(#define FS_ETPU_DECIMATE_DECIMATED_VALUE) ::ETPUlocation (DECIMATE, Decimated_Value) );
#pragma write h, (::ETPUliteral(#define FS_ETPU_DECIMATE_TIMESTAMP) ::ETPUlocation (DECIMATE, Timestamp) );
#pragma write h, (::ETPUliteral(#define FS_ETPU_DECIMATE_TCD_DADDR) ::ETPUlocation (DECIMATE, Tcd_Daddr) );
#pragma write h, (::ETPUliteral(#define FS_ETPU_DECIMATE_TCD_DOFF) ::ETPUlocation (DECIMATE, Tcd_Doff) );
#pragma write h, (::ETPUliteral(#define FS_ETPU_DECIMATE_PING_PONG_ADDRESS) ::ETPUlocation (DECIMATE, Ping_Pong_Address) );
#pragma write h, (::ETPUliteral(#define FS_ETPU_DECIMATE_PING_PONG_SIZE) ::ETPUlocation (DECIMATE, Ping_Pong_Length) );
#pragma write h, ( );
#pragma write h, (#endif /* _ETPU_DECIMATE_AUTO_H_ */);
#pragma write h, ( );

/*********************************************************************
 *
 * Copyright:
 *  FREESCALE, INC. All Rights Reserved.
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Motorola, Inc. This
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, FREESCALE
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY
 *  ACCOMPANYING WRITTEN MATERIALS.
 *
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL FREESCALE BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.
 *
 *  Freescale assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/