/**
* Copyright (c) 2006, Freescale Semiconductor
* Freescale Quick Reference
*
* File name : main.c
* Project name: GPIO Usage
*
* Author : Ioseph Martinez
* Department : RTAC Americas
*
* Description : This module shows how to configure the registers for
* the usage of the GPIO ports
*
* History :
* 07/06/2006 : Initial release.
* 
*/	

#include "common.h"


void myDelay(unsigned char counter2);

int main(){
    volatile int counter;
    
    /* GPIO FUNCTIOe registers */
    /* Assign pins to GPIO function */
	
    /* PORTC pins (leds in 5213EVB) */
    MCF_GPIO_PTCPAR = 0 
    | MCF_GPIO_PTCPAR_TIN3_GPIO           
    | MCF_GPIO_PTCPAR_TIN2_GPIO
    | MCF_GPIO_PTCPAR_TIN1_GPIO
    | MCF_GPIO_PTCPAR_TIN0_GPIO;
		
    /* IRQ4 IRQ5 pins (SW1 SW2 on 5213EVB) */ 
    MCF_GPIO_PNQPAR = 0
    | MCF_GPIO_PNQPAR_IRQ4_GPIO
    | MCF_GPIO_PNQPAR_IRQ5_GPIO;
	
	
	
	
    /*
     * If you don't want to configure those ports as
     * GPIO (above) you may write something like the
     * code below.
     */
	 
    /* 
     *  MCF_GPIO_PTCPAR = 0 
     *  | MCF_GPIO_PTCPAR_TIN3_PWM6
     *  | MCF_GPIO_PTCPAR_TIN2_PWM4
     *  | MCF_GPIO_PTCPAR_TIN1_PWM2
     *  | MCF_GPIO_PTCPAR_TIN0_PWM0;
     *
     *  
     *  MCF_GPIO_PNQPAR = 0
     *  | MCF_GPIO_PNQPAR_IRQ4_IRQ4
     *  | MCF_GPIO_PNQPAR_IRQ5_IRQ5;		
     */
    
	

    /* DATA DIRECTION configuration */
	
    /* PORTTC data direction as output PORTTC(3)(2)(1)(0)=1; */
    MCF_GPIO_DDRTC = 0
    | MCF_GPIO_DDRTC_DDRTC3
    | MCF_GPIO_DDRTC_DDRTC2
    | MCF_GPIO_DDRTC_DDRTC1
    | MCF_GPIO_DDRTC_DDRTC0;	


    /* IRQ4 IRQ5 data direction configured as inputs */ 
    /* this operation avoids changing the former values of the other pins in PORTNQ */	
    MCF_GPIO_DDRNQ = MCF_GPIO_DDRNQ
    & ~MCF_GPIO_DDRNQ_DDRNQ4
    & ~MCF_GPIO_DDRNQ_DDRNQ5;	

	
    /* SETTING, CLEARING, READING & WRITTING */ 	
	
    while (1) {  /* loop for polling */	
		
    	/* Reading SW1 (pin IRQ4) */ 
        if (!(MCF_GPIO_SETNQ & MCF_GPIO_SETNQ_SETNQ4)) {  /* (XXXVXXX0)&(00010000) = (000V0000) */
            /* setting pins via PORTnP/SETn */
            MCF_GPIO_SETTC = 0
            | MCF_GPIO_SETTC_SETTC0
            | MCF_GPIO_SETTC_SETTC1
            | MCF_GPIO_SETTC_SETTC2
            | MCF_GPIO_SETTC_SETTC3;	
            myDelay(50);
            /* Reading again from SW1 */
            while (!(MCF_GPIO_SETNQ & MCF_GPIO_SETNQ_SETNQ4))
                ;
        }
		
	
        /* This line reads pin IRQ5, if SW2 is pushed it makes a shift in leds */ 	
        for (counter=1; counter<16 && (!(MCF_GPIO_SETNQ & MCF_GPIO_SETNQ_SETNQ5)); counter<<=1) {   
            /* Writting via Portn */
            MCF_GPIO_PORTTC = (unsigned char)counter;
            myDelay(50);	
        }
	

        /* Clear all 4 leds of PORTTC via CLRn (if no SW is pushed) */ 	
        MCF_GPIO_CLRTC = (unsigned char)255
        ^ MCF_GPIO_CLRTC_CLRTC0
        ^ MCF_GPIO_CLRTC_CLRTC1
        ^ MCF_GPIO_CLRTC_CLRTC2
        ^ MCF_GPIO_CLRTC_CLRTC3;	
    }
	

}

/*
 * functionName: myDelay: performs a delay with an
 * empty loop for debouncing and displying purposes.
 * 
 * Parameters: counter2 - determines how many times
 * the cycle is going to be repeated. 255 is approximately
 * 3.5 seconds. 
 *
 * Return : void
 */
 
void myDelay(unsigned char counter2){	
	volatile unsigned short counter1;
	while (counter2>0) {
		counter2--;
		for (counter1=1; counter1!=0; counter1++)
			;	
    }
}
