/*
 * File:	mcf5213.s
 * Purpose:	Low-level routines for the MCF5213/12/11.
 *
 * Notes:	
 */

#define cpu_startup _cpu_startup
#define startup __start
#define main		_main
#define mcf5213_init _mcf5213_init
#define __IPSBAR    ___IPSBAR   
#define __SRAM      ___SRAM     
#define __FLASH     ___FLASH    
	.extern __IPSBAR
	.extern __SRAM
	.extern __FLASH
	.extern __SP_INIT
	.extern mcf5213_init
    .extern startup
    .extern cpu_startup
	.extern main
    .extern ___call_static_initializers

	.global asm_startmeup
	.global _asm_startmeup
	.global d0_reset
	.global _d0_reset
	.global d1_reset
	.global _d1_reset

    .data
    
d0_reset:
_d0_reset:  .long   0
d1_reset:
_d1_reset:  .long   0

	.text

/********************************************************************
 * 
 * This is the main entry point upon hard reset.  The memory map is
 * setup based on linker file definitions, then the higher level
 * system initialization routine is called.  Finally, we jump to the
 * "main" process. 
 */
asm_startmeup:
_asm_startmeup:

	move.w	#0x2700,sr

	/* Initialize IPSBAR */
	move.l	#(___IPSBAR + 1),d0
	move.l	d0,0x40000000
	
	/* Initialize FLASHBAR: locate internal Flash and validate it */
	move.l	#(___FLASH + 0x21),d0
    movec d0,FLASHBAR

	/* Initialize RAMBAR1: locate SRAM and validate it */
	move.l	#(___SRAM + 0x21),d0
	movec d0,RAMBAR1

	/* Point Stack Pointer into SRAM temporarily */
	move.l	#__SP_INIT,sp
	
	/* Initialize mcf5282 periphs, etc */
	jsr		mcf5213_init

    jsr     ___call_static_initializers

	/* Relocate Stack Pointer */ 
	move.l	#__SP_INIT,sp

	/* Jump to the main process */
	jmp		main
	
	bra		.
	nop
	nop
	halt

/********************************************************************/

	.end
