/* template.c */
/* Displays and process HTML form */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "cgivars.h"
#include "htmllib.h"
#include "can4linux.h"
#include "can.h"

/* Form submit URL */
#define CGI_APPLICATION_URL "/cgi-bin/cgican"

#define ID_VAR "id"
#define COB_VAR "cob"
#define FLAGS_VAR "flags"
#define LENGTH_VAR "length"
#define BITRATE_VAR "bitrate"
#define CANRESET_VAR "canreset"
#define DATA_VAR "data"

/* Value/display pairs for Length HTML select control */
char* length_values[]={
		    "0", "0", 
		    "1", "1",
		    "2", "2",
		    "3", "3",
		    "4", "4",
		    "5", "5",
		    "6", "6",
		    "7", "7",
		    NULL};

/* Value/display pairs for Bit Rate HTML select control */
char* bitrate_values[]={
		    "20", "20K",
		    "50", "50K",
		    "100", "100K",
		    "125", "125K",
		    "250", "250K",
		    "500", "500K",
		    "800", "800K",
		    "1000", "1000K", 
		    NULL};

/* Value/Display pairs for Reset HTML select control */
char* reset_values[]={
		    "0", "No",
		    "1", "Yes",
		    NULL};
					  

/* Display HTML form */
int template_page(char **postvars, int form_method) {
	int i;
	canmsg_t message;
	int bitrate=125;
	int canreset=0;
	char buffer[20];
	
	/* Default CAN message parameters */
	message.id = 100;
	message.flags = 0;
	message.cob = 0;
	message.length = 7;
	for (i=0; i<CAN_MSG_LENGTH; i++) 
	    message.data[i] = 0;
	
	
	addTitleElement("CGI Demo. Sending CAN messages");

	/* Get the variables values from form if it is submitted */
	if(form_method == POST) {
		for (i=0; postvars[i]; i+=2) {
		    if (strcmp(postvars[i], ID_VAR)==0) {
			message.id = atoi(postvars[i+1]);
		    } else if (strcmp(postvars[i], COB_VAR)==0) {
			message.cob = atoi(postvars[i+1]);
		    } else if (strcmp(postvars[i], FLAGS_VAR)==0) {
			message.flags = atoi(postvars[i+1]);
		    } else if (strcmp(postvars[i], LENGTH_VAR)==0) {
			message.length = atoi(postvars[i+1]);
		    } else if (strcmp(postvars[i], BITRATE_VAR)==0) {
			bitrate = atoi(postvars[i+1]);
		    } else if (strcmp(postvars[i], CANRESET_VAR)==0) {
			canreset = atoi(postvars[i+1]);
		    } else if (strncmp(postvars[i], DATA_VAR, strlen(DATA_VAR))==0) {
			int data_index;
			data_index = atoi(postvars[i]+strlen(DATA_VAR));
			if (data_index>=0 && data_index<8) {
			    message.data[data_index] = atoi(postvars[i+1]);
			}
		    }
		}
		/* Send CAN message */
		if (can_open()!=-1) {
		    if (canreset) {
			can_reset();
		    }
		    can_set_bitrate(bitrate);
		    can_send_msg(&message);
		    can_close();
		} else {
		    printError("CANNOT OPEN CAN DEVICE!");
		    perror("CAN");
		    printf("<br>");
		}
		
	}

	/* Output form */
	printf("<form action=\"%s\" METHOD=POST>\n", CGI_APPLICATION_URL);
	printf("<table border='0'>\n");
	printf("<tr>\n");
	printInputTextInt("ID", ID_VAR, (int)message.id);
	printInputTextInt("COB", COB_VAR, message.cob);
	printf("</tr>\n");
	printf("<tr>\n");
	printInputTextInt("Flags", FLAGS_VAR, message.flags);
	snprintf(buffer, 20, "%d", message.length);
	printInputSelect("Length", LENGTH_VAR, buffer, length_values);
	printf("</tr>\n");
	printf("<tr>\n");
	snprintf(buffer, 20, "%d", bitrate); 
	printInputSelect("Bit Rate", BITRATE_VAR, buffer, bitrate_values);
	snprintf(buffer, 20, "%d", canreset);
	printInputSelect("Reset", CANRESET_VAR, buffer, reset_values);
	printf("</tr>\n");
	printf("<tr><td colspan='4'><table><tr>\n");
	printf("<td><b>Data:</b></td>\n");
	for (i=0;i<8;i++) {
		printf("<td><input type='text' name='%s%d' style='width: 50px;' value='%d'/></td>\n", 
			DATA_VAR, i, (int)message.data[i]);
	}
	printf("</tr></table></td></tr>\n");
	printf("</table>\n");
	printf("<input type='submit' value='Send CAN message'/>\n");
	printf("</form>\n");
	return 0;	
}


