cgican/can.c                                                                                        0100644 0000764 0000144 00000002203 10502524326 011752  0                                                                                                    ustar   b00738                          users                                                                                                                                                                                                                  /* can.c */
/* Sending message to CAN bus using Can4Linux driver */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>

#include "can.h"

/* Descriptor of CAN device */
static int can_fd = 0;

/* Opens CAN device */
int can_open() 
{
    can_fd = open(CAN_DEVICE, O_RDWR);
    if (can_fd == -1) {
	return -1;	
    }
    return 0;
}

/* Closes CAN device */
void can_close()
{
    if (can_fd>0) {
	close(can_fd);
	can_fd = 0;
    }
}

/* Reset CAN device */
void can_reset() 
{
    volatile Command_par_t cmd;
    cmd.cmd = CMD_RESET;
    ioctl(can_fd, COMMAND, cmd);    
}

/* Send the message to CAN bus */
int can_send_msg(canmsg_t* msg) 
{
    if (can_fd>0) {
	write(can_fd, msg, 1);
        return 0;
    }
    return -1;
}

/* Sets the bit rate using IOCTL call */
int can_set_bitrate(int baud) 
{
    Config_par_t cfg;
    volatile Command_par_t cmd;
    cmd.cmd = CMD_STOP;
    ioctl(can_fd, COMMAND, &cmd);
    cfg.target = CONF_TIMING;
    cfg.val1 = baud;
    ioctl(can_fd, CONFIG, &cfg);
    cmd.cmd = CMD_START;
    ioctl(can_fd, COMMAND, &cmd);
}
                                                                                                                                                                                                                                                                                                                                                                                             cgican/can.h                                                                                        0100644 0000764 0000144 00000000362 10502524340 011757  0                                                                                                    ustar   b00738                          users                                                                                                                                                                                                                  #ifndef _CAN_H_
#define _CAN_H_

#include "can4linux.h"

/* CAN device to be used */
#define CAN_DEVICE "/dev/can0"

int can_open();
void can_close();
void can_reset();
int can_send_msg(canmsg_t* msg);
int can_set_bitrate(int baud);


#endif
                                                                                                                                                                                                                                                                              cgican/cgi.c                                                                                        0100644 0000764 0000144 00000001426 10502524414 011757  0                                                                                                    ustar   b00738                          users                                                                                                                                                                                                                  /* cgi.c */
/* main function of sample CGI application */

#include <stdio.h>
#include <string.h>

#include "cgivars.h"
#include "htmllib.h"
#include "template.h"


int main() {
    char **postvars = NULL; /* POST request data repository */
    char **getvars = NULL; /* GET request data repository */
    int form_method; /* POST = 1, GET = 0 */  
	
    form_method = getRequestMethod();

    if(form_method == POST) {
        getvars = getGETvars();
        postvars = getPOSTvars();
    } else if(form_method == GET) {
        getvars = getGETvars();
    }

    htmlHeader("Send CAN Messages");
    htmlBody();
		
    /* display/process form */
    template_page(postvars, form_method);

    htmlFooter();
    cleanUp(form_method, getvars, postvars);

    fflush(stdout);
    exit(0);
}
                                                                                                                                                                                                                                          cgican/cgivars.c                                                                                    0100644 0000764 0000144 00000010160 07320013504 012643  0                                                                                                    ustar   b00738                          users                                                                                                                                                                                                                  /* cgivars.c
 * (C) Copyright 2000, Moreton Bay (http://www.moretonbay.com).
 * see HTTP (www.w3.org) and RFC
 */
 
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "cgivars.h"

/* local function prototypes */
char hex2char(char *hex);
void unescape_url(char *url);
char x2c(char *what);

/* hex2char */
/* RFC */
char hex2char(char *hex) {
	char char_value;
	char_value = (hex[0] >= 'A' ? ((hex[0] & 0xdf) - 'A') + 10 : (hex[0] - '0'));
	char_value *= 16;
	char_value += (hex[1] >= 'A' ? ((hex[1] & 0xdf) - 'A') + 10 : (hex[1] - '0'));
	return char_value;
}

/* unescape_url */
/* RFC */
void unescape_url(char *url) {
	int n, k;
	for(n=0, k=0;url[k];++n, ++k) {
		if((url[n] = url[k]) == '%') {
			url[n] = hex2char(&url[k+1]);
			k += 2;
		}
	}
	url[n] = '\0';
}


/* getRequestMethod
 * retn:	from_method (GET or POST) on success,
 *			-1 on failure.  */
int getRequestMethod() {
	char *request_method;
	int form_method;

	request_method = getenv("REQUEST_METHOD");
	if(request_method == NULL)
		return -1;

	if (!strcmp(request_method, "GET") || !strcmp(request_method, "HEAD") ) {
		form_method = GET;
	} else if (!strcmp(request_method, "POST")) {
		form_method = POST;
	} else {
		/* wtf was it then?!! */
		return -1;
	}
	return form_method;
}


/* getGETvars
 * retn:	getvars */
char **getGETvars() {
	int i;
	char **getvars;
	char *getinput;
	char **pairlist;
	int paircount = 0;
	char *nvpair;
	char *eqpos;

	getinput = getenv("QUERY_STRING");
	if (getinput)
		getinput = strdup(getinput);

	/* Change all plusses back to spaces */
   	for(i=0; getinput && getinput[i]; i++)
		if(getinput[i] == '+')
			getinput[i] = ' ';

   	pairlist = (char **) malloc(256*sizeof(char **));
	paircount = 0;
   	nvpair = getinput ? strtok(getinput, "&") : NULL;
	while (nvpair) {
		pairlist[paircount++]= strdup(nvpair);
        	if(!(paircount%256))
			pairlist = (char **) realloc(pairlist,(paircount+256)*sizeof(char **));
       		nvpair = strtok(NULL, "&");
	}

   	pairlist[paircount] = 0;
   	getvars = (char **) malloc((paircount*2+1)*sizeof(char **));
	for (i= 0; i<paircount; i++) {
		if(eqpos=strchr(pairlist[i], '=')) {
       	    		*eqpos = '\0';
            		unescape_url(getvars[i*2+1] = strdup(eqpos+1));
   	    	} else {
			unescape_url(getvars[i*2+1] = strdup(""));
        	}
		unescape_url(getvars[i*2] = strdup(pairlist[i]));
    	}
   	getvars[paircount*2] = 0;
    	for(i=0;pairlist[i];i++)
		free(pairlist[i]);
	free(pairlist);
	if (getinput)
		free(getinput);
	return getvars;
}


/* getPOSTvars
 * retn:	postvars */
char **getPOSTvars() {
	int i;
	int content_length;
	char **postvars;
	char *postinput;
	char **pairlist;
	int paircount = 0;
	char *nvpair;
	char *eqpos;
	
	postinput = getenv("CONTENT_LENGTH");
	if (!postinput)
		exit(1);
	if(!(content_length = atoi(postinput)))
		exit(1);
	if(!(postinput = (char *) malloc(content_length+1)))
		exit(1);
	if (!fread(postinput, content_length, 1, stdin))
		exit(1);
	postinput[content_length] = '\0';
	

   	for(i=0;postinput[i];i++)
		if(postinput[i] == '+')
			postinput[i] = ' ';

	pairlist = (char **) malloc(256*sizeof(char **));
	paircount = 0;
	nvpair = strtok(postinput, "&");
	while (nvpair) {
		pairlist[paircount++] = strdup(nvpair);
		if(!(paircount%256))
    			pairlist = (char **) realloc(pairlist, (paircount+256)*sizeof(char **));
		nvpair = strtok(NULL, "&");
	}
    
	pairlist[paircount] = 0;
	postvars = (char **) malloc((paircount*2+1)*sizeof(char **));
	for(i = 0;i<paircount;i++) {
        	if(eqpos = strchr(pairlist[i], '=')) {
       	    		*eqpos= '\0';
	        	unescape_url(postvars[i*2+1] = strdup(eqpos+1));
        	} else {
       	    		unescape_url(postvars[i*2+1] = strdup(""));
	   	}
        	unescape_url(postvars[i*2]= strdup(pairlist[i]));
	}
	postvars[paircount*2] = 0;

	for(i=0;pairlist[i];i++)
		free(pairlist[i]);
	free(pairlist);
	free(postinput);

	return postvars;
}

/* cleanUp
 * free the mallocs */
int cleanUp(int form_method, char **getvars, char **postvars) {
	int i;

	if (postvars) {
		for(i=0;postvars[i];i++)
			free(postvars[i]);
		free(postvars);
	}
	if (getvars) {
		for(i=0;getvars[i];i++)
			free(getvars[i]);
		free(getvars);
	}

	return 0;
}
                                                                                                                                                                                                                                                                                                                                                                                                                cgican/cgivars.h                                                                                    0100644 0000764 0000144 00000000433 07045720571 012667  0                                                                                                    ustar   b00738                          users                                                                                                                                                                                                                  /* cgivars.h */

#ifndef _CGIVARS_H
#define _CGIVARS_H

/* method */
#define GET	0
#define POST	1


/* function prototypes */
int getRequestMethod();
char **getGETvars();
char **getPOSTvars();
int cleanUp(int form_method, char **getvars, char **postvars);


#endif	/* !_CGIVARS_H */
                                                                                                                                                                                                                                     cgican/htmllib.c                                                                                    0100644 0000764 0000144 00000002631 10502013304 012636  0                                                                                                    ustar   b00738                          users                                                                                                                                                                                                                  /* htmllib.c
 * HTML common library functions for the CGI programs. */

#include <stdio.h>
#include <string.h>
#include "htmllib.h"


void htmlHeader(char *title) {
  printf("Content-type: text/html\n\n<html><head><title>%s</title></head>",
		  title);
}

void htmlBody() {
    printf("<body>");
}

void htmlFooter() {
    printf("</body></html>");
}

void addTitleElement(char *title) {
	printf("<h1>%s</h1>", title);
}

void printInputTextInt(char* name, char* var, int default_value) {
    char buffer[20];
    snprintf(buffer, 20, "%d", default_value);
    printInputText(name,var,buffer);
}

void printInputText(char* name, char* var, char* default_value) {
	printf("<td><b>%s:</b></td>\n", name);
	printf("<td><input type='text' name='%s' style='width: 70px;' value='%s'/></td>\n", var, default_value);
}

void printInputSelect(char* name, char* var, char* default_value, char** values) {
	printf("<td><b>%s:</b></td>\n", name);
	printf("<td><select name='%s'>\n", var);
	if (values!=NULL) {
		char* value;
		int i=0;
		while ((value=values[i])!=NULL) {
			printf("<option value='%s'", value);
			if (strcmp(value,default_value)==0) {
			    printf(" selected");
			}
			printf(">");
			++i;
			value = values[i];
			if (value!=NULL) {
				printf("%s", value);
				++i;
			}
			printf("</option>\n");
		}
	}
	printf("</select></td>\n");
}

void printError(char* msg)
{
    printf("<br><font color='red'>%s</font><br>", msg);
}
                                                                                                       cgican/htmllib.h                                                                                    0100644 0000764 0000144 00000000677 10502013225 012655  0                                                                                                    ustar   b00738                          users                                                                                                                                                                                                                  /* htmllib.h */

#ifndef _HTMLLIB_H
#define _HTMLLIB_H

/* function prototypes */
void htmlHeader(char *title);
void htmlBody();
void htmlFooter();
void addTitleElement(char *title);
void printInputSelect(char* name, char* var, char* default_value, char** values);
void printInputText(char* name, char* var,char* default_value);
void printInputTextInt(char* name, char* var,int default_value);
void printError(char* msg);

#endif	/* !_HTMLLIB_H*/
                                                                 cgican/Makefile                                                                                     0100644 0000764 0000144 00000000512 10502013001 012465  0                                                                                                    ustar   b00738                          users                                                                                                                                                                                                                  
EXEC = cgican
OBJS = cgi.o cgivars.o htmllib.o template.o can.o

all: $(EXEC)

romfs:
	$(ROMFSINST) $(ROOTDIR)/vendors/Generic/httpd /home/httpd
	$(ROMFSINST) /home/httpd/cgi-bin/cgican

$(EXEC): $(OBJS)
	$(CC) $(LDFLAGS) -o $@ $(OBJS) $(LDLIBS)

clean:
	-rm -f $(EXEC) *.elf *.gdb *.o
	

$(OBJS): cgivars.h htmllib.h template.h
                                                                                                                                                                                      cgican/template.c                                                                                   0100644 0000764 0000144 00000007304 10502524170 013030  0                                                                                                    ustar   b00738                          users                                                                                                                                                                                                                  /* template.c */
/* Displays and process HTML form */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "cgivars.h"
#include "htmllib.h"
#include "can4linux.h"
#include "can.h"

/* Form submit URL */
#define CGI_APPLICATION_URL "/cgi-bin/cgican"

#define ID_VAR "id"
#define COB_VAR "cob"
#define FLAGS_VAR "flags"
#define LENGTH_VAR "length"
#define BITRATE_VAR "bitrate"
#define CANRESET_VAR "canreset"
#define DATA_VAR "data"

/* Value/display pairs for Length HTML select control */
char* length_values[]={
		    "0", "0", 
		    "1", "1",
		    "2", "2",
		    "3", "3",
		    "4", "4",
		    "5", "5",
		    "6", "6",
		    "7", "7",
		    NULL};

/* Value/display pairs for Bit Rate HTML select control */
char* bitrate_values[]={
		    "20", "20K",
		    "50", "50K",
		    "100", "100K",
		    "125", "125K",
		    "250", "250K",
		    "500", "500K",
		    "800", "800K",
		    "1000", "1000K", 
		    NULL};

/* Value/Display pairs for Reset HTML select control */
char* reset_values[]={
		    "0", "No",
		    "1", "Yes",
		    NULL};
					  

/* Display HTML form */
int template_page(char **postvars, int form_method) {
	int i;
	canmsg_t message;
	int bitrate=125;
	int canreset=0;
	char buffer[20];
	
	/* Default CAN message parameters */
	message.id = 100;
	message.flags = 0;
	message.cob = 0;
	message.length = 7;
	for (i=0; i<CAN_MSG_LENGTH; i++) 
	    message.data[i] = 0;
	
	
	addTitleElement("CGI Demo. Sending CAN messages");

	/* Get the variables values from form if it is submitted */
	if(form_method == POST) {
		for (i=0; postvars[i]; i+=2) {
		    if (strcmp(postvars[i], ID_VAR)==0) {
			message.id = atoi(postvars[i+1]);
		    } else if (strcmp(postvars[i], COB_VAR)==0) {
			message.cob = atoi(postvars[i+1]);
		    } else if (strcmp(postvars[i], FLAGS_VAR)==0) {
			message.flags = atoi(postvars[i+1]);
		    } else if (strcmp(postvars[i], LENGTH_VAR)==0) {
			message.length = atoi(postvars[i+1]);
		    } else if (strcmp(postvars[i], BITRATE_VAR)==0) {
			bitrate = atoi(postvars[i+1]);
		    } else if (strcmp(postvars[i], CANRESET_VAR)==0) {
			canreset = atoi(postvars[i+1]);
		    } else if (strncmp(postvars[i], DATA_VAR, strlen(DATA_VAR))==0) {
			int data_index;
			data_index = atoi(postvars[i]+strlen(DATA_VAR));
			if (data_index>=0 && data_index<8) {
			    message.data[data_index] = atoi(postvars[i+1]);
			}
		    }
		}
		/* Send CAN message */
		if (can_open()!=-1) {
		    if (canreset) {
			can_reset();
		    }
		    can_set_bitrate(bitrate);
		    can_send_msg(&message);
		    can_close();
		} else {
		    printError("CANNOT OPEN CAN DEVICE!");
		    perror("CAN");
		    printf("<br>");
		}
		
	}

	/* Output form */
	printf("<form action=\"%s\" METHOD=POST>\n", CGI_APPLICATION_URL);
	printf("<table border='0'>\n");
	printf("<tr>\n");
	printInputTextInt("ID", ID_VAR, (int)message.id);
	printInputTextInt("COB", COB_VAR, message.cob);
	printf("</tr>\n");
	printf("<tr>\n");
	printInputTextInt("Flags", FLAGS_VAR, message.flags);
	snprintf(buffer, 20, "%d", message.length);
	printInputSelect("Length", LENGTH_VAR, buffer, length_values);
	printf("</tr>\n");
	printf("<tr>\n");
	snprintf(buffer, 20, "%d", bitrate); 
	printInputSelect("Bit Rate", BITRATE_VAR, buffer, bitrate_values);
	snprintf(buffer, 20, "%d", canreset);
	printInputSelect("Reset", CANRESET_VAR, buffer, reset_values);
	printf("</tr>\n");
	printf("<tr><td colspan='4'><table><tr>\n");
	printf("<td><b>Data:</b></td>\n");
	for (i=0;i<8;i++) {
		printf("<td><input type='text' name='%s%d' style='width: 50px;' value='%d'/></td>\n", 
			DATA_VAR, i, (int)message.data[i]);
	}
	printf("</tr></table></td></tr>\n");
	printf("</table>\n");
	printf("<input type='submit' value='Send CAN message'/>\n");
	printf("</form>\n");
	return 0;	
}


                                                                                                                                                                                                                                                                                                                            cgican/template.h                                                                                   0100644 0000764 0000144 00000000170 10502524216 013030  0                                                                                                    ustar   b00738                          users                                                                                                                                                                                                                  /* template.h */
#ifndef _TEMPLATE_H
#define _TEMPLATE_H

int template_page(char **postvars, int form_method);

#endif

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        