;*******************************************************************************************
;       MAIN.ASM
;*******************************************************************************************
; Copyright (c) 2006 Freescale Semiconductor
; http://www.freescale.com/
;*******************************************************************************************
;
; Fridge control using MC9S08KA2 Microcontroller
; ------------------------------------------------------------------------------------------
; Temperature Sensor  
; Potenciometer for temperature control  
;
;*******************************************************************************************

 INCLUDE 'derivative.inc'                ; Include derivative-specific definitions

; export symbols
            XDEF _Startup
            ABSENTRY _Startup

         
; Variable declarations
ACMP_ENABLE      SET   $92
ACMP_DISABLED    SET   $20
MTIM_INIT        SET   $50
MTIM_ENABLE      SET   $40
MTIM_STOP_RESET  SET   $30
MTIM_64_DIV      SET   $06
FREE_RUN         SET   $00
DEBUG_MODE       SET   $00
RUN_MODE         SET   $01


control			SET	$04
output			SET $05

TEMP1_ON		SET 94
TEMP1_OFF		SET 100
TEMP2_ON		SET 98
TEMP2_OFF		SET 104
TEMP3_ON		SET 102
TEMP3_OFF		SET 108
TEMP4_ON		SET 106
TEMP4_OFF		SET 112

MODE:            EQU    DEBUG_MODE                																              

; variable/data section
    ORG    RAMStart                   

ADCValue:		DS.B	1
counter         DS.B    1
ControlValue	DS.B	1


; code section
     ORG    ROMStart
 

;**************************************************************
;*                       MACRO DECLARATION                    *
;**************************************************************

TRIM_ICS: MACRO                       ; Macro used to configure the ICS with TRIM
	mov #$FF,PAGESEL                  ; change to last page
    lda  #$FA                         ; load the content which TRIM value is store
    tax                               ; move A content to X
    lda  ,x                           ; read D[X]
    sta  ICSTRM                       ; Store TRIM value
    ENDM

ACK_RTI: MACRO
	mov #HIGH_6_13(SRTISC), PAGESEL  
    bset 6,MAP_ADDR_6(SRTISC)      	                                   
	ENDM



;**************************************************************
;*             Comparation (Control vs Temp)                  *
;**************************************************************
comparation:
    lda ControlValue
	cmp #65
    blo Temp1_4
	cmp #130
    blo Temp2_4
	cmp #195
    blo Temp3_4

	
	mov #04,ControlValue 			; selector = 4 (Coldest)
	lda ADCValue
	cmp #TEMP4_ON
	blo Compresor_ON
	cmp #TEMP4_OFF
	bhs Compresor_OFF
    rts

Temp3_4:
	mov #03,ControlValue			; selector = 3 (Mid-Low)
	lda ADCValue
	cmp #TEMP3_ON
	blo Compresor_ON
	cmp #TEMP3_OFF
	bhs Compresor_OFF
    rts

Temp2_4:
	mov #02,ControlValue		   	; selector = 2 (Mid-High)
	lda ADCValue
	cmp #TEMP2_ON
	blo Compresor_ON
	cmp #TEMP2_OFF
	bhs Compresor_OFF
    rts
	
Temp1_4:
	mov #01,ControlValue			; selector = 1 (Hot)
	lda ADCValue
	cmp #TEMP1_ON
	blo Compresor_ON
	cmp #TEMP1_OFF
	bhs Compresor_OFF
	rts

Compresor_ON:	 					; Compresor ON
	bset output,PTAD
	rts
Compresor_OFF:						; Compresor OFF
	bclr output,PTAD
	rts

;**************************************************************
;*                    CONFIGURES SYSTEM CONTROL               *
;**************************************************************
Init_mc: 
	mov #HIGH_6_13(SOPT), PAGESEL  
    mov #$E3, MAP_ADDR_6(SOPT)      	; Enable STOP mode and COP with long timeout period                                  
    clr  ICSC1                      	; FLL is selected as Bus Clock
    TRIM_ICS
    clr  ICSC2
    bset output,PTADD					; Enable PTA5 as output
    rts

;**************************************************************
;*            Modulus Timer Configuration for ADC             *
;**************************************************************
 MTIM_ADC_Init:
    mov #MTIM_64_DIV,MTIMCLK         	; Select bus clock as reference, Set prescaler with 64
    mov #FREE_RUN,MTIMMOD             	; Configure Timer as free running
    mov #MTIM_STOP_RESET,MTIMSC
    rts

;**************************************************************
;*                  ADC Single Conversion                     *
;**************************************************************
ADC_Single_conversion:
	
	; Discharge Capacitor

	bset 1,PTADD						
	bclr 1,PTAD	
    lda  #$FE                        
waste:   
    dbnza waste                 
	
	; Start Conversion
    mov #ACMP_ENABLE,ACMPSC           	; ACMP Enabled, ACMP+ pin active, Interrupt enabled, Rising edges detections
    mov #MTIM_ENABLE,MTIMSC           	; Timer Counter Enabled
	wait						      	; Wait for Analog Comparator Interrupt (match signals)
    bset 4,MTIMSC					  	; Stop MTIM
    lda MTIMCNT                       	; read counter timer value
    sta ADCValue                  		; store counter value
    mov #MTIM_STOP_RESET,MTIMSC       	; Stop and reset counter

    mov #HIGH_6_13(SIP1), PAGESEL     
    brset 3, MAP_ADDR_6(SIP1),Conv_OK 	; branch if ACMP interrupt arrives
    bra ADC_Single_conversion
    
    ; Comparator Interrupt OK
Conv_OK:    
    mov #ACMP_DISABLED, ACMPSC        	; ACMP Disabled, Clear Interrupt flag
    rts

;**************************************************************
;*                     Control Value                          *
;**************************************************************
Pin_Measure:
	bset control,PTADD					; Set control pin as Output
	bclr control,PTAD					; Discharge RC network
	clr ControlValue
    lda  #$FE                        
Discharge2:   
    dbnza Discharge2                 
    bclr control,PTADD					; Set Control pin as Input
measure_pin:
	inc ControlValue
	brclr control,PTAD,measure_pin		; Inc value while pin is in low state
	rts


;**************************************************************
;*               RTI Module Configuration                     *
;**************************************************************
Init_RTI:
	mov #HIGH_6_13(SRTISC), PAGESEL  
    mov #$37, MAP_ADDR_6(SRTISC)      	; Enable RTI (1 sec period)                                  
	rts

;**************************************************************
;*                         MAIN                               *
;**************************************************************
_Startup:
    bsr Init_mc
	bsr Init_RTI
    bsr MTIM_ADC_Init                 	; Configure MITM for ADC module
    ; Application Loop
mainLoop:
	feed_watchdog						; Clear COP timer
	bsr ADC_Single_conversion		  	; ADC Conversion
    bsr Pin_Measure						; Control Measure
	jsr comparation						; Comparation
	stop								; Enter in STOP mode 
    ACK_RTI								; Ack for RTI Interrupt
    bra mainLoop        

;**************************************************************
;*                 Startup Vector                             *
;**************************************************************
      ORG   $3FFD
      JMP _Startup                      ; Reset