
/************************************************************************************************/
/*                                      Includes Section                                        */
/************************************************************************************************/
#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "LCD.h"
/************************************************************************************************/
/*                                     Constants Section                                        */
/************************************************************************************************/
unsigned char const TestMsg[] = {"123456789 FREESCALE SEMICONDUCTOR INC"};

const unsigned char boot@0x040A = 0x0000; //zero out checksum to bypass boot loader

/************************************************************************************************/
/*                                Function Prototipes Section                                   */
/************************************************************************************************/


/************************************************************************************************/
/*                                Global Variables Section                                      */
/************************************************************************************************/


/************************************************************************************************/
/*                                      Functions Section                                       */
/************************************************************************************************/

/********     FLL Engaged Internal Clock     ********/
/*****         Bus Frequency = 8 MHz         *****/
void UseMCUClock(void)
{
     MCGC1 = 0x03;
     MCGC2 = 0x17;
//     MCGTRM = NV1MCGTRM;
     MCGTRM = 0x97;
     MCGSC = 0x61;
}
     
/*******       FLL Bypassed External Clock        *******/
/*******     Bus Frequency = External Clock/2     *******/
void UseExternalClock(void)
{
     MCGC1 = 0xB8;
     MCGC2 = 0x00;
     MCGSC = 0x00;
}

/*******       FLL Engaged External Clock        *******/
/*******         Bus Frequency = 24 MHz          *******/
void UsePLLOutput(void)
{
     MCGC1 = 0x98;
     MCGC2 = 0x37;
     MCGC3 = 0x46;
     while(!MCGSC_OSCINIT)
     {
          __RESET_WATCHDOG();
     }
     MCGC1 = 0x18;
     while(!MCGSC_LOCK)
     {
          __RESET_WATCHDOG();
     }
}

void main(void)
{
     unsigned int u16Delay = 0;
     unsigned long u32Counter = 200000;
     unsigned char u8ContrastFlag = 0;
     unsigned char u8Index = 0;
     unsigned char u8Test1Flag = 0;
     
//     SOPT1 = 0x23;                                   /* disable COP; enable stop an wait mode */


//     UseMCUClock();
//     UseExternalClock();
     UsePLLOutput();
     

     vfnLCDInit();                                     /* Config LCD Driver */

     /*********         Code Example        *********/

     LCDBuffer[0].u16Word = gau16CharactersArray[u8Index];
     LCDBuffer[1].u16Word = gau16CharactersArray[u8Index];
     LCDBuffer[2].u16Word = gau16CharactersArray[u8Index];
     LCDBuffer[3].u16Word = gau16CharactersArray[u8Index];
     LCDBuffer[4].u16Word = gau16CharactersArray[u8Index];
     LCDBuffer[5].u16Word = gau16CharactersArray[u8Index];
     LCDBuffer[6].u16Word = gau16CharactersArray[u8Index];
     LCDBuffer[7].u16Word = gau16CharactersArray[u8Index];
     u8Index++;
     
     EnableInterrupts;                                 /* enable interrupts */
     


/*
     LCDBuffer[0].u16Word = 0xFFFF;
     LCDBuffer[1].u16Word = 0xFFFF;
     LCDBuffer[2].u16Word = 0xFFFF;
     LCDBuffer[3].u16Word = 0xFFFF;
     LCDBuffer[4].u16Word = 0xFFFF;
     LCDBuffer[5].u16Word = 0xFFFF;
     LCDBuffer[6].u16Word = 0xFFFF;
     LCDBuffer[7].u16Word = 0xFFFF;
     
     g16ContrastValue = CONSTRAST_LOW;
     
     for(;;)
     {
          __RESET_WATCHDOG();
          
          vfnLCDDriver();

     }
*/
     
     
     
     for(;;)
     {
          __RESET_WATCHDOG();                          /* feeds the dog */
          
          vfnLCDDriver();                              /* Call LCD Driver */
          
          if (!u8Test1Flag)
          {
               /**************         Run Test 1          **************/
               if((u16Delay++)>340)
               {
                    u16Delay = 0;
                    
                    if(!u8ContrastFlag)
                    {
                         g16ContrastValue++;
                         if(g16ContrastValue == 3000)
                         {
                              u8ContrastFlag = 1;
                         }
                    }
                    else
                    {
                         if(g16ContrastValue >150)
                         {
                              g16ContrastValue--;
                         }
                         else
                         {
                              u8ContrastFlag = 0;
                              LCDBuffer[0].u16Word = gau16CharactersArray[u8Index];
                              LCDBuffer[1].u16Word = gau16CharactersArray[u8Index];
                              LCDBuffer[2].u16Word = gau16CharactersArray[u8Index];
                              LCDBuffer[3].u16Word = gau16CharactersArray[u8Index];
                              LCDBuffer[4].u16Word = gau16CharactersArray[u8Index];
                              LCDBuffer[5].u16Word = gau16CharactersArray[u8Index];
                              LCDBuffer[6].u16Word = gau16CharactersArray[u8Index];
                              LCDBuffer[7].u16Word = gau16CharactersArray[u8Index];
                              u8Index++;
                              if (u8Index == 11)
                              {
                                   u8Index = 0;
                                   u8Test1Flag = 1;
                                   g16ContrastValue = CONSTRAST_LOW;
                              }
                         }
                    }
               }               
          }
          else
          {
               /**************         Run Test 2          **************/
               if(!(--u32Counter))
               {
                    u32Counter = 200000;
                    vfnLCDPrintMessage((unsigned char *)(&TestMsg[0]),sizeof(TestMsg));
               }
          }
     }
}
