// ============================================================================
//  Copyright (c)2007 Freescale Semiconductor Inc.  -- All Rights Reserved --
//
//  The code is the property of Freescale GmbH Munich
//  C&I GTM Operation
//
//  The copyright notice above does not evidence any actual or intended 
//  publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any expressed or implied
//  warrenties, including, but not limited to, the implied warrenties of 
//  merchantability and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be liable for any direct, 
//  indirect, incidental, special, examplary, or consequential damages 
//  (including, but not limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption). However caused 
//  and on any theory of liability, whether in contract, strict liability, or
//  tort (including negligence or otherwise) arising in any way out of the use 
//  of this software, even if advised of the possibility of such damage.
// 
//  ---------------------------------------------------------------------------
//
//  Filename:     $Source: $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: $
//  Revision:     $Revision: $
//
//  Functions:    
//
//  History:      Use the CVS command log to display revision history information.
//
//  Description:  file for font data 
//
//  Notes:        
//                
//
//
// ============================================================================

#include "Font.h"

//-----------------------------------------------------------------------------
// Font 5x8px  (ASCII)
// offset of 32 -> starts with "space" = FONT5X7 [0][5] (32)
//                           up to "~" = FONT5X7 [94][5] (126)
// total of 95*5 = 475 Byte
//-----------------------------------------------------------------------------
const char FONT5X7 [][5] =  {
  { 0x00, 0x00, 0x00, 0x00, 0x00 }, // space
  { 0x00, 0x00, 0x2f, 0x00, 0x00 }, // ! 
  { 0x00, 0x07, 0x00, 0x07, 0x00 }, // "
  { 0x14, 0x7f, 0x14, 0x7f, 0x14 }, // #
  { 0x24, 0x2a, 0x7f, 0x2a, 0x12 }, // $
  { 0xc4, 0xc8, 0x10, 0x26, 0x46 }, // %
  { 0x36, 0x49, 0x55, 0x22, 0x50 }, // &
  { 0x00, 0x05, 0x03, 0x00, 0x00 }, // '
  { 0x00, 0x1c, 0x22, 0x41, 0x00 }, // (
  { 0x00, 0x41, 0x22, 0x1c, 0x00 }, // )
  { 0x14, 0x08, 0x3E, 0x08, 0x14 }, // *
  { 0x08, 0x08, 0x3E, 0x08, 0x08 }, // +
  { 0x00, 0x00, 0x50, 0x30, 0x00 }, // ,
  { 0x10, 0x10, 0x10, 0x10, 0x10 }, // -
  { 0x00, 0x60, 0x60, 0x00, 0x00 }, // .
  { 0x20, 0x10, 0x08, 0x04, 0x02 }, // /
  { 0x3E, 0x51, 0x49, 0x45, 0x3E }, // 0
  { 0x00, 0x42, 0x7F, 0x40, 0x00 }, // 1
  { 0x42, 0x61, 0x51, 0x49, 0x46 }, // 2
  { 0x21, 0x41, 0x45, 0x4B, 0x31 }, // 3
  { 0x18, 0x14, 0x12, 0x7F, 0x10 }, // 4  
  { 0x27, 0x45, 0x45, 0x45, 0x39 }, // 5
  { 0x3C, 0x4A, 0x49, 0x49, 0x30 }, // 6
  { 0x01, 0x71, 0x09, 0x05, 0x03 }, // 7
  { 0x36, 0x49, 0x49, 0x49, 0x36 }, // 8
  { 0x06, 0x49, 0x49, 0x29, 0x1E }, // 9
  { 0x00, 0x36, 0x36, 0x00, 0x00 }, // :
  { 0x00, 0x56, 0x36, 0x00, 0x00 }, // ;
  { 0x08, 0x14, 0x22, 0x41, 0x00 }, // <
  { 0x14, 0x14, 0x14, 0x14, 0x14 }, // =
  { 0x00, 0x41, 0x22, 0x14, 0x08 }, // >
  { 0x02, 0x01, 0x51, 0x09, 0x06 }, // ?
  { 0x32, 0x49, 0x59, 0x51, 0x3E }, // @
  { 0x7E, 0x11, 0x11, 0x11, 0x7E }, // A
  { 0x7F, 0x49, 0x49, 0x49, 0x36 }, // B
  { 0x3E, 0x41, 0x41, 0x41, 0x22 }, // C
  { 0x7F, 0x41, 0x41, 0x22, 0x1C }, // D
  { 0x7F, 0x49, 0x49, 0x49, 0x41 }, // E
  { 0x7F, 0x09, 0x09, 0x09, 0x01 }, // F
  { 0x3E, 0x41, 0x49, 0x49, 0x7A }, // G
  { 0x7F, 0x08, 0x08, 0x08, 0x7F }, // H
  { 0x00, 0x41, 0x7F, 0x41, 0x00 }, // I
  { 0x20, 0x40, 0x41, 0x3F, 0x01 }, // J
  { 0x7F, 0x08, 0x14, 0x22, 0x41 }, // K
  { 0x7F, 0x40, 0x40, 0x40, 0x40 }, // L
  { 0x7F, 0x02, 0x0C, 0x02, 0x7F }, // M
  { 0x7F, 0x04, 0x08, 0x10, 0x7F }, // N
  { 0x3E, 0x41, 0x41, 0x41, 0x3E }, // O
  { 0x7F, 0x09, 0x09, 0x09, 0x06 }, // P
  { 0x3E, 0x41, 0x51, 0x21, 0x5E }, // Q
  { 0x7F, 0x09, 0x19, 0x29, 0x46 }, // R
  { 0x46, 0x49, 0x49, 0x49, 0x31 }, // S
  { 0x01, 0x01, 0x7F, 0x01, 0x01 }, // T
  { 0x3F, 0x40, 0x40, 0x40, 0x3F }, // U
  { 0x1F, 0x20, 0x40, 0x20, 0x1F }, // V
  { 0x3F, 0x40, 0x38, 0x40, 0x3F }, // W
  { 0x63, 0x14, 0x08, 0x14, 0x63 }, // X
  { 0x07, 0x08, 0x70, 0x08, 0x07 }, // Y
  { 0x61, 0x51, 0x49, 0x45, 0x43 }, // Z
  { 0x00, 0x7F, 0x41, 0x41, 0x00 }, // [
  { 0x02, 0x04, 0x08, 0x10, 0x20 }, // backslash
  { 0x00, 0x41, 0x41, 0x7F, 0x00 }, // ]
  { 0x04, 0x02, 0x01, 0x02, 0x04 }, // ^
  { 0x40, 0x40, 0x40, 0x40, 0x40 }, // _
  { 0x00, 0x01, 0x02, 0x04, 0x00 }, // '
  { 0x20, 0x54, 0x54, 0x54, 0x78 }, // a
  { 0x7F, 0x48, 0x44, 0x44, 0x38 }, // b
  { 0x38, 0x44, 0x44, 0x44, 0x20 }, // c
  { 0x38, 0x44, 0x44, 0x48, 0x7F }, // d
  { 0x38, 0x54, 0x54, 0x54, 0x18 }, // e
  { 0x08, 0x7E, 0x09, 0x01, 0x02 }, // f
  { 0x0C, 0x52, 0x52, 0x52, 0x3E }, // g
  { 0x7F, 0x08, 0x04, 0x04, 0x78 }, // h
  { 0x00, 0x44, 0x7D, 0x40, 0x00 }, // i
  { 0x20, 0x40, 0x44, 0x3D, 0x00 }, // j
  { 0x7F, 0x10, 0x28, 0x44, 0x00 }, // k
  { 0x00, 0x41, 0x7F, 0x40, 0x00 }, // l
  { 0x7C, 0x04, 0x18, 0x04, 0x78 }, // m
  { 0x7C, 0x08, 0x04, 0x04, 0x78 }, // n
  { 0x38, 0x44, 0x44, 0x44, 0x38 }, // o
  { 0x7C, 0x14, 0x14, 0x14, 0x08 }, // p
  { 0x08, 0x14, 0x14, 0x18, 0x7C }, // q
  { 0x7C, 0x08, 0x04, 0x04, 0x08 }, // r
  { 0x48, 0x54, 0x54, 0x54, 0x20 }, // s
  { 0x04, 0x3F, 0x44, 0x40, 0x20 }, // t
  { 0x3C, 0x40, 0x40, 0x20, 0x7C }, // u
  { 0x1C, 0x20, 0x40, 0x20, 0x1C }, // v
  { 0x3C, 0x40, 0x30, 0x40, 0x3C }, // w
  { 0x44, 0x28, 0x10, 0x28, 0x44 }, // x
  { 0x0C, 0x50, 0x50, 0x50, 0x3C }, // y
  { 0x44, 0x64, 0x54, 0x4C, 0x44 }, // z
  { 0x08, 0x36, 0x41, 0x41, 0x00 }, // {
  { 0x00, 0x00, 0x3F, 0x00, 0x00 }, // |
  { 0x00, 0x41, 0x41, 0x36, 0x08 }, // } 
  { 0x10, 0x08, 0x10, 0x20, 0x10 }, // ~  
};

//-----------------------------------------------------------------------------
// Font 8x15px  (ASCII)
// offset of 32 -> starts with "space" = FONT8X15  [0][8][2] (32)
//                           up to "~" = FONT8X15 [94][8][2] (126)
// total of 95*16 = 1520 Byte
//-----------------------------------------------------------------------------
const char FONT8X15 [][8][2] =  {
{ {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00} } , // space  
{ {0x00, 0x00}, {0x00, 0x00}, {0x3E, 0x00}, {0xFF, 0x0D}, {0xFF, 0x0D}, {0x3E, 0x00}, {0x00, 0x00}, {0x00, 0x00} } , // !   
{ {0x00, 0x00}, {0x04, 0x00}, {0x07, 0x00}, {0x03, 0x00}, {0x00, 0x00}, {0x04, 0x00}, {0x07, 0x00}, {0x03, 0x00} } , // "   
{ {0x10, 0x01}, {0xFE, 0x0F}, {0xFE, 0x0F}, {0x10, 0x01}, {0x10, 0x01}, {0xFE, 0x0F}, {0xFE, 0x0F}, {0x10, 0x01} } , // #   
{ {0x1C, 0x03}, {0x3E, 0x07}, {0x22, 0x04}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0x42, 0x04}, {0xCE, 0x07}, {0x8C, 0x03} } , // $   
{ {0x00, 0x00}, {0x00, 0x04}, {0x06, 0x07}, {0xC6, 0x03}, {0xF0, 0x00}, {0x3C, 0x06}, {0x0E, 0x06}, {0x02, 0x00} } , // %   
{ {0x1E, 0x06}, {0x3F, 0x0F}, {0xE1, 0x09}, {0xC1, 0x09}, {0x41, 0x0B}, {0x21, 0x0C}, {0x3F, 0x1E}, {0x1E, 0x16} } , // &   
{ {0x00, 0x00}, {0x00, 0x00}, {0x04, 0x00}, {0x07, 0x00}, {0x03, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00} } , // '   
{ {0x00, 0x00}, {0x00, 0x00}, {0xF8, 0x01}, {0xFE, 0x07}, {0x07, 0x0E}, {0x01, 0x08}, {0x00, 0x00}, {0x00, 0x00} } , // (   
{ {0x00, 0x00}, {0x00, 0x00}, {0x01, 0x08}, {0x07, 0x0E}, {0xFE, 0x07}, {0xF8, 0x01}, {0x00, 0x00}, {0x00, 0x00} } , // )   
{ {0x20, 0x00}, {0xA8, 0x00}, {0xF8, 0x00}, {0x70, 0x00}, {0x70, 0x00}, {0xF8, 0x00}, {0xA8, 0x00}, {0x20, 0x00} } , // *   
{ {0x20, 0x00}, {0x20, 0x00}, {0x20, 0x00}, {0xFC, 0x01}, {0xFC, 0x01}, {0x20, 0x00}, {0x20, 0x00}, {0x20, 0x00} } , // +   
{ {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x20}, {0x00, 0x3C}, {0x00, 0x1C}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00} } , // ,   
{ {0x00, 0x00}, {0x20, 0x00}, {0x20, 0x00}, {0x20, 0x00}, {0x20, 0x00}, {0x20, 0x00}, {0x20, 0x00}, {0x00, 0x00} } , // -   
{ {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x0C}, {0x00, 0x0C}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00} } , // .   
{ {0x00, 0x00}, {0x00, 0x0C}, {0x00, 0x0F}, {0xC0, 0x03}, {0xF0, 0x00}, {0x3C, 0x00}, {0x0F, 0x00}, {0x03, 0x00} } , // /   
{ {0xFE, 0x07}, {0xFF, 0x0F}, {0x01, 0x08}, {0x01, 0x08}, {0x01, 0x08}, {0xFF, 0x0F}, {0xFE, 0x07}, {0x00, 0x00} } , // 0   
{ {0x00, 0x00}, {0x04, 0x08}, {0x06, 0x08}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0x00, 0x08}, {0x00, 0x08}, {0x00, 0x00} } , // 1   
{ {0x03, 0x0F}, {0x81, 0x09}, {0xC1, 0x08}, {0x61, 0x08}, {0x31, 0x08}, {0x1F, 0x08}, {0x0E, 0x0C}, {0x00, 0x00} } , // 2   
{ {0x03, 0x0C}, {0x01, 0x08}, {0x21, 0x08}, {0x21, 0x08}, {0x21, 0x08}, {0xFF, 0x0F}, {0xDE, 0x07}, {0x00, 0x00} } , // 3   
{ {0xE0, 0x00}, {0xF0, 0x00}, {0x98, 0x00}, {0x8C, 0x00}, {0x86, 0x08}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0x00, 0x08} } , // 4   
{ {0x3F, 0x04}, {0x3F, 0x0C}, {0x21, 0x08}, {0x21, 0x08}, {0x21, 0x08}, {0xE1, 0x0F}, {0xC1, 0x07}, {0x00, 0x00} } , // 5   
{ {0xFC, 0x07}, {0xFE, 0x0F}, {0x23, 0x08}, {0x21, 0x08}, {0x21, 0x08}, {0xE0, 0x0F}, {0xC0, 0x07}, {0x00, 0x00} } , // 6   
{ {0x03, 0x00}, {0x01, 0x00}, {0x81, 0x0F}, {0xE1, 0x0F}, {0x79, 0x00}, {0x1F, 0x00}, {0x07, 0x00}, {0x00, 0x00} } , // 7   
{ {0xDE, 0x07}, {0xFF, 0x0F}, {0x21, 0x08}, {0x21, 0x08}, {0x21, 0x08}, {0xFF, 0x0F}, {0xDE, 0x07}, {0x00, 0x00} } , // 8   
{ {0x1E, 0x00}, {0x3F, 0x08}, {0x21, 0x08}, {0x21, 0x08}, {0x21, 0x0C}, {0xFF, 0x07}, {0xFE, 0x03}, {0x00, 0x00} } , // 9   
{ {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x18, 0x06}, {0x18, 0x06}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00} } , // :   
{ {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x10}, {0x18, 0x1E}, {0x18, 0x0E}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00} } , // ;   
{ {0x40, 0x00}, {0xE0, 0x00}, {0xB0, 0x01}, {0x18, 0x03}, {0x0C, 0x06}, {0x06, 0x0C}, {0x02, 0x08}, {0x00, 0x00} } , // <   
{ {0x00, 0x00}, {0xA0, 0x00}, {0xA0, 0x00}, {0xA0, 0x00}, {0xA0, 0x00}, {0xA0, 0x00}, {0xA0, 0x00}, {0x00, 0x00} } , // =   
{ {0x00, 0x00}, {0x02, 0x08}, {0x06, 0x0C}, {0x0C, 0x06}, {0x18, 0x03}, {0xB0, 0x01}, {0xE0, 0x00}, {0x40, 0x00} } , // >   
{ {0x02, 0x00}, {0x03, 0x00}, {0x01, 0x00}, {0xC1, 0x0D}, {0xE1, 0x0D}, {0x31, 0x00}, {0x1F, 0x00}, {0x0E, 0x00} } , // ?   
{ {0x02, 0x00}, {0x03, 0x00}, {0x01, 0x00}, {0xC1, 0x0D}, {0xE1, 0x0D}, {0x31, 0x00}, {0x1F, 0x00}, {0x0E, 0x00} } , // @   
{ {0xF8, 0x0F}, {0xFC, 0x0F}, {0x86, 0x00}, {0x83, 0x00}, {0x83, 0x00}, {0x86, 0x00}, {0xFC, 0x0F}, {0xF8, 0x0F} } , // A   
{ {0xFF, 0x0F}, {0xFF, 0x0F}, {0x21, 0x08}, {0x21, 0x08}, {0x21, 0x08}, {0x21, 0x08}, {0xFF, 0x0F}, {0xDE, 0x07} } , // B   
{ {0xFC, 0x03}, {0xFE, 0x07}, {0x03, 0x0C}, {0x01, 0x08}, {0x01, 0x08}, {0x03, 0x0C}, {0x06, 0x06}, {0x00, 0x00} } , // C   
{ {0x01, 0x08}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0x01, 0x08}, {0x01, 0x08}, {0x03, 0x0C}, {0xFE, 0x07}, {0xFC, 0x03} } , // D   
{ {0x01, 0x08}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0x21, 0x08}, {0x21, 0x08}, {0x71, 0x08}, {0x03, 0x0C}, {0x00, 0x00} } , // E   
{ {0x01, 0x08}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0x21, 0x08}, {0x21, 0x00}, {0x71, 0x00}, {0x03, 0x00}, {0x00, 0x00} } , // F   
{ {0xFC, 0x03}, {0xFE, 0x07}, {0x03, 0x0C}, {0x01, 0x08}, {0x41, 0x08}, {0x41, 0x08}, {0xC3, 0x07}, {0xC6, 0x0F} } , // G   
{ {0xFF, 0x0F}, {0xFF, 0x0F}, {0x20, 0x00}, {0x20, 0x00}, {0x20, 0x00}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0x00, 0x00} } , // H   
{ {0x00, 0x00}, {0x01, 0x08}, {0x01, 0x08}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0x01, 0x08}, {0x01, 0x08}, {0x00, 0x00} } , // I   
{ {0x00, 0x06}, {0x00, 0x0E}, {0x00, 0x08}, {0x00, 0x08}, {0x01, 0x08}, {0xFF, 0x0F}, {0xFF, 0x07}, {0x01, 0x00} } , // J   
{ {0x01, 0x08}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0x70, 0x00}, {0xD8, 0x00}, {0x8C, 0x01}, {0x07, 0x0F}, {0x03, 0x0E} } , // K   
{ {0x01, 0x08}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0x01, 0x08}, {0x00, 0x08}, {0x00, 0x08}, {0x00, 0x0C}, {0x00, 0x0C} } , // L   
{ {0xFF, 0x0F}, {0xFF, 0x0F}, {0x0C, 0x00}, {0x78, 0x00}, {0x0C, 0x00}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0x00, 0x00} } , // M   
{ {0xFF, 0x0F}, {0xFF, 0x0F}, {0x1C, 0x00}, {0x38, 0x00}, {0x70, 0x00}, {0xE0, 0x00}, {0xFF, 0x0F}, {0xFF, 0x0F} } , // N   
{ {0xFE, 0x07}, {0xFF, 0x0F}, {0x01, 0x08}, {0x01, 0x08}, {0x01, 0x08}, {0xFF, 0x0F}, {0xFE, 0x07}, {0x00, 0x00} } , // O   
{ {0x01, 0x08}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0x21, 0x08}, {0x21, 0x00}, {0x3F, 0x00}, {0x1E, 0x00}, {0x00, 0x00} } , // P   
{ {0xFE, 0x07}, {0xFF, 0x0F}, {0x01, 0x0E}, {0x01, 0x1C}, {0x01, 0x38}, {0xFF, 0x2F}, {0xFE, 0x07}, {0x01, 0x00} } , // Q   
{ {0x01, 0x08}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0x21, 0x08}, {0x21, 0x00}, {0x61, 0x00}, {0xFF, 0x0F}, {0x9E, 0x0F} } , // R   
{ {0x0E, 0x06}, {0x1F, 0x0E}, {0x31, 0x08}, {0x21, 0x08}, {0x21, 0x08}, {0x61, 0x08}, {0xC7, 0x0F}, {0x86, 0x07} } , // S   
{ {0x03, 0x00}, {0x03, 0x00}, {0x01, 0x08}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0x01, 0x08}, {0x03, 0x00}, {0x03, 0x00} } , // T   
{ {0xFF, 0x07}, {0xFF, 0x0F}, {0x00, 0x08}, {0x00, 0x08}, {0x00, 0x08}, {0xFF, 0x0F}, {0xFF, 0x07}, {0x00, 0x00} } , // U   
{ {0xFF, 0x01}, {0xFF, 0x03}, {0x00, 0x06}, {0x00, 0x0C}, {0x00, 0x0C}, {0x00, 0x06}, {0xFF, 0x03}, {0xFF, 0x01} } , // V   
{ {0xFF, 0x01}, {0xFF, 0x0F}, {0x00, 0x0E}, {0xE0, 0x03}, {0x00, 0x0E}, {0xFF, 0x0F}, {0xFF, 0x01}, {0x00, 0x00} } , // W   
{ {0x07, 0x0E}, {0x0F, 0x0F}, {0x98, 0x01}, {0xF0, 0x00}, {0xF0, 0x00}, {0x98, 0x01}, {0x0F, 0x0F}, {0x07, 0x0E} } , // X   
{ {0x0F, 0x00}, {0x1F, 0x00}, {0x30, 0x08}, {0xE0, 0x0F}, {0xE0, 0x0F}, {0x30, 0x08}, {0x1F, 0x00}, {0x0F, 0x00} } , // Y   
{ {0x03, 0x0F}, {0x83, 0x0F}, {0xC1, 0x08}, {0x61, 0x08}, {0x31, 0x08}, {0x19, 0x08}, {0x0F, 0x0C}, {0x07, 0x0C} } , // Z   
{ {0x00, 0x00}, {0x00, 0x00}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0x01, 0x08}, {0x01, 0x08}, {0x00, 0x00}, {0x00, 0x00} } , // [   
{ {0x00, 0x00}, {0x03, 0x00}, {0x0F, 0x00}, {0x3C, 0x00}, {0xF0, 0x00}, {0xC0, 0x03}, {0x00, 0x0F}, {0x00, 0x0C} } , // backslash   
{ {0x00, 0x00}, {0x00, 0x00}, {0x01, 0x08}, {0x01, 0x08}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0x00, 0x00}, {0x00, 0x00} } , // ]   
{ {0x08, 0x00}, {0x0C, 0x00}, {0x06, 0x00}, {0x03, 0x00}, {0x03, 0x00}, {0x06, 0x00}, {0x0C, 0x00}, {0x08, 0x00} } , // ^   
{ {0x00, 0x40}, {0x00, 0x40}, {0x00, 0x40}, {0x00, 0x40}, {0x00, 0x40}, {0x00, 0x40}, {0x00, 0x40}, {0x00, 0x40} } , // _   
{ {0x00, 0x00}, {0x00, 0x00}, {0x08, 0x00}, {0x0F, 0x00}, {0x07, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00} } , // '   
{ {0x00, 0x07}, {0x90, 0x0F}, {0x90, 0x08}, {0x90, 0x08}, {0x90, 0x08}, {0xF0, 0x07}, {0xE0, 0x0F}, {0x00, 0x08} } , // a   
{ {0x01, 0x08}, {0xFF, 0x0F}, {0xFF, 0x07}, {0x10, 0x08}, {0x10, 0x08}, {0x30, 0x08}, {0xE0, 0x0F}, {0xC0, 0x07} } , // b   
{ {0xE0, 0x07}, {0xF0, 0x0F}, {0x10, 0x08}, {0x10, 0x08}, {0x10, 0x08}, {0x10, 0x08}, {0x30, 0x0C}, {0x20, 0x04} } , // c   
{ {0xC0, 0x07}, {0xE0, 0x0F}, {0x30, 0x08}, {0x10, 0x08}, {0x11, 0x08}, {0xFF, 0x07}, {0xFF, 0x0F}, {0x00, 0x08} } , // d   
{ {0xE0, 0x07}, {0xF0, 0x0F}, {0x90, 0x08}, {0x90, 0x08}, {0x90, 0x08}, {0x90, 0x08}, {0xF0, 0x0C}, {0xE0, 0x04} } , // e   
{ {0x00, 0x00}, {0x10, 0x08}, {0xFE, 0x0F}, {0xFF, 0x0F}, {0x11, 0x08}, {0x11, 0x00}, {0x03, 0x00}, {0x02, 0x00} } , // f   
{ {0xE0, 0x27}, {0xF0, 0x6F}, {0x10, 0x48}, {0x10, 0x48}, {0x10, 0x48}, {0xE0, 0x7F}, {0xF0, 0x3F}, {0x10, 0x00} } , // g   
{ {0x01, 0x08}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0x20, 0x00}, {0x10, 0x00}, {0x10, 0x00}, {0xF0, 0x0F}, {0xE0, 0x0F} } , // h   
{ {0x00, 0x00}, {0x10, 0x08}, {0x10, 0x08}, {0xF6, 0x0F}, {0xF6, 0x0F}, {0x00, 0x08}, {0x00, 0x08}, {0x00, 0x00} } , // i   
{ {0x00, 0x30}, {0x00, 0x60}, {0x10, 0x40}, {0x10, 0x40}, {0xF6, 0x7F}, {0xF6, 0x3F}, {0x00, 0x00}, {0x00, 0x00} } , // j   
{ {0x01, 0x08}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0xC0, 0x00}, {0xC0, 0x01}, {0x60, 0x03}, {0x30, 0x0E}, {0x10, 0x0C} } , // k   
{ {0x00, 0x00}, {0x01, 0x08}, {0x01, 0x08}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0x00, 0x08}, {0x00, 0x08}, {0x00, 0x00} } , // l   
{ {0xF0, 0x0F}, {0xF0, 0x0F}, {0x30, 0x00}, {0xE0, 0x07}, {0xE0, 0x07}, {0x30, 0x00}, {0xF0, 0x0F}, {0xE0, 0x0F} } , // m   
{ {0x10, 0x00}, {0xF0, 0x0F}, {0xE0, 0x0F}, {0x10, 0x00}, {0x10, 0x00}, {0x10, 0x00}, {0xF0, 0x0F}, {0xE0, 0x0F} } , // n   
{ {0xE0, 0x07}, {0xF0, 0x0F}, {0x10, 0x08}, {0x10, 0x08}, {0x10, 0x08}, {0x10, 0x08}, {0xF0, 0x0F}, {0xE0, 0x07} } , // o   
{ {0x10, 0x40}, {0xF0, 0x7F}, {0xE0, 0x7F}, {0x10, 0x48}, {0x10, 0x08}, {0x10, 0x08}, {0xF0, 0x0F}, {0xE0, 0x07} } , // p   
{ {0xE0, 0x07}, {0xF0, 0x0F}, {0x10, 0x08}, {0x10, 0x08}, {0x10, 0x48}, {0xE0, 0x7F}, {0xF0, 0x7F}, {0x10, 0x40} } , // q   
{ {0x10, 0x00}, {0xF0, 0x0F}, {0xE0, 0x0F}, {0x10, 0x00}, {0x10, 0x00}, {0x10, 0x00}, {0x30, 0x00}, {0x20, 0x00} } , // r   
{ {0x60, 0x04}, {0xF0, 0x0C}, {0x90, 0x08}, {0x90, 0x08}, {0x90, 0x09}, {0x10, 0x09}, {0x30, 0x0F}, {0x20, 0x06} } , // s   
{ {0x10, 0x00}, {0x10, 0x00}, {0xFE, 0x07}, {0xFF, 0x0F}, {0x10, 0x08}, {0x10, 0x0C}, {0x00, 0x04}, {0x00, 0x00} } , // t   
{ {0xF0, 0x07}, {0xF0, 0x0F}, {0x00, 0x08}, {0x00, 0x08}, {0x00, 0x08}, {0xF0, 0x07}, {0xF0, 0x0F}, {0x00, 0x08} } , // u   
{ {0xF0, 0x01}, {0xF0, 0x03}, {0x00, 0x06}, {0x00, 0x0C}, {0x00, 0x0C}, {0x00, 0x06}, {0xF0, 0x03}, {0xF0, 0x01} } , // v   
{ {0xF0, 0x07}, {0xF0, 0x0F}, {0x00, 0x0C}, {0x80, 0x07}, {0x80, 0x07}, {0x00, 0x0C}, {0xF0, 0x0F}, {0xF0, 0x07} } , // w   
{ {0x10, 0x08}, {0x30, 0x0C}, {0x60, 0x06}, {0xC0, 0x03}, {0xC0, 0x03}, {0x60, 0x06}, {0x30, 0x0C}, {0x10, 0x08} } , // x   
{ {0xF0, 0x47}, {0xF0, 0x4F}, {0x00, 0x48}, {0x00, 0x48}, {0x00, 0x48}, {0x00, 0x68}, {0xF0, 0x3F}, {0xF0, 0x1F} } , // y   
{ {0x30, 0x0C}, {0x30, 0x0E}, {0x10, 0x0B}, {0x90, 0x09}, {0xD0, 0x08}, {0x70, 0x08}, {0x30, 0x0C}, {0x10, 0x0C} } , // z   
{ {0x60, 0x00}, {0x60, 0x00}, {0xFE, 0x07}, {0x9F, 0x0F}, {0x01, 0x08}, {0x01, 0x08}, {0x00, 0x00}, {0x00, 0x00} } , // {   
{ {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0xFF, 0x0F}, {0xFF, 0x0F}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00} } , // |
{ {0x00, 0x00}, {0x00, 0x00}, {0x01, 0x08}, {0x01, 0x08}, {0x9E, 0x0F}, {0xFE, 0x07}, {0x60, 0x00}, {0x00, 0x00} } , // } 
{ {0x00, 0x00}, {0x20, 0x00}, {0x10, 0x00}, {0x20, 0x00}, {0x40, 0x00}, {0x20, 0x00}, {0x10, 0x00}, {0x00, 0x00} } , // ~
};

