// ============================================================================
//  Copyright (c)2007 Freescale Semiconductor Inc.  -- All Rights Reserved --
//
//  The code is the property of Freescale GmbH Munich
//  C&I GTM Operation
//
//  The copyright notice above does not evidence any actual or intended 
//  publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any expressed or implied
//  warrenties, including, but not limited to, the implied warrenties of 
//  merchantability and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be liable for any direct, 
//  indirect, incidental, special, examplary, or consequential damages 
//  (including, but not limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption). However caused 
//  and on any theory of liability, whether in contract, strict liability, or
//  tort (including negligence or otherwise) arising in any way out of the use 
//  of this software, even if advised of the possibility of such damage.
// 
//  ---------------------------------------------------------------------------
//
//  Filename:     $Source: $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: $
//  Revision:     $Revision: $
//
//  Functions:    
//
//  History:      Use the CVS command log to display revision history information.
//
//  Description:  header file for OLED support
//
//  Notes:        
//                
//
//
// ============================================================================
#include "derivative.h"
#include "MyTypes.h"
#include "Images.h"
#include "Font.h"

// ----------------------------------------------------------------------------
// OLED command definitions
// ----------------------------------------------------------------------------
#define OLED_SETXADD                  0x15  
#define OLED_SETYADD                  0x75
#define OLED_SETCONTRAST              0x81
#define OLED_SETCURRENTRANGE_25       0x84
#define OLED_SETCURRENTRANGE_50       0x85                      contains the
#define OLED_SETCURRENTRANGE_100      0x86
#define OLED_SETREMAP                 0xA0
#define OLED_SETDISPLAYSTARTLINE      0xA1
#define OLED_SETDISPLAYOFFSET         0xA2
#define OLED_SETDISPLAYMODE_NORM      0xA4
#define OLED_SETDISPLAYMODE_ALLON     0xA5
#define OLED_SETDISPLAYMODE_ALLOFF    0xA6
#define OLED_SETDISPLAYMODE_INVERSE   0xA7
#define OLED_SETMULTIPLEXRATIO        0xA8
#define OLED_SETMASTERCONFIG          0xAD
#define OLED_SETDISPLAY_OFF           0xAE
#define OLED_SETDISPLAY_ON            0xAF
#define OLED_SETPRECHARGECOMPENABLE   0xB0
#define OLED_SETPHASELENGTH           0xB1
#define OLED_SETROWPERIOD             0xB2
#define OLED_SETDISPLAYCLOCKDIVIDE    0xB3
#define OLED_SETPRECHARGECOMPLEVEL    0xB4
#define OLED_SETGREYSCALETABLE        0xB8
#define OLED_SETPRECHAGEVOLT          0xBC
#define OLED_SETVCOMH                 0xBE
#define OLED_SETSEGMENTLOWVOLT        0xBF
#define OLED_SETBIASCURRENTDCDCCONV   0xCF
#define OLED_NOP                      0xE3

// ----------------------------------------------------------------------------
// macros for display selection and orientation 
// ----------------------------------------------------------------------------
// select which display to use, if necessary add new display and init sequence
#define OS128064PK27MY0B00
//#define OS128064PK16MY0A01

// select if display is mounted up side down 
//#define _UP_SIDE_DOWN                                   // define to rotate output 180 degrees


// ----------------------------------------------------------------------------
// macros for hardware interface 
// ----------------------------------------------------------------------------

// ------------------------------
// pinout for DEMO9S08QG8 board:
#ifdef _MC9S08QG8_H

// use PTB4/MISO pin to enable 12V for OLED display
#define  _12V_Init()        PTBD_PTBD4 = 0; PTBDD_PTBDD4 = 1 
#define  _12V_Enable()      (PTBD_PTBD4 = 1) 
#define  _12V_Disable()     (PTBD_PTBD4 = 0) 

// use PTB7 pin to drive reset signal OLED display
#define  _RST_Init()        PTBD_PTBD7 = 1; PTBDD_PTBDD7 = 1
#define  _RST_Assert()      (PTBD_PTBD3 = 0)
#define  _RST_Release()     (PTBD_PTBD3 = 1)

// use PTB6 pin to drive D/#C (Data/Command) signal to OLED display
#define  _DC_Init()         {PTBD_PTBD6 = 1; PTBDD_PTBDD6 = 1;}
#define  _DC_Set()          (PTBD_PTBD6 = 1)
#define  _DC_Clr()          (PTBD_PTBD6 = 0)

// SPI init
#define  _SPI_Init()        {                                                   \
  SPIC1 = SPIC1_SPE_MASK|SPIC1_MSTR_MASK|SPIC1_SSOE_MASK; \
  SPIC2 = SPIC2_MODFEN_MASK|SPIC2_BIDIROE_MASK|SPIC2_SPC0_MASK; \
  SPIBR = 0; \
}

#define  _SPI_Send(v)       {while(!SPIS_SPTEF) {;} SPID = (v);} 

#endif

// ------------------------------
// pinout for DEMO9S08AW60 board:
#ifdef _MC9S08AW60_H

// use PTE5/MISO pin to enable 12V for OLED display
#define  _12V_Init()        PTED_PTED5 = 0; PTEDD_PTEDD5 = 1 
#define  _12V_Enable()      (PTED_PTED5 = 1) 
#define  _12V_Disable()     (PTED_PTED5 = 0) 

// use PTE3 pin to drive reset signal OLED display
#define  _RST_Init()        PTED_PTED3 = 1; PTEDD_PTEDD3 = 1
#define  _RST_Assert()      (PTED_PTED3 = 0)
#define  _RST_Release()     (PTED_PTED3 = 1)

// use PTE2 pin to drive D/#C (Data/Command) signal to OLED display
#define  _DC_Init()         {PTED_PTED2 = 1; PTEDD_PTEDD2 = 1;}
#define  _DC_Set()          (PTED_PTED2 = 1)
#define  _DC_Clr()          (PTED_PTED2 = 0)


  // SPI init
#define  _SPI_Init()        {                                                   \
  SPI1C1 = SPI1C1_SPE_MASK|SPI1C1_MSTR_MASK|SPI1C1_SSOE_MASK;       /* enable SPI, Mastermode, MSB bit first, SS output enabled */ \
  SPI1C2 = SPI1C2_MODFEN_MASK|SPI1C2_BIDIROE_MASK|SPI1C2_SPC0_MASK; /* SS automatic, single wire -> frees MISO as GPIO          */ \
  SPI1BR = 0;                                                       /* baudrate 2MHz  (busclock / 2)                            */ \
}

#define  _SPI_Send(v)       {while(!SPI1S_SPTEF) {;}  SPI1D = (v);} // wait till transmitter empty; output data   

#endif 

// ----------------------------------------------------------------------------
// plublish methods (prototypes)
// ----------------------------------------------------------------------------
void OLED_WriteCmd(UINT8 cmd);
void OLED_WriteData(UINT8 data);

void OLED_Interface_Init(void);
void OLED_Reset(void);
void OLED_VCC_On(void);
void OLED_VCC_Off(void);

void OLED_Display_Init(void);
void OLED_SetCanvas(UINT8 left, UINT8 top, UINT8 width, UINT8 height);
void OLED_Fill(UINT8 left, UINT8 top, UINT8 width, UINT8 height, UINT8 fill);
//void OLED_DrawImage(UINT8 left, UINT8 top, UINT8* image);
void OLED_DrawImage(UINT8 left, UINT8 top, UINT8 mask, UINT8* image);
void OLED_WriteString5x7(UINT8 left,UINT8 top,UINT8 cc, char* text);
void OLED_WriteString8x15(UINT8 left,UINT8 top,UINT8 cc, char* text);
