// ============================================================================
//  Copyright (c)2007 Freescale Semiconductor Inc.  -- All Rights Reserved --
//
//  The code is the property of Freescale GmbH Munich
//  C&I GTM Operation
//
//  The copyright notice above does not evidence any actual or intended 
//  publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any expressed or implied
//  warrenties, including, but not limited to, the implied warrenties of 
//  merchantability and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be liable for any direct, 
//  indirect, incidental, special, examplary, or consequential damages 
//  (including, but not limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption). However caused 
//  and on any theory of liability, whether in contract, strict liability, or
//  tort (including negligence or otherwise) arising in any way out of the use 
//  of this software, even if advised of the possibility of such damage.
// 
//  ---------------------------------------------------------------------------
//
//  Filename:     $Source: $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: $
//  Revision:     $Revision: $
//
//  Functions:    
//
//  History:      Use the CVS command log to display revision history information.
//
//  Description:  OLED driver example software 
//                based on DEMO9S08QG8/DEMO9S08AW60 boards and OLED DC
//                (daugther card) Rev 2
//
//  Notes:        
//                
//
//
// ============================================================================

// --------------------------------------------------------
// Includes
#include <hidef.h>                                          // for EnableInterrupts macro 
#include "derivative.h"                                     // include peripheral declarations
#include "main.h"                                           // DEMO board specifics
#include "Images.h"
#include "OLED.h"

// --------------------------------------------------------
#define EVER         (;;) 
#define DONOTHING    {}


// -------------------------------------------------------- 
// derivative dependand code
#ifdef _MC9S08QG8_H
#endif

#ifdef _MC9S08AW60_H
#endif

// --------------------------------------------------------
// prototypes
void Delay(UINT16 ms);
UINT8* Byte2Str(UINT8 value); 


// --------------------------------------------------------
// --------------------------------------------------------
// --------------------------------------------------------
void main(void) {
  
  UINT8 n;
  UINT8 char_in=0;
  unsigned short      atod_in; 
  UINT8 color;
 	
   
  EnableInterrupts; 

// ----------------
#ifdef _MC9S08QG8_H

  SOPT1  = SOPT1_BKGDPE_MASK|SOPT1_RSTPE_MASK;          	  // Disable COP, leave RESET & BDM pin enabled for debugger	
  SRTISC = SRTISC_RTIS0_MASK;                               // time base 8ms internal 1kHz clock

  PTAPE_PTAPE2 = 1;                                         // pull enable for SW1
  PTAPE_PTAPE3 = 1;                                         // pull enable for SW2

#endif
// ----------------

// ----------------
#ifdef _MC9S08AW60_H

  SOPT   = 0x00;			                                      // Disable COP	
  SRTISC = SRTISC_RTIS0_MASK;                               // time base 8ms internal 1kHz clock

  PTCDD = 0x10;                                             // set port c as inputs for push button switch input except for C4 which is accelerometer ST
  PTCPE = 0xEF;                                             // enable port c pullups for push button switch operation except for C4 which is accelerometer ST
  PTDDD = 0x00;                                             // set port d as inputs for push button switch and accelerometer inputs
  PTDPE = 0x0C;                                             // enable port d pullups on D2 and D3 for push button switch operation
  PTADD = 0x00;                                             // set port a as inputs for dip switch input
  PTAPE = 0xFF;                                             // enable port a pullups for dip switch operation
  PTFDD = 0xFF;	                                            // set port f as outputs for dip switch input
  PTFD  = 0x0F;
  PTCD_PTCD4 = 0x00;	                                      // Set C4 low to keep accelerometer from going into self test

#endif
// ----------------

  OLED_Interface_Init();                                    // initialized MCU <> OLED interface (MCU side)

  // ----------------------
  // OLED power up sequence
  // ----------------------
                                                            // 1. Power up Vdd (already done)
  OLED_Reset();                                             // 2. OLED reset
  OLED_WriteCmd(OLED_SETDISPLAY_OFF);                       // 3. Send display OFF command
  OLED_VCC_On();                                            // 4. Power Up Vcc (12V)
  Delay(150);                                               // 5. Delay 100ms
  
  // Init Sequence 
  OLED_Display_Init();                                      // send initialisation command sequence
  OLED_Fill(0,0, 128,64,0);                                 // fill black
  OLED_WriteCmd(OLED_SETDISPLAY_ON);                        // 6. Send Display ON command

  // ------------------------
  // main loop
  // ------------------------
  for EVER {


    // --------------------------------
    // Welcome screen
    // --------------------------------
    OLED_Fill(0,0, 128,64,0);                               // fill black

    OLED_WriteString8x15(0, 16, 0xCC, "   Welcome to");   
    OLED_WriteString8x15(0, 32, 0xCC, "  the"); 
    OLED_WriteString8x15(6*8, 32, 0xFF, "OLED DEMO "); 

    Delay(3000);


    // --------------------------------
    // black screen for 1 s
    // --------------------------------
    OLED_Fill(0,0, 128,64,0);                               // fill black
    Delay(1000);

    // ------------------------------------------
    // sample GUI with buttons and analog values
    // ------------------------------------------
// ----------------
#ifdef _MC9S08QG8_H

    // static portion
    OLED_Fill(0,0, 128,64, 0); 
    OLED_DrawImage(0,22, 0, (UINT8*)imageGUIQG8);

    OLED_WriteString5x7(68,  2, 0xDD, "Press SW1");            
    OLED_WriteString5x7(68, 10, 0xBB, "SW2 move");            
    OLED_WriteString5x7(68, 18, 0x99, "Poti RV1");            
    OLED_WriteString5x7(68, 26, 0x77, "darken RZ1");            
    OLED_WriteString5x7(68, 34, 0x55, "light");            
    OLED_WriteString5x7(68, 42, 0x44, "sensor!");            
    
    n = 0;                
    while(n++<100)  {                                       // loop for some time

      // dynamic portion
      if(SW1)                                               // SW1
        OLED_DrawImage(0,2, 0, (UINT8*)imgSW1);
      else
        OLED_DrawImage(0,2, 2, (UINT8*)imgSW1);
      
      if(SW2)                                               // SW2
        OLED_DrawImage(32,2, 0,(UINT8*)imgSW2);
      else
        OLED_DrawImage(32,2, 2,(UINT8*)imgSW2);

      APCTL1  = 0x01;                                       // Disable IO control for ADPC0
      ADCSC1  = 0x00;                                       // set adc channet to poti
      while (ADCSC1_COCO == 0);                             // Wait for a conversion to be completed  
      atod_in = ADCR;
      OLED_WriteString8x15(4, 50, 0xFF, Byte2Str((UINT8)atod_in));
      
      APCTL1  = 0x02;                                       // Disable IO control for ADPC1
      ADCSC1  = 0x01;                                       // set adc channet to lightsensor
      while (ADCSC1_COCO == 0);                             // Wait for a conversion to be completed  
      atod_in = ADCR;

      color = atod_in&0xF0;                                 // change color depending on ambient light level
      if(color>0xC0) color = 0xC0;
      color = color|(color>>4);
      color ^= 0xFF;                                        // invert
      OLED_WriteString8x15(36, 50, color, Byte2Str((UINT8)atod_in));

      Delay(100);
    }

#endif      
// ----------------

// ----------------
#ifdef _MC9S08AW60_H

    // static portion
    OLED_Fill(0,0, 128,64, 0); 
    OLED_DrawImage(0,22, 0, (UINT8*)imageGUIAW60);
    
    n = 0;                
    while(n++<100)  {                                       // loop for some time

      // dynamic portion
      if(SW1)                                               // SW1
        OLED_DrawImage(0,2, 0, (UINT8*)imgSW1);
      else
        OLED_DrawImage(0,2, 2, (UINT8*)imgSW1);
      
      if(SW2)                                               // SW2
        OLED_DrawImage(32,2, 0, (UINT8*)imgSW2);
      else
        OLED_DrawImage(32,2, 2, (UINT8*)imgSW2);
      
      if(SW3)                                               // SW3
        OLED_DrawImage(64,2, 0, (UINT8*)imgSW3);
      else
        OLED_DrawImage(64,2, 2, (UINT8*)imgSW3);
      
      if(SW4)                                               // SW4
        OLED_DrawImage(96,2, 0, (UINT8*)imgSW4);
      else
        OLED_DrawImage(96,2, 2, (UINT8*)imgSW4);


      APCTL2  = 0x01;                                       // Disable IO control for ADPC8
      AD1SC1  = 0x08;                                       // set adc channet to poti
      while (AD1SC1_COCO == 0);                             // Wait for a conversion to be completed  
      atod_in = AD1R;
      OLED_WriteString8x15(4, 50, 0xFF, Byte2Str((UINT8)atod_in));
      
      APCTL2  = 0x02;                                       // Disable IO control for ADPC9
      AD1SC1  = 0x09;                                       // set adc channet to lightsensor
      while (AD1SC1_COCO == 0);                             // Wait for a conversion to be completed  
      atod_in = AD1R;

      color = atod_in&0xF0;                                 // change color depending on ambient light level
      if(color>0xC0) color = 0xC0;
      color = color|(color>>4);
      //color ^= 0xFF;                                        // invert
      OLED_WriteString8x15(36, 50, color, Byte2Str((UINT8)atod_in));

      APCTL2  = 0x30;                                       // Disable IO control for ADPC12 and ADPC13
      AD1SC1  = 15;                                         // set adc channet to accelerometer X
      while (AD1SC1_COCO == 0);                             // Wait for a conversion to be completed  
      atod_in = AD1R;
      OLED_WriteString8x15(68, 50, 0xFF, Byte2Str((UINT8)atod_in));

      AD1SC1  = 14;                                         // set adc channet to accelerometer Y
      while (AD1SC1_COCO == 0);                             // Wait for a conversion to be completed  
      atod_in = AD1R;
      OLED_WriteString8x15(100, 50, 0xFF, Byte2Str((UINT8)atod_in));

      Delay(100);
    }

#endif      
// ----------------


    // --------------------------------
    // scoll in logo
    // --------------------------------
    OLED_Fill(0,0, 128,64, 0x00);
    for(n=127;n>0;n--)  {
      OLED_DrawImage(n,7, 0, (UINT8*)LogoFSL);
      Delay(3);                                             // delay is not calibrate against amount of data to scroll
    }
    Delay(2000);      

    // --------------------------------
    // memory information
    // --------------------------------
    OLED_Fill(0,0, 128,64, 0x00);                           // fill black
    OLED_Fill(0,0, 128,1,  0xBB);                           // yellow line
    OLED_Fill(0,63,128,64, 0xBB);                           // yellow line

    OLED_WriteString5x7(0,  7, 0xCC,"The Demo uses");       //example with FONT5X7

// ----------------
#ifdef _MC9S08QG8_H

    OLED_WriteString5x7(12,16, 0xFF,"FLASH:    8045Byte");  
    OLED_WriteString5x7(24,24, 0xCC,"Images: 3912Byte");    
    OLED_WriteString5x7(24,32, 0xCC,"Fonts:  1995Byte");    
    OLED_WriteString5x7(24,40, 0xCC,"Prog.:  2138Byte");   
    OLED_WriteString5x7(12,50, 0xFF,"RAM:      <100Byte"); 

#endif      
// ----------------

// ----------------
#ifdef _MC9S08AW60_H

    OLED_WriteString5x7(12,16, 0xFF,"FLASH:    9376Byte");  
    OLED_WriteString5x7(24,24, 0xCC,"Images: 5260Byte");    
    OLED_WriteString5x7(24,32, 0xCC,"Fonts:  1995Byte");    
    OLED_WriteString5x7(24,40, 0xCC,"Prog.:  2121Byte");   
    OLED_WriteString5x7(12,50, 0xFF,"RAM:      <100Byte"); 

#endif      
// ----------------

    Delay(3000);      
  }
}
    
// --------------------------------------------------------
// ms sets the delay
// timebase is ~8ms @1kHz
//
void Delay(UINT16 ms)  {
  UINT16 i;
  
  for(i=0;i<ms;i+=8)  {
    while(!(SRTISC&SRTISC_RTIF_MASK))   DONOTHING;                              // wait for flag
    SRTISC |= SRTISC_RTIACK_MASK;                                               // clear flag
  }
}

//-----------------------------------------------------------------------------
// Function:    Byte2Str
// Parameters:  value  one byte 
// Returns:     nothing
// Description: convers a single byte (0..255) into a null terminated right 
//              justified string e.g. "255", " 12", "  0"
//-----------------------------------------------------------------------------
UINT8* Byte2Str(UINT8 value)  {

  static UINT8 str[4];
  UINT8 prev;

  str[3] = 0;                                               // null terminated
  prev = 0;
  
  if(value/100) {
    str[0] = value/100+'0';
    prev = 1;
  }else{
    str[0] = ' ';
  }
  value = (UINT8)(value%100);                   
  
  if((prev)||(value/10)) {
    str[1] = value/10+'0';
  }else{
    str[1] = ' ';
  }
  str[2] = value%10+'0';
  
  return (UINT8*)str;
}

