/******************************************************************************
 Copyright  1995-2004 Freescale Semiconductor Inc.
 All Rights Reserved

 This is unpublished proprietary source code of Freescale Semiconductor Inc.
 The copyright notice above does not evidence any actual or intended
 publication of such source code.
 
 $Date: 2006/08/16 08:30:49 $
 $Id: os_config.h,v 1.3 2006/08/16 08:30:49 alexg Exp $
 $Source: /home/swproj/sw/REPOSITORY/dsp/SmartDSP/demos/starcore/msc814x/net_multicore/os_config.h,v $
 $Revision: 1.3 $
 **************************************************************************//*

 @File          os_config.h

 @Description   OS Configuration definitions.
	
 @Cautions      None.
 
*//***************************************************************************/

#ifndef __OS_CONFIG_H
#define __OS_CONFIG_H


#include "msc814x.h"


#define ON      1
#define OFF     0

/* OS General Configuration **************************************************/

#define OS_STACK_SIZE 						0x1000  /* Stack size */

#define OS_HEAP_SIZE                        0x4000	/* Heap size  */

#define OS_HEAP_NONCACHEABLE_SIZE           0x2000  /* Non-cacheable part of Heap    */
                                                    /* must be power of 2 and >= 256 */

#define OS_SHARED_MEM_SIZE                  2048	/* Shared Memory Size */

#define OS_TICK                             OFF		/* Tick Functionality */

#define OS_TICK_PRIORITY                    OS_SWI_PRIORITY0	/* Tick Priority */

#define OS_TICK_PARAMETER					MSC814X_TICK_DEFAULT	/* Tick Parameter */

#define OS_CLKIN							66.667 /* (MHz) */

#define OS_PCICLK_IN						66.667   /* (MHz) */

#define OS_SYSTEM_CLOCK                     OS_CLKIN /* provided for backward compatibility */

#define OS_HW_TIMERS                        OFF	/* Hardware Timers */

#define OS_TOTAL_NUM_OF_MEM_PARTS           2	/* Memory Partitions */

#define OS_TOTAL_NUM_OF_FRAME_POOLS         2	/* Frame Pools Number */

#define OS_TOTAL_NUM_OF_SWI                 10	/* Software Interrupts Number */

#define OS_TOTAL_NUM_OF_SW_TIMERS           0	/* Software Timers Number */

#define OS_TOTAL_NUM_OF_QUEUES              48	/* Queues Number */

#define OS_TOTAL_NUM_OF_SHARED_QUEUES		0	/* Shared Queues Number */

/* MULTICORE *****************************************************************/

/* OS_MULTICORE should be defined as 0 or 1 by the compiler */

#define OS_MULTICORE_SYNCHRONIZATION        ON	/* Multi Core Synchronization */

#define OS_TOTAL_NUM_OF_INTERCORE_MESSAGES  0	/* Intercore Messages Number  */

#define OS_NUM_OF_CORES                     4	/* Cores Number	*/

#define OS_MAX_NUM_OF_CORES                 MSC814X_MAX_NUM_OF_CORES	/* Max Cores Number */

#define OS_MASTER_CORE                      0	/* Master Core ID */


/* Architecture Configuration ************************************************/

#define MSC814X_QBUS                        MSC814X_QBUS_DEFAULT

#define MSC814X_SYS_REGS                    MSC814X_SYS_REGS_DEFAULT

#define MSC814X_QE							MSC814X_QE_DEFAULT /* For PPC: 0xE0100000 */

#define MAX_NUM_OF_DATA_CONTEXTS           	10

#define MAX_NUM_OF_PROG_CONTEXTS           	10

#define DCACHE_ENABLE					   	ON

#define ICACHE_ENABLE					   	ON

#define OS_PRAM_MEM_BASE					(MSC814X_QE + 0x10000)  /* For PPC:  0xE0110000 */    /* Parameter RAM Memory base address */

#define OS_PRAM_MEM_SIZE      	            0xC000	/* Parameter RAM Memory Size */


#define MSC814X_DMA                         OFF

/* CIO Devices ***************************************************************/

#define MSC814X_SPI							OFF

#define MSC814X_UART						OFF

/* BIO Devices ***************************************************************/

#define MSC814X_UEC0						ON

#define MSC814X_UEC1						ON

#define MSC814X_RIONET0 					OFF

#define MSC814X_RIONET1 					OFF

#define MSC814X_ATM							OFF

/* SIO Devices ***************************************************************/

#define MSC814X_TDM0						OFF
#define MSC814X_TDM1						OFF
#define MSC814X_TDM2						OFF
#define MSC814X_TDM3						OFF
#define MSC814X_TDM4						OFF
#define MSC814X_TDM5						OFF
#define MSC814X_TDM6						OFF
#define MSC814X_TDM7						OFF

/* Total number of devices */
#define OS_TOTAL_NUM_OF_CIO_DEVICES         (MSC814X_SPI + MSC814X_UART)

#define OS_TOTAL_NUM_OF_BIO_DEVICES         (MSC814X_UEC0 + MSC814X_UEC1 + MSC814X_RIONET0 + MSC814X_RIONET1 + MSC814X_ATM)

#define OS_TOTAL_NUM_OF_SIO_DEVICES         (MSC814X_TDM0 + MSC814X_TDM1 + MSC814X_TDM2 + MSC814X_TDM3 + MSC814X_TDM4 + MSC814X_TDM5 + MSC814X_TDM6 + MSC814X_TDM7)



#endif // __OS_CONFIG_H
