/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : AD1.C
**     Project   : PWM_Lab
**     Processor : MC9S08QE128CLK
**     Beantype  : ADC
**     Version   : Bean 01.404, Driver 01.16, CPU db: 3.00.000
**     Compiler  : CodeWarrior HCS08 C Compiler
**     Date/Time : 11/5/2007, 13:49
**     Abstract  :
**         This device "ADC" implements an A/D converter,
**         its control methods and interrupt/event handling procedure.
**     Settings  :
**         AD control register         : ADCSC1      [$0010]
**         AD control register         : ADCCFG      [$0016]
**         AD control register         : ADCRH       [$0012]
**         AD control register         : ADCRL       [$0013]
**         AD control register         : ADCCVH      [$0014]
**         AD control register         : ADCCVL      [$0015]
**         AD control register         : ADCSC2      [$0011]
**         AD control register         : APCTL1      [$0017]
**         AD control register         : APCTL2      [$0018]
**         AD control register         : APCTL3      [$0019]
**         AD result register          : ADCres      [$0012]
**         Interrupt name              : Vadc
**         Priority                    : undef
**         User handling procedure     : AD1_OnEnd
**         Number of conversions       : 1
**         AD resolution               : 12-bit
**
**         Input pins
**
**              Port name              : PTA
**              Bit number (in port)   : 0
**              Bit mask of the port   : $0001
**              Port data register     : PTAD        [$0000]
**              Port control register  : PTADD       [$0001]
**
**         Initialization:
**              Conversion             : Enabled
**              Event                  : Enabled
**         High speed mode
**             Prescaler               : divide-by-1
**     Contents  :
**         Measure    - byte AD1_Measure(bool WaitForResult);
**         GetValue16 - byte AD1_GetValue16(word *Values);
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2006
**     UNIS, spol. s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/


/* MODULE AD1. */

#include "Events.h"
#include "AD1.h"

#pragma MESSAGE DISABLE C5703          /* Disable warning C5703 "Parameter is not referenced" */



#define STOP            0              /* STOP state           */
#define MEASURE         1              /* MESURE state         */
#define CONTINUOUS      2              /* CONTINUOS state      */
#define SINGLE          3              /* SINGLE state         */


static const  byte Channels = 0x40;    /* Content for the device control register */

static bool OutFlg;                    /* Measurement finish flag */
static byte ModeFlg;                   /* Current state of device */

word AD1_OutV;                         /* Sum of measured values */





/*
** ===================================================================
**     Method      :  AD1_Interrupt (bean ADC)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes event(s) of the bean.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
ISR(AD1_Interrupt)
{
  ((TWREG*)(&AD1_OutV))->b.high = ADCRH; /* Save measured value */
  ((TWREG*)(&AD1_OutV))->b.low = ADCRL; /* Save measured value */
  OutFlg = TRUE;                       /* Measured values are available */
  AD1_OnEnd();                         /* Invoke user event */
  ModeFlg = STOP;                      /* Set the device to the stop mode */
}

/*
** ===================================================================
**     Method      :  AD1_HWEnDi (bean ADC)
**
**     Description :
**         Enables or disables the peripheral(s) associated with the bean.
**         The method is called automatically as a part of the Enable and 
**         Disable methods and several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void AD1_HWEnDi(void)
{
  if (ModeFlg) {                       /* Start or stop measurement? */
    OutFlg = FALSE;                    /* Output value isn't available */
    ADCSC1 = Channels;                 /* If yes then start the conversion */
  }
}

/*
** ===================================================================
**     Method      :  AD1_Measure (bean ADC)
**
**     Description :
**         This method performs one measurement on all channels that
**         are set in the bean inspector. (Note: If the <number of
**         conversions> is more than one the conversion of A/D
**         channels is performed specified number of times.)
**     Parameters  :
**         NAME            - DESCRIPTION
**         WaitForResult   - Wait for a result
**                           of a conversion. If <interrupt service>
**                           is disabled, A/D peripheral doesn't
**                           support measuring all channels at once
**                           or Autoscan mode property isn't enabled
**                           and at the same time the <number of
**                           channel> is greater than 1, then the
**                           WaitForResult parameter is ignored and
**                           the method waits for each result every
**                           time. If the <interrupt service> is
**                           disabled and a <number of conversions>
**                           is greater than 1, the parameter is
**                           ignored and the method also waits for
**                           each result every time.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED - Device is disabled
**                           ERR_BUSY - A conversion is already
**                           running
** ===================================================================
*/
#pragma MESSAGE DISABLE C5703 /* WARNING C5703: Parameter declared but not referenced */
byte AD1_Measure(bool WaitForResult)
{
  if (ModeFlg != STOP) {               /* Is the device in different mode than "stop"? */
    return ERR_BUSY;                   /* If yes then error */
  }
  ModeFlg = MEASURE;                   /* Set state of device to the measure mode */
  AD1_HWEnDi();                        /* Enable the device */
  if (WaitForResult) {                 /* Is WaitForResult TRUE? */
    while (ModeFlg == MEASURE) {}      /* If yes then wait for end of measurement */
  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  AD1_GetValue16 (bean ADC)
**
**     Description :
**         This method returns the last measured values of all
**         channels justified to the left. Compared with <GetValue>
**         method this method returns more accurate result if the
**         <number of conversions> is greater than 1 and <AD
**         resolution> is less than 16 bits. In addition, the user
**         code dependency on <AD resolution> is eliminated.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Values          - Pointer to the array that
**                           contains the measured data.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_NOTAVAIL - Requested value not
**                           available
**                           ERR_OVERRUN - External trigger overrun
**                           flag was detected after the last value(s)
**                           was obtained (for example by GetValue).
**                           This error may not be supported on some
**                           CPUs (see generated code).
** ===================================================================
*/
byte AD1_GetValue16(word *Values)
{
  if (!OutFlg) {                       /* Is output flag set? */
    return ERR_NOTAVAIL;               /* If no then error */
  }
  *Values = (word)((AD1_OutV) << 4);   /* Save measured values to the output buffer */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  AD1_Init (bean ADC)
**
**     Description :
**         Initializes the associated peripheral(s) and the bean's 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void AD1_Init(void)
{
  OutFlg = FALSE;                      /* No measured value */
  ModeFlg = STOP;                      /* Device isn't running */
  /* ADCSC2: ADACT=0,ADTRG=0,ACFE=0,ACFGT=0,??=0,??=0,??=0,??=0 */
  setReg8(ADCSC2, 0x00);               /* Disable HW trigger and autocompare */ 
  /* ADCCFG: ADLPC=0,ADIV1=0,ADIV0=0,ADLSMP=0,MODE1=0,MODE0=1,ADICLK1=1,ADICLK0=1 */
  setReg8(ADCCFG, 0x07);               /* Set prescaler bits */ 
  /* ADCSC1: COCO=0,AIEN=0,ADCO=0,ADCH4=1,ADCH3=1,ADCH2=1,ADCH1=1,ADCH0=1 */
  setReg8(ADCSC1, 0x1F);               /* Disable the module */ 
}


/* END AD1. */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 3.00 [03.89]
**     for the Freescale HCS08 series of microcontrollers.
**
** ###################################################################
*/
