/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : TI1.C
**     Project   : Led_Blink
**     Processor : MC9S08QE128CLH
**     Beantype  : TimerInt
**     Version   : Bean 02.129, Driver 01.11, CPU db: 3.00.001
**     Compiler  : CodeWarrior HCS08 C Compiler
**     Date/Time : 14/5/2007, 15:09
**     Abstract  :
**         This bean "TimerInt" implements a periodic interrupt.
**         When the bean and its events are enabled, the "OnInterrupt"
**         event is called periodically with the period that you specify.
**         TimerInt supports also changing the period in runtime.
**         The source of periodic interrupt can be timer compare or reload
**         register or timer-overflow interrupt (of free running counter).
**     Settings  :
**         Timer name                  : RTC (8-bit)
**         Compare name                : RTCmod
**         Counter shared              : No
**
**         High speed mode
**             Prescaler               : divide-by-1
**             Clock                   : 512 Hz
**           Initial period/frequency
**             Xtal ticks              : 16320
**             microseconds            : 498047
**             milliseconds            : 498
**             seconds (real)          : 0.4980469
**             Hz                      : 2
**
**         Runtime setting             : none
**
**         Initialization:
**              Timer                  : Enabled
**              Events                 : Enabled
**
**         Timer registers
**              Counter                : RTCCNT    [$1831]
**              Mode                   : RTCSC     [$1830]
**              Run                    : RTCSC     [$1830]
**              Prescaler              : RTCSC     [$1830]
**
**         Compare registers
**              Compare                : RTCMOD    [$1832]
**
**         Flip-flop registers
**     Contents  :
**         No public methods
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2006
**     UNIS, spol. s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

/* MODULE TI1. */

#include "Events.h"
#include "PE_Error.h"
#include "TI1.h"
#pragma MESSAGE DISABLE C2705          /* WARNING C2705: Possible loss of data */
#pragma MESSAGE DISABLE C5919          /* WARNING C5919: Conversion of floating to unsigned integral */

/* Internal method prototypes */

/* End of Internal methods declarations */

/*
** ===================================================================
**     Method      :  TI1_Init (bean TimerInt)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void TI1_Init(void)
{
  /* RTCSC: RTIF=0,RTCLKS=0,RTIE=0,RTCPS=0 */
  setReg8(RTCSC, 0x00);                /* Stop HW */ 
  TI1_SetCV((byte)0xFE);               /* Store appropriate value to the compare/modulo register according to High speed CPU mode */
  /* RTCSC: RTIF=1,RTCLKS=2,RTIE=1,RTCPS=3 */
  setReg8(RTCSC, 0xD3);                /* Run RTC (select clock source, set frequency and enable interrupt ) */ 
}


/*
** ===================================================================
**     Method      :  TI1_Interrupt (bean TimerInt)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
ISR(TI1_Interrupt)
{
  /* RTCSC: RTIF=1 */
  setReg8Bits(RTCSC, 0x80);            /* Reset real-time counter request flag */ 
  TI1_OnInterrupt();                   /* Invoke user event */
}



/* END TI1. */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 3.00 [03.89]
**     for the Freescale HCS08 series of microcontrollers.
**
** ###################################################################
*/
