
#define DATA_CACHE_ON			1  // 1: on, 0: off
#define INSTRUCTION_CACHE_ON	1  // 1: on, 0: off
/*** BAT flags definition ***/
#define BAT_BL_128K 0x00000000
#define BAT_BL_256K 0x00000004
#define BAT_BL_512K 0x0000000C
#define BAT_BL_1M 0x0000001C
#define BAT_BL_2M 0x0000003C
#define BAT_BL_4M 0x0000007C
#define BAT_BL_8M 0x000000FC
#define BAT_BL_16M 0x000001FC
#define BAT_BL_32M 0x000003FC
#define BAT_BL_64M 0x000007FC
#define BAT_BL_128M 0x00000FFC
#define BAT_BL_256M 0x00001FFC
#define BAT_BL_512M 0x00003FFC
/* supervisor/user valid mode definitions - Upper BAT*/
#define BAT_VALID_SUPERVISOR 0x00000002
#define BAT_VALID_USER 0x00000001
#define BAT_INVALID 0x00000000
/* WIMG bit settings - Lower BAT */
#define BAT_WRITE_THROUGH 0x00000040
#define BAT_CACHE_INHIBITED 0x00000020
#define BAT_COHERENT 0x00000010
#define BAT_GUARDED 0x00000008
/* Protection bits - Lower BAT */
#define BAT_NO_ACCESS 0x00000000
#define BAT_READ_ONLY 0x00000001
#define BAT_READ_WRITE 0x00000002

/*** memory map MPC8360EA MDS PB (rev2) ***/
#define FLASH_BASE 0xfe000000
#define FLASH_BAT_BL BAT_BL_32M
#define DDR_BASE 0x00000000
#define DDR_BAT_BL BAT_BL_256M 
#define IMMR_BASE  0xe0000000
#define IMMR_BAT_BL  BAT_BL_1M
#define BCSR_BASE	0xf8000000
#define BCSR_BAT_BL BAT_BL_128K
#define SDRAM_BASE	0xf0000000
#define SDRAM_BAT_BL BAT_BL_64M
#define PCI1_BASE	0x80000000
#define PCI1_BAT_BL BAT_BL_512M

/*** BAT definition ***/

#define IBAT0L_VAL (FLASH_BASE|BAT_CACHE_INHIBITED|BAT_READ_WRITE)
#define IBAT0U_VAL (FLASH_BASE|BAT_VALID_SUPERVISOR|BAT_VALID_USER|FLASH_BAT_BL)
#define DBAT0L_VAL IBAT0L_VAL
#define DBAT0U_VAL IBAT0U_VAL

#define IBAT1L_VAL (DDR_BASE|BAT_READ_WRITE)
#define IBAT1U_VAL (DDR_BASE|BAT_VALID_SUPERVISOR|BAT_VALID_USER|DDR_BAT_BL)
#define DBAT1L_VAL IBAT1L_VAL
#define DBAT1U_VAL IBAT1U_VAL

#define IBAT2L_VAL (IMMR_BASE|BAT_CACHE_INHIBITED|BAT_READ_WRITE)
#define IBAT2U_VAL (IMMR_BASE|BAT_VALID_SUPERVISOR|BAT_VALID_USER|IMMR_BAT_BL)
#define DBAT2L_VAL IBAT2L_VAL
#define DBAT2U_VAL IBAT2U_VAL

#define IBAT3L_VAL (BCSR_BASE|BAT_CACHE_INHIBITED|BAT_READ_WRITE)
#define IBAT3U_VAL (BCSR_BASE|BAT_VALID_SUPERVISOR|BAT_VALID_USER|BCSR_BAT_BL)
#define DBAT3L_VAL IBAT3L_VAL
#define DBAT3U_VAL IBAT3U_VAL


#define IBAT4L_VAL (SDRAM_BASE|BAT_CACHE_INHIBITED|BAT_READ_WRITE)
#define IBAT4U_VAL (SDRAM_BASE|BAT_VALID_SUPERVISOR|BAT_VALID_USER|SDRAM_BAT_BL)
#define DBAT4L_VAL IBAT4L_VAL
#define DBAT4U_VAL IBAT4U_VAL

#define IBAT5L_VAL (PCI1_BASE|BAT_READ_WRITE)
#define IBAT5U_VAL (PCI1_BASE|BAT_VALID_SUPERVISOR|BAT_VALID_USER|PCI1_BAT_BL)
#define DBAT5L_VAL IBAT5L_VAL
#define DBAT5U_VAL IBAT5U_VAL

