#include "QADC_CCW_table.h"

/* Possible channel numbers depends on used multiplexing:
      internally multiplexed (non-multiplexed):    from 0 to 3, 52, 53, 55, 56
      externally multiplexed (multiplexed):        from 0 to 7, from 16 to 23 , 55, 56
   It can be used also these special cases instead of channel number:
      LOW_REF, HIGH_REF, HiLoDiv2, EOQ (EOQ1 and EOQ2 is the same macro)           */


int16 CCWtable[] = 
{
/*	channel  |  time    |  pause   |  bypass  ,
	CHAN(x)  |  IST(x)  |  P       |  BYP     , // write to every row */

	CHAN(0)  |  IST(0)                        , // 00
	CHAN(1)  |  IST(0)  |  P                  , // 01
	CHAN(2)  |  IST(0)                        , // 02
	CHAN(3)  |  IST(0)                        , // 03
	EOQ1                                      , // 04
	
	CHAN(52) |  IST(0)                        , // 05
	CHAN(53) |  IST(0)                        , // 06
	EOQ2                                      , // 07
/*	CHAN(0)  |  IST(0)                        , // 08
	CHAN(0)  |  IST(0)                        , // 09
	
	CHAN(0)  |  IST(0)                        , // 10
	CHAN(0)  |  IST(0)                        , // 11
	CHAN(0)  |  IST(0)                        , // 12
	CHAN(0)  |  IST(0)                        , // 13
	CHAN(0)  |  IST(0)                        , // 14
		
	CHAN(0)  |  IST(0)                        , // 15
	CHAN(0)  |  IST(0)                        , // 16
	CHAN(0)  |  IST(0)                        , // 17
	CHAN(0)  |  IST(0)                        , // 18
	CHAN(0)  |  IST(0)                        , // 19
			
	CHAN(0)  |  IST(0)                        , // 20
	CHAN(0)  |  IST(0)                        , // 21
	CHAN(0)  |  IST(0)                        , // 22
	CHAN(0)  |  IST(0)                        , // 23
	CHAN(0)  |  IST(0)                        , // 24
			
	CHAN(0)  |  IST(0)                        , // 25
	CHAN(0)  |  IST(0)                        , // 26
	CHAN(0)  |  IST(0)                        , // 27
	CHAN(0)  |  IST(0)                        , // 28
	CHAN(0)  |  IST(0)                        , // 29
			
	CHAN(0)  |  IST(0)                        , // 30
	CHAN(0)  |  IST(0)                        , // 31
	CHAN(0)  |  IST(0)                        , // 32
	CHAN(0)  |  IST(0)                        , // 33
	CHAN(0)  |  IST(0)                        , // 34
			
	CHAN(0)  |  IST(0)                        , // 35
	CHAN(0)  |  IST(0)                        , // 36
	CHAN(0)  |  IST(0)                        , // 37
	CHAN(0)  |  IST(0)                        , // 38
	CHAN(0)  |  IST(0)                        , // 39
			
	CHAN(0)  |  IST(0)                        , // 40
	CHAN(0)  |  IST(0)                        , // 41
	CHAN(0)  |  IST(0)                        , // 42
	CHAN(0)  |  IST(0)                        , // 43
	CHAN(0)  |  IST(0)                        , // 44
			
	CHAN(0)  |  IST(0)                        , // 45
	CHAN(0)  |  IST(0)                        , // 46
	CHAN(0)  |  IST(0)                        , // 47
	CHAN(0)  |  IST(0)                        , // 48
	CHAN(0)  |  IST(0)                        , // 49
			
	CHAN(0)  |  IST(0)                        , // 50
	CHAN(0)  |  IST(0)                        , // 51
	CHAN(0)  |  IST(0)                        , // 52
	CHAN(0)  |  IST(0)                        , // 53
	CHAN(0)  |  IST(0)                        , // 54
			
	CHAN(0)  |  IST(0)                        , // 55
	CHAN(0)  |  IST(0)                        , // 56
	CHAN(0)  |  IST(0)                        , // 57
	CHAN(0)  |  IST(0)                        , // 58
	CHAN(0)  |  IST(0)                        , // 59
			
	CHAN(0)  |  IST(0)                        , // 60
	CHAN(0)  |  IST(0)                        , // 61
	CHAN(0)  |  IST(0)                        , // 62
	CHAN(0)  |  IST(0)                          // 63	*/		 	
};

void set_CCW (void)
{
	int32 i;
	int32 CCWtable_length = sizeof(CCWtable)/2; // length of CCW is 16-bit words
	
	/**** initialize Conversion Command Word Table ****/

	for (i = 0; i < CCWtable_length; i++) 
	{
		MCF5282_QADC_CCW(i)	= CCWtable[i]; // copy CCW table from header file to CCW registers
	}
}

int32 get_BQ2 (void)
{
	int32 i;
	int32 CCWtable_length = sizeof(CCWtable)/2; // length of CCW in 16-bit words
	
	/**** identify beginning of Queue 2 ****/
	
	for (i = 0; i < CCWtable_length; i++) 
	{
		if ((MCF5282_QADC_CCW(i) & EOQ) == EOQ) // identify end of Q1
		{
			return (i+1); // return line after first EOQ code
		}
	}
	return (127); // no EOQ code (whole CCW is assigned for Q1)	
}