
#include "QADC_CCW_table.h"
#include "QADC_opmodes.h"
#include "mcf5282.h"
#include "init.h"
#include <stdio.h>

void QADC_init(void);
void cpu_pause(int usecs);

int main()
{	
	printf("\r***********  Queued analog to digital converter - example code no.2  ***********\n\r");
	printf("*                                                                              *\n\r");
	printf("*  Connect signal from generator to J5 header (EVB) or MCU_PORT header (LITE): *\n\r");
	printf("*                                                                              *\n\r");
	printf("*  QADC channel:       AN0                                                     *\n\r");
	printf("*  EVB-J5 pin:         5                                                       *\n\r");
	printf("*  LITE-MCU_PORT pin:  14                                                      *\n\r");
	printf("*                                                                              *\n\r");
	printf("*  GND can be connected to J5-1 (VSSA) in case JP23 is in position 2-3 or it   *\n\r");
	printf("*  can be connected to J6-1 (GND) in case JP23 is in default position 1-2.     *\n\r");
	printf("*                                                                              *\n\r");
	printf("*  First IRQ7 button pressing causes Q1 scan START.                            *\n\r");
	printf("*  Second IRQ7 button pressing causes Q1 scan STOP.                            *\n\r");
	printf("*                                                                              *\n\r");
	printf("********************************************************************************\n\r");
	printf("\n");

	/**** initialize Edge Port Module ****/
	
	MCF5282_EPORT_EPPAR = MCF5282_EPORT_EPPAR_EPPA7_RISING;
    MCF5282_EPORT_EPIER = MCF5282_EPORT_EPIER_EPIE7;
	
	
	/**** initialize Interrupt Controller ****/
	
	MCF5282_INTC0_ICR37 = MCF5282_INTC_ICR_IL(4) | MCF5282_INTC_ICR_IP(1); // QADC - Q1 conversion complete
	MCF5282_INTC0_ICR38 = MCF5282_INTC_ICR_IL(4) | MCF5282_INTC_ICR_IP(0); // QADC - Q2 conversion complete
	MCF5282_INTC0_ICR39 = MCF5282_INTC_ICR_IL(4) | MCF5282_INTC_ICR_IP(3); // QADC - Q1 conversion pause
	MCF5282_INTC0_ICR40 = MCF5282_INTC_ICR_IL(4) | MCF5282_INTC_ICR_IP(2); // QADC - Q2 conversion pause
	/* note: IRQ7 have hardwired level 7 and fixed midpoint priority - no ICR settings */
	MCF5282_INTC0_IMRH &= ~( MCF5282_INTC_IMRH_INT37 |
	                         MCF5282_INTC_IMRH_INT38 |
	                         MCF5282_INTC_IMRH_INT39 |
	                         MCF5282_INTC_IMRH_INT40 );    // unmask QADC interrupts individually
	MCF5282_INTC0_IMRL &= ~( MCF5282_INTC_IMRL_INT7    |   // unmask IRQ7 
	                         MCF5282_INTC_IMRL_MASKALL ); 
	/* note: MASKALL have to be unmasked earlier or in the same time then the rest of IMRL register!!! */
	asm (move.w #0x2000,SR); // unmask interrupts in core
	
	QADC_init();
	
	/**** idle ****/	
	
	while(1);
	return 0;
		
}

void QADC_init(void)
{
	/**** initialize CCW Table (this must be done before the QADC is enabled) ****/
	
	set_CCW(); // copy CCW table from header file QADC_CCWtable to CCW registers
	
		
	/**** initialize Queued Analog to Digital Converter (possibility to using CFInit) ****/
	
	MCF5282_QADC_QADCMCR = //MCF5282_QADC_QADCMCR_QSTOP | // stop enable
	                       //MCF5282_QADC_QADCMCR_SUPV  | // 1-supervisor only, 0-no retriction
	                       MCF5282_QADC_QADCMCR_QDBG  ; // finish any conversion in progress, then freeze in debug mode

	MCF5282_QADC_QACR0 = //MCF5282_QADC_QACR0_MUX |   // set for external multiplexing
	                     //MCF5282_QADC_QACR0_TRG |   // set for cross triggering (ETRIG1 trig Q2 and so)
	                     MCF5282_QADC_QACR0_QPR(127); // clock divider value 1-127 (divisor 4-256)
	
	MCF5282_QADC_QACR1 = MCF5282_QADC_QACRx_CIE  | // Q1 completion interrupt enable
                         MCF5282_QADC_QACRx_PIE  | // Q1 pause interrupt enable
                         MCF5282_QADC_QACRx_MQ(Q1_INTERVAL_TIMER_SINGLE_SCAN_4096); // operating mode           	
	
	MCF5282_QADC_QACR2 = MCF5282_QADC_QACRx_MQ(Q2_DISABLED) | // operating mode
	                     MCF5282_QADC_QACRx_BQ(get_BQ2());  // identify BQ2 parameter and write it to the register
}

void cpu_pause(int usecs)
{
    /* Enable the DMA Timer 3 */
    MCF5282_TIMER3_DTRR = (vuint32)(usecs - 1);
    MCF5282_TIMER3_DTER = MCF5282_TIMER_DTER_REF;
    MCF5282_TIMER3_DTMR = 0
        | MCF5282_TIMER_DTMR_PS(SYSTEM_CLOCK) // create 1us tick
        | MCF5282_TIMER_DTMR_ORRI
        | MCF5282_TIMER_DTMR_FRR
        | MCF5282_TIMER_DTMR_CLK_DIV1
        | MCF5282_TIMER_DTMR_RST;

    while ((MCF5282_TIMER3_DTER & MCF5282_TIMER_DTER_REF) == 0) 
    {};
    
    /* Disable the timer */
    MCF5282_TIMER3_DTMR = 0;
}


