/**
 * Copyright (c) 2006, Freescale Semiconductor
 * Freescale Confidential Proprietary
 *
 * File name   : main.c
 *
 * Author      : Paolo Alcantara
 * Department  : RTAC Americas
 *
 * Description : ADC api
 */
 
#include "mcf5222x_reg.h"
#include "adc.h"
#include "driver_reg.h"


/* Global variables */
//static hcc_u8 go;
//static accel_state_t start;

/* Functions */

/*
 * ADCgetACCdata: returns accelerometer axis (x, y and z)
 *
 * Parameters: accel_state: pointer to accelerometer descriptor
 *
 * Return : none.
 */
void ADCgetACCdata(accel_state_t *accel_state)
{     
	//if(go)
	//{
        accel_state->x_axis = (MCF_ADC_ADRSLT(4)>>6);// - start.x_axis;  

        accel_state->y_axis = (MCF_ADC_ADRSLT(5)>>6);// - start.y_axis;
        
        accel_state->z_axis = (MCF_ADC_ADRSLT(6)>>6);// - start.z_axis;    

	//}
	//else
	//{
	//	start.x_axis = (MCF_ADC_ADRSLT(4)>>6);
	//	start.y_axis = (MCF_ADC_ADRSLT(5)>>6);
	//	start.z_axis = (MCF_ADC_ADRSLT(6)>>6);
	//	go = 1;	
	//}
	
	return;
}


/*
 * ADCinit: enable ADC controller in loop sequential mode
 *
 * Parameters: none
 *
 * Return : none.
 */
void ADCinit()
{
    /* set pin function to ADC */
	MCF_GPIO_PANPAR = 0
					//| MCF_GPIO_PANPAR_AN0_AN0
					| MCF_GPIO_PANPAR_AN4_AN4
					| MCF_GPIO_PANPAR_AN5_AN5
					| MCF_GPIO_PANPAR_AN6_AN6
					;
	
	/* loop sequential */
	MCF_ADC_CTRL1   = MCF_ADC_CTRL1_SMODE(2);
	
	/* set ADC clock to ~2MHz according to manual */
    MCF_ADC_CTRL2   = MCF_ADC_CTRL2_DIV(7);
	
	/* the sampling order for channels */
    MCF_ADC_ADLST1	= 0
    				| MCF_ADC_ADLST1_SAMPLE0(4)
    				| MCF_ADC_ADLST1_SAMPLE1(4)
    				| MCF_ADC_ADLST1_SAMPLE2(4)
    				| MCF_ADC_ADLST1_SAMPLE3(5)
    				;
    
    /* the sampling order for channels */
    MCF_ADC_ADLST2	= 0
    				| MCF_ADC_ADLST2_SAMPLE4(5)
    				| MCF_ADC_ADLST2_SAMPLE5(5)
    				| MCF_ADC_ADLST2_SAMPLE6(6)
    				| MCF_ADC_ADLST2_SAMPLE7(6)
    				; 
    
    /* enabling all channels */
    MCF_ADC_ADSDIS  = 0;
    
    /* select AN2 as VRH and AN6 as VRL */
    /*
    MCF_ADC_CAL = 0
    			| MCF_ADC_CAL_VREFH
    			| MCF_ADC_CAL_VREFL
    			;
    */
    
    /* set the power-up delay in ADC */
    MCF_ADC_POWER   = DEFAULT_DELAY;//MCF_ADC_POWER_PUDELAY(4);
    
    while(MCF_ADC_POWER & MCF_ADC_POWER_PSTS0)
    ; /* wait until module is powered-up */
    
    return;	
}

/*
 * ADCinit: starts ADC controller
 *
 * Parameters: none
 *
 * Return : none.
 */
void ADCstart()
{
	MCF_ADC_CTRL1 |= MCF_ADC_CTRL1_START0;
	
	return;
}
/*
 * ACCinit: starts accelerometer
 *
 * Parameters: none
 *
 * Return : none.
 */
void ACCinit()
{
	/* starting global variable */
	//go = 0;

	/* turnining ADC channel: 1, 2 and 3 as GPIO output pins */
	MCF_GPIO_DDRAN = 0
				   | MCF_GPIO_DDRAN_DDRAN1
				   | MCF_GPIO_DDRAN_DDRAN2
				   | MCF_GPIO_DDRAN_DDRAN3
				   ;
	
	/* turning ACC ON with low sensibility */
	MCF_GPIO_PORTAN = 0
					| MCF_GPIO_PORTAN_PORTAN1
					| MCF_GPIO_PORTAN_PORTAN2
					| MCF_GPIO_PORTAN_PORTAN3//on/off
					;
					
	return;
}