/***************************************************************************
 *
 *            Copyright (c) 2006-2007 by CMX Systems, Inc.
 *
 * This software is copyrighted by and is the sole property of
 * CMX.  All rights, title, ownership, or other interests
 * in the software remain the property of CMX.  This
 * software may only be used in accordance with the corresponding
 * license agreement.  Any unauthorized use, duplication, transmission,
 * distribution, or disclosure of this software is expressly forbidden.
 *
 * This Copyright notice may not be removed or modified without prior
 * written consent of CMX.
 *
 * CMX reserves the right to modify this software without notice.
 *
 * CMX Systems, Inc.
 * 12276 San Jose Blvd. #511
 * Jacksonville, FL 32223
 * USA
 *
 * Tel:  (904) 880-1840
 * Fax:  (904) 880-1632
 * http: www.cmx.com
 * email: cmx@cmx.com
 *
 ***************************************************************************/
#ifndef _DRIVER_REG_H_
#define _DRIVER_REG_H_

#include "hcc_types.h"

/*
 * Memory Map Info
 */
#define IPSBAR_ADDRESS			(hcc_u32)_IPSBAR

/* Bit definitions and macros for MCF_QSPI_QDR */
#define MCF_QSPI_QDR_DATA(x)   (((x)&0xFFFF)<<0)
#define MCF_QSPI_QCR_CS(x)	   (((x)&0x000F)<<8)
#define MCF_QSPI_QDR_CONT      (0x8000)
#define MCF_QSPI_QDR_BITSE     (0x4000)
#define MCF_QSPI_QDR_DT        (0x2000)
#define MCF_QSPI_QDR_DSCK      (0x1000)
#define MCF_QSPI_QDR_QSPI_CS3  (0x800)
#define MCF_QSPI_QDR_QSPI_CS2  (0x400)
#define MCF_QSPI_QDR_QSPI_CS1  (0x200)
#define MCF_QSPI_QDR_QSPI_CS0  (0x100)

/*********************************************************************
*
* DMA Timers (DTIM)
*
*********************************************************************/

/* Register read/write macros */
#define MCF_DTIM0_DTMR           (*(hcc_reg16*)(&_IPSBAR[0x000400]))
#define MCF_DTIM0_DTXMR          (*(hcc_reg8 *)(&_IPSBAR[0x000402]))
#define MCF_DTIM0_DTER           (*(hcc_reg8 *)(&_IPSBAR[0x000403]))
#define MCF_DTIM0_DTRR           (*(hcc_reg32*)(&_IPSBAR[0x000404]))
#define MCF_DTIM0_DTCR           (*(hcc_reg32*)(&_IPSBAR[0x000408]))
#define MCF_DTIM0_DTCN           (*(hcc_reg32*)(&_IPSBAR[0x00040C]))
#define MCF_DTIM1_DTMR           (*(hcc_reg16*)(&_IPSBAR[0x000440]))
#define MCF_DTIM1_DTXMR          (*(hcc_reg8 *)(&_IPSBAR[0x000442]))
#define MCF_DTIM1_DTER           (*(hcc_reg8 *)(&_IPSBAR[0x000443]))
#define MCF_DTIM1_DTRR           (*(hcc_reg32*)(&_IPSBAR[0x000444]))
#define MCF_DTIM1_DTCR           (*(hcc_reg32*)(&_IPSBAR[0x000448]))
#define MCF_DTIM1_DTCN           (*(hcc_reg32*)(&_IPSBAR[0x00044C]))
#define MCF_DTIM2_DTMR           (*(hcc_reg16*)(&_IPSBAR[0x000480]))
#define MCF_DTIM2_DTXMR          (*(hcc_reg8 *)(&_IPSBAR[0x000482]))
#define MCF_DTIM2_DTER           (*(hcc_reg8 *)(&_IPSBAR[0x000483]))
#define MCF_DTIM2_DTRR           (*(hcc_reg32*)(&_IPSBAR[0x000484]))
#define MCF_DTIM2_DTCR           (*(hcc_reg32*)(&_IPSBAR[0x000488]))
#define MCF_DTIM2_DTCN           (*(hcc_reg32*)(&_IPSBAR[0x00048C]))
#define MCF_DTIM3_DTMR           (*(hcc_reg16*)(&_IPSBAR[0x0004C0]))
#define MCF_DTIM3_DTXMR          (*(hcc_reg8 *)(&_IPSBAR[0x0004C2]))
#define MCF_DTIM3_DTER           (*(hcc_reg8 *)(&_IPSBAR[0x0004C3]))
#define MCF_DTIM3_DTRR           (*(hcc_reg32*)(&_IPSBAR[0x0004C4]))
#define MCF_DTIM3_DTCR           (*(hcc_reg32*)(&_IPSBAR[0x0004C8]))
#define MCF_DTIM3_DTCN           (*(hcc_reg32*)(&_IPSBAR[0x0004CC]))
#define MCF_DTIM_DTMR(x)         (*(hcc_reg16*)(&_IPSBAR[0x000400+((x)*0x040)]))
#define MCF_DTIM_DTXMR(x)        (*(hcc_reg8 *)(&_IPSBAR[0x000402+((x)*0x040)]))
#define MCF_DTIM_DTER(x)         (*(hcc_reg8 *)(&_IPSBAR[0x000403+((x)*0x040)]))
#define MCF_DTIM_DTRR(x)         (*(hcc_reg32*)(&_IPSBAR[0x000404+((x)*0x040)]))
#define MCF_DTIM_DTCR(x)         (*(hcc_reg32*)(&_IPSBAR[0x000408+((x)*0x040)]))
#define MCF_DTIM_DTCN(x)         (*(hcc_reg32*)(&_IPSBAR[0x00040C+((x)*0x040)]))

/* Bit definitions and macros for MCF_DTIM_DTMR */
#define MCF_DTIM_DTMR_RST        (0x0001)
#define MCF_DTIM_DTMR_CLK(x)     (((x)&0x0003)<<1)
#define MCF_DTIM_DTMR_FRR        (0x0008)
#define MCF_DTIM_DTMR_ORRI       (0x0010)
#define MCF_DTIM_DTMR_OM         (0x0020)
#define MCF_DTIM_DTMR_CE(x)      (((x)&0x0003)<<6)
#define MCF_DTIM_DTMR_PS(x)      (((x)&0x00FF)<<8)
#define MCF_DTIM_DTMR_CE_ANY     (0x00C0)
#define MCF_DTIM_DTMR_CE_FALL    (0x0080)
#define MCF_DTIM_DTMR_CE_RISE    (0x0040)
#define MCF_DTIM_DTMR_CE_NONE    (0x0000)
#define MCF_DTIM_DTMR_CLK_DTIN   (0x0006)
#define MCF_DTIM_DTMR_CLK_DIV16  (0x0004)
#define MCF_DTIM_DTMR_CLK_DIV1   (0x0002)
#define MCF_DTIM_DTMR_CLK_STOP   (0x0000)

/* Bit definitions and macros for MCF_DTIM_DTXMR */
#define MCF_DTIM_DTXMR_MODE16    (0x01)
#define MCF_DTIM_DTXMR_DMAEN     (0x80)

/* Bit definitions and macros for MCF_DTIM_DTER */
#define MCF_DTIM_DTER_CAP        (0x01)
#define MCF_DTIM_DTER_REF        (0x02)

/* Bit definitions and macros for MCF_DTIM_DTRR */
#define MCF_DTIM_DTRR_REF(x)     (((x)&0xFFFFFFFF)<<0)

/* Bit definitions and macros for MCF_DTIM_DTCR */
#define MCF_DTIM_DTCR_CAP(x)     (((x)&0xFFFFFFFF)<<0)

/* Bit definitions and macros for MCF_DTIM_DTCN */
#define MCF_DTIM_DTCN_CNT(x)     (((x)&0xFFFFFFFF)<<0)

/*********************************************************************
*
* Analog-to-Digital Converter (ADC)
*
*********************************************************************/

/* Register read/write macros */
#define MCF_ADC_CTRL1                        (*(hcc_reg16*)(&_IPSBAR[0x190000]))
#define MCF_ADC_CTRL2                        (*(hcc_reg16*)(&_IPSBAR[0x190002]))
#define MCF_ADC_ADZCC                        (*(hcc_reg16*)(&_IPSBAR[0x190004]))
#define MCF_ADC_ADLST1                       (*(hcc_reg16*)(&_IPSBAR[0x190006]))
#define MCF_ADC_ADLST2                       (*(hcc_reg16*)(&_IPSBAR[0x190008]))
#define MCF_ADC_ADSDIS                       (*(hcc_reg16*)(&_IPSBAR[0x19000A]))
#define MCF_ADC_ADSTAT                       (*(hcc_reg16*)(&_IPSBAR[0x19000C]))
#define MCF_ADC_ADLSTAT                      (*(hcc_reg16*)(&_IPSBAR[0x19000E]))
#define MCF_ADC_ADZCSTAT                     (*(hcc_reg16*)(&_IPSBAR[0x190010]))
#define MCF_ADC_ADRSLT0                      (*(hcc_reg16*)(&_IPSBAR[0x190012]))
#define MCF_ADC_ADRSLT1                      (*(hcc_reg16*)(&_IPSBAR[0x190014]))
#define MCF_ADC_ADRSLT2                      (*(hcc_reg16*)(&_IPSBAR[0x190016]))
#define MCF_ADC_ADRSLT3                      (*(hcc_reg16*)(&_IPSBAR[0x190018]))
#define MCF_ADC_ADRSLT4                      (*(hcc_reg16*)(&_IPSBAR[0x19001A]))
#define MCF_ADC_ADRSLT5                      (*(hcc_reg16*)(&_IPSBAR[0x19001C]))
#define MCF_ADC_ADRSLT6                      (*(hcc_reg16*)(&_IPSBAR[0x19001E]))
#define MCF_ADC_ADRSLT7                      (*(hcc_reg16*)(&_IPSBAR[0x190020]))
#define MCF_ADC_ADLLMT0                      (*(hcc_reg16*)(&_IPSBAR[0x190022]))
#define MCF_ADC_ADLLMT1                      (*(hcc_reg16*)(&_IPSBAR[0x190024]))
#define MCF_ADC_ADLLMT2                      (*(hcc_reg16*)(&_IPSBAR[0x190026]))
#define MCF_ADC_ADLLMT3                      (*(hcc_reg16*)(&_IPSBAR[0x190028]))
#define MCF_ADC_ADLLMT4                      (*(hcc_reg16*)(&_IPSBAR[0x19002A]))
#define MCF_ADC_ADLLMT5                      (*(hcc_reg16*)(&_IPSBAR[0x19002C]))
#define MCF_ADC_ADLLMT6                      (*(hcc_reg16*)(&_IPSBAR[0x19002E]))
#define MCF_ADC_ADLLMT7                      (*(hcc_reg16*)(&_IPSBAR[0x190030]))
#define MCF_ADC_ADHLMT0                      (*(hcc_reg16*)(&_IPSBAR[0x190032]))
#define MCF_ADC_ADHLMT1                      (*(hcc_reg16*)(&_IPSBAR[0x190034]))
#define MCF_ADC_ADHLMT2                      (*(hcc_reg16*)(&_IPSBAR[0x190036]))
#define MCF_ADC_ADHLMT3                      (*(hcc_reg16*)(&_IPSBAR[0x190038]))
#define MCF_ADC_ADHLMT4                      (*(hcc_reg16*)(&_IPSBAR[0x19003A]))
#define MCF_ADC_ADHLMT5                      (*(hcc_reg16*)(&_IPSBAR[0x19003C]))
#define MCF_ADC_ADHLMT6                      (*(hcc_reg16*)(&_IPSBAR[0x19003E]))
#define MCF_ADC_ADHLMT7                      (*(hcc_reg16*)(&_IPSBAR[0x190040]))
#define MCF_ADC_ADOFS0                       (*(hcc_reg16*)(&_IPSBAR[0x190042]))
#define MCF_ADC_ADOFS1                       (*(hcc_reg16*)(&_IPSBAR[0x190044]))
#define MCF_ADC_ADOFS2                       (*(hcc_reg16*)(&_IPSBAR[0x190046]))
#define MCF_ADC_ADOFS3                       (*(hcc_reg16*)(&_IPSBAR[0x190048]))
#define MCF_ADC_ADOFS4                       (*(hcc_reg16*)(&_IPSBAR[0x19004A]))
#define MCF_ADC_ADOFS5                       (*(hcc_reg16*)(&_IPSBAR[0x19004C]))
#define MCF_ADC_ADOFS6                       (*(hcc_reg16*)(&_IPSBAR[0x19004E]))
#define MCF_ADC_ADOFS7                       (*(hcc_reg16*)(&_IPSBAR[0x190050]))
#define MCF_ADC_POWER                        (*(hcc_reg16*)(&_IPSBAR[0x190052]))
#define MCF_ADC_CAL                          (*(hcc_reg16*)(&_IPSBAR[0x190054]))
#define MCF_ADC_ADRSLT(x)                    (*(hcc_reg16*)(&_IPSBAR[0x190012 + ((x)*0x2)]))
#define MCF_ADC_ADLLMT(x)                    (*(hcc_reg16*)(&_IPSBAR[0x190022 + ((x)*0x2)]))
#define MCF_ADC_ADHLMT(x)                    (*(hcc_reg16*)(&_IPSBAR[0x190032 + ((x)*0x2)]))
#define MCF_ADC_ADOFS(x)                     (*(hcc_reg16*)(&_IPSBAR[0x190042 + ((x)*0x2)]))


/* Bit definitions and macros for MCF_ADC_CTRL1 */
#define MCF_ADC_CTRL1_SMODE(x)               (((x)&0x7)<<0)
#define MCF_ADC_CTRL1_CHNCFG(x)              (((x)&0xF)<<0x4)
#define MCF_ADC_CTRL1_HLMTIE                 (0x100)
#define MCF_ADC_CTRL1_LLMTIE                 (0x200)
#define MCF_ADC_CTRL1_ZCIE                   (0x400)
#define MCF_ADC_CTRL1_EOSIE0                 (0x800)
#define MCF_ADC_CTRL1_SYNC0                  (0x1000)
#define MCF_ADC_CTRL1_START0                 (0x2000)
#define MCF_ADC_CTRL1_STOP0                  (0x4000)

/* Bit definitions and macros for MCF_ADC_CTRL2 */
#define MCF_ADC_CTRL2_DIV(x)                 (((x)&0x1F)<<0)
#define MCF_ADC_CTRL2_SIMULT                 (0x20)
#define MCF_ADC_CTRL2_EOSIE1                 (0x800)
#define MCF_ADC_CTRL2_SYNC1                  (0x1000)
#define MCF_ADC_CTRL2_START1                 (0x2000)
#define MCF_ADC_CTRL2_STOP1                  (0x4000)

/* Bit definitions and macros for MCF_ADC_ADZCC */
#define MCF_ADC_ADZCC_ZCE0(x)                (((x)&0x3)<<0)
#define MCF_ADC_ADZCC_ZCE1(x)                (((x)&0x3)<<0x2)
#define MCF_ADC_ADZCC_ZCE2(x)                (((x)&0x3)<<0x4)
#define MCF_ADC_ADZCC_ZCE3(x)                (((x)&0x3)<<0x6)
#define MCF_ADC_ADZCC_ZCE4(x)                (((x)&0x3)<<0x8)
#define MCF_ADC_ADZCC_ZCE5(x)                (((x)&0x3)<<0xA)
#define MCF_ADC_ADZCC_ZCE6(x)                (((x)&0x3)<<0xC)
#define MCF_ADC_ADZCC_ZCE7(x)                (((x)&0x3)<<0xE)

/* Bit definitions and macros for MCF_ADC_ADLST1 */
#define MCF_ADC_ADLST1_SAMPLE0(x)            (((x)&0x7)<<0)
#define MCF_ADC_ADLST1_SAMPLE1(x)            (((x)&0x7)<<0x4)
#define MCF_ADC_ADLST1_SAMPLE2(x)            (((x)&0x7)<<0x8)
#define MCF_ADC_ADLST1_SAMPLE3(x)            (((x)&0x7)<<0xC)

/* Bit definitions and macros for MCF_ADC_ADLST2 */
#define MCF_ADC_ADLST2_SAMPLE4(x)            (((x)&0x7)<<0)
#define MCF_ADC_ADLST2_SAMPLE5(x)            (((x)&0x7)<<0x4)
#define MCF_ADC_ADLST2_SAMPLE6(x)            (((x)&0x7)<<0x8)
#define MCF_ADC_ADLST2_SAMPLE7(x)            (((x)&0x7)<<0xC)

/* Bit definitions and macros for MCF_ADC_ADSDIS */
#define MCF_ADC_ADSDIS_DS0                   (0x1)
#define MCF_ADC_ADSDIS_DS1                   (0x2)
#define MCF_ADC_ADSDIS_DS2                   (0x4)
#define MCF_ADC_ADSDIS_DS3                   (0x8)
#define MCF_ADC_ADSDIS_DS4                   (0x10)
#define MCF_ADC_ADSDIS_DS5                   (0x20)
#define MCF_ADC_ADSDIS_DS6                   (0x40)
#define MCF_ADC_ADSDIS_DS7                   (0x80)

/* Bit definitions and macros for MCF_ADC_ADSTAT */
#define MCF_ADC_ADSTAT_RDY0                  (0x1)
#define MCF_ADC_ADSTAT_RDY1                  (0x2)
#define MCF_ADC_ADSTAT_RDY2                  (0x4)
#define MCF_ADC_ADSTAT_RDY3                  (0x8)
#define MCF_ADC_ADSTAT_RDY4                  (0x10)
#define MCF_ADC_ADSTAT_RDY5                  (0x20)
#define MCF_ADC_ADSTAT_RDY6                  (0x40)
#define MCF_ADC_ADSTAT_RDY7                  (0x80)
#define MCF_ADC_ADSTAT_HLMTI                 (0x100)
#define MCF_ADC_ADSTAT_LLMTI                 (0x200)
#define MCF_ADC_ADSTAT_ZCI                   (0x400)
#define MCF_ADC_ADSTAT_EOSI0                 (0x800)
#define MCF_ADC_ADSTAT_EOSI1                 (0x1000)
#define MCF_ADC_ADSTAT_CIP1                  (0x4000)
#define MCF_ADC_ADSTAT_CIP0                  (0x8000)

/* Bit definitions and macros for MCF_ADC_ADLSTAT */
#define MCF_ADC_ADLSTAT_LLS0                 (0x1)
#define MCF_ADC_ADLSTAT_LLS1                 (0x2)
#define MCF_ADC_ADLSTAT_LLS2                 (0x4)
#define MCF_ADC_ADLSTAT_LLS3                 (0x8)
#define MCF_ADC_ADLSTAT_LLS4                 (0x10)
#define MCF_ADC_ADLSTAT_LLS5                 (0x20)
#define MCF_ADC_ADLSTAT_LLS6                 (0x40)
#define MCF_ADC_ADLSTAT_LLS7                 (0x80)
#define MCF_ADC_ADLSTAT_HLS0                 (0x100)
#define MCF_ADC_ADLSTAT_HLS1                 (0x200)
#define MCF_ADC_ADLSTAT_HLS2                 (0x400)
#define MCF_ADC_ADLSTAT_HLS3                 (0x800)
#define MCF_ADC_ADLSTAT_HLS4                 (0x1000)
#define MCF_ADC_ADLSTAT_HLS5                 (0x2000)
#define MCF_ADC_ADLSTAT_HLS6                 (0x4000)
#define MCF_ADC_ADLSTAT_HLS7                 (0x8000)

/* Bit definitions and macros for MCF_ADC_ADZCSTAT */
#define MCF_ADC_ADZCSTAT_ZCS0                (0x1)
#define MCF_ADC_ADZCSTAT_ZCS1                (0x2)
#define MCF_ADC_ADZCSTAT_ZCS2                (0x4)
#define MCF_ADC_ADZCSTAT_ZCS3                (0x8)
#define MCF_ADC_ADZCSTAT_ZCS4                (0x10)
#define MCF_ADC_ADZCSTAT_ZCS5                (0x20)
#define MCF_ADC_ADZCSTAT_ZCS6                (0x40)
#define MCF_ADC_ADZCSTAT_ZCS7                (0x80)

/* Bit definitions and macros for MCF_ADC_ADRSLT */
#define MCF_ADC_ADRSLT_RSLT(x)               (((x)&0xFFF)<<0x3)
#define MCF_ADC_ADRSLT_SEXT                  (0x8000)

/* Bit definitions and macros for MCF_ADC_ADLLMT */
#define MCF_ADC_ADLLMT_LLMT(x)               (((x)&0xFFF)<<0x3)

/* Bit definitions and macros for MCF_ADC_ADHLMT */
#define MCF_ADC_ADHLMT_HLMT(x)               (((x)&0xFFF)<<0x3)

/* Bit definitions and macros for MCF_ADC_ADOFS */
#define MCF_ADC_ADOFS_OFFSET(x)              (((x)&0xFFF)<<0x3)

/* Bit definitions and macros for MCF_ADC_POWER */
#define MCF_ADC_POWER_PD0                    (0x1)
#define MCF_ADC_POWER_PD1                    (0x2)
#define MCF_ADC_POWER_PD2                    (0x4)
#define MCF_ADC_POWER_APD                    (0x8)
#define MCF_ADC_POWER_PUDELAY(x)             (((x)&0x3F)<<0x4)
#define MCF_ADC_POWER_PSTS0                  (0x400)
#define MCF_ADC_POWER_PSTS1                  (0x800)
#define MCF_ADC_POWER_PSTS2                  (0x1000)
#define MCF_ADC_POWER_ASB                    (0x8000)

/* Bit definitions and macros for MCF_ADC_CAL */
#define MCF_ADC_CAL_SEL_VREFL                (0x4000)
#define MCF_ADC_CAL_SEL_VREFH                (0x8000)


/*********************************************************************
*
* Real-Time Clock (RTC)
*
*********************************************************************/

/* Register read/write macros */
#define MCF_RTC_HOURMIN                      (*(hcc_reg32*)(&_IPSBAR[0x3C0]))
#define MCF_RTC_SECONDS                      (*(hcc_reg32*)(&_IPSBAR[0x3C4]))
#define MCF_RTC_ALRM_HM                      (*(hcc_reg32*)(&_IPSBAR[0x3C8]))
#define MCF_RTC_ALRM_SEC                     (*(hcc_reg32*)(&_IPSBAR[0x3CC]))
#define MCF_RTC_RTCCTL                       (*(hcc_reg32*)(&_IPSBAR[0x3D0]))
#define MCF_RTC_RTCISR                       (*(hcc_reg32*)(&_IPSBAR[0x3D4]))
#define MCF_RTC_RTCIENR                      (*(hcc_reg32*)(&_IPSBAR[0x3D8]))
#define MCF_RTC_STPWCH                       (*(hcc_reg32*)(&_IPSBAR[0x3DC]))
#define MCF_RTC_DAYS                         (*(hcc_reg32*)(&_IPSBAR[0x3E0]))
#define MCF_RTC_ALRM_DAY                     (*(hcc_reg32*)(&_IPSBAR[0x3E4]))
#define MCF_RTC_RTCGOCU					 	 (*(hcc_reg32*)(&_IPSBAR[0x3F4]))
#define MCF_RTC_RTCGOCL					 	 (*(hcc_reg32*)(&_IPSBAR[0x3F8]))

/* Bit definitions and macros for MCF_RTC_HOURMIN */
#define MCF_RTC_HOURMIN_MINUTES(x)           (((x)&0x3F)<<0)
#define MCF_RTC_HOURMIN_HOURS(x)             (((x)&0x1F)<<0x8)

/* Bit definitions and macros for MCF_RTC_SECONDS */
#define MCF_RTC_SECONDS_SECONDS(x)           (((x)&0x3F)<<0)

/* Bit definitions and macros for MCF_RTC_ALRM_HM */
#define MCF_RTC_ALRM_HM_MINUTES(x)           (((x)&0x3F)<<0)
#define MCF_RTC_ALRM_HM_HOURS(x)             (((x)&0x1F)<<0x8)

/* Bit definitions and macros for MCF_RTC_ALRM_SEC */
#define MCF_RTC_ALRM_SEC_SECONDS(x)          (((x)&0x3F)<<0)

/* Bit definitions and macros for MCF_RTC_RTCCTL */
#define MCF_RTC_RTCCTL_SWR                   (0x1)
#define MCF_RTC_RTCCTL_EN                    (0x80)

/* Bit definitions and macros for MCF_RTC_RTCISR */
#define MCF_RTC_RTCISR_SW                    (0x1)
#define MCF_RTC_RTCISR_MIN                   (0x2)
#define MCF_RTC_RTCISR_ALM                   (0x4)
#define MCF_RTC_RTCISR_DAY                   (0x8)
#define MCF_RTC_RTCISR_1HZ                   (0x10)
#define MCF_RTC_RTCISR_HR                    (0x20)

/* Bit definitions and macros for MCF_RTC_RTCIENR */
#define MCF_RTC_RTCIENR_SW                   (0x1)
#define MCF_RTC_RTCIENR_MIN                  (0x2)
#define MCF_RTC_RTCIENR_ALM                  (0x4)
#define MCF_RTC_RTCIENR_DAY                  (0x8)
#define MCF_RTC_RTCIENR_1HZ                  (0x10)
#define MCF_RTC_RTCIENR_HR                   (0x20)

/* Bit definitions and macros for MCF_RTC_STPWCH */
#define MCF_RTC_STPWCH_CNT(x)                (((x)&0x3F)<<0)

/* Bit definitions and macros for MCF_RTC_DAYS */
#define MCF_RTC_DAYS_DAYS(x)                 (((x)&0xFFFF)<<0)

/* Bit definitions and macros for MCF_RTC_ALRM_DAY */
#define MCF_RTC_ALRM_DAY_DAYSAL(x)           (((x)&0xFFFF)<<0)


/*********************************************************************
*
* DMA Controller (DMA)
*
*********************************************************************/

/* Register read/write macros */
#define MCF_DMA0_SAR                         (*(hcc_reg32*)(&_IPSBAR[0x100]))
#define MCF_DMA0_DAR                         (*(hcc_reg32*)(&_IPSBAR[0x104]))
#define MCF_DMA0_DSR                         (*(hcc_reg8 *)(&_IPSBAR[0x108]))
#define MCF_DMA0_BCR                         (*(hcc_reg32*)(&_IPSBAR[0x108]))
#define MCF_DMA0_DCR                         (*(hcc_reg32*)(&_IPSBAR[0x10C]))

#define MCF_DMA1_SAR                         (*(hcc_reg32*)(&_IPSBAR[0x110]))
#define MCF_DMA1_DAR                         (*(hcc_reg32*)(&_IPSBAR[0x114]))
#define MCF_DMA1_DSR                         (*(hcc_reg8 *)(&_IPSBAR[0x118]))
#define MCF_DMA1_BCR                         (*(hcc_reg32*)(&_IPSBAR[0x118]))
#define MCF_DMA1_DCR                         (*(hcc_reg32*)(&_IPSBAR[0x11C]))

#define MCF_DMA2_SAR                         (*(hcc_reg32*)(&_IPSBAR[0x120]))
#define MCF_DMA2_DAR                         (*(hcc_reg32*)(&_IPSBAR[0x124]))
#define MCF_DMA2_DSR                         (*(hcc_reg8 *)(&_IPSBAR[0x128]))
#define MCF_DMA2_BCR                         (*(hcc_reg32*)(&_IPSBAR[0x128]))
#define MCF_DMA2_DCR                         (*(hcc_reg32*)(&_IPSBAR[0x12C]))

#define MCF_DMA3_SAR                         (*(hcc_reg32*)(&_IPSBAR[0x130]))
#define MCF_DMA3_DAR                         (*(hcc_reg32*)(&_IPSBAR[0x134]))
#define MCF_DMA3_DSR                         (*(hcc_reg8 *)(&_IPSBAR[0x138]))
#define MCF_DMA3_BCR                         (*(hcc_reg32*)(&_IPSBAR[0x138]))
#define MCF_DMA3_DCR                         (*(hcc_reg32*)(&_IPSBAR[0x13C]))

#define MCF_DMA_SAR(x)                       (*(hcc_reg32*)(&_IPSBAR[0x100 + ((x)*0x10)]))
#define MCF_DMA_DAR(x)                       (*(hcc_reg32*)(&_IPSBAR[0x104 + ((x)*0x10)]))
#define MCF_DMA_DSR(x)                       (*(hcc_reg8 *)(&_IPSBAR[0x108 + ((x)*0x10)]))
#define MCF_DMA_BCR(x)                       (*(hcc_reg32*)(&_IPSBAR[0x108 + ((x)*0x10)]))
#define MCF_DMA_DCR(x)                       (*(hcc_reg32*)(&_IPSBAR[0x10C + ((x)*0x10)]))


/* Bit definitions and macros for MCF_DMA_SAR */
#define MCF_DMA_SAR_SAR(x)                   (((x)&0xFFFFFFFF)<<0)

/* Bit definitions and macros for MCF_DMA_DAR */
#define MCF_DMA_DAR_DAR(x)                   (((x)&0xFFFFFFFF)<<0)

/* Bit definitions and macros for MCF_DMA_DSR */
#define MCF_DMA_DSR_DONE                     (0x1)
#define MCF_DMA_DSR_BSY                      (0x2)
#define MCF_DMA_DSR_REQ                      (0x4)
#define MCF_DMA_DSR_BED                      (0x10)
#define MCF_DMA_DSR_BES                      (0x20)
#define MCF_DMA_DSR_CE                       (0x40)

/* Bit definitions and macros for MCF_DMA_BCR */
#define MCF_DMA_BCR_BCR(x)                   (((x)&0xFFFFFF)<<0)
#define MCF_DMA_BCR_DSR(x)                   (((x)&0xFF)<<0x18)

/* Bit definitions and macros for MCF_DMA_DCR */
#define MCF_DMA_DCR_LCH2(x)                  (((x)&0x3)<<0)
#define MCF_DMA_DCR_LCH2_CH0                 (0)
#define MCF_DMA_DCR_LCH2_CH1                 (0x1)
#define MCF_DMA_DCR_LCH2_CH2                 (0x2)
#define MCF_DMA_DCR_LCH2_CH3                 (0x3)
#define MCF_DMA_DCR_LCH1(x)                  (((x)&0x3)<<0x2)
#define MCF_DMA_DCR_LCH1_CH0                 (0)
#define MCF_DMA_DCR_LCH1_CH1                 (0x1)
#define MCF_DMA_DCR_LCH1_CH2                 (0x2)
#define MCF_DMA_DCR_LCH1_CH3                 (0x3)
#define MCF_DMA_DCR_LINKCC(x)                (((x)&0x3)<<0x4)
#define MCF_DMA_DCR_D_REQ                    (0x80)
#define MCF_DMA_DCR_DMOD(x)                  (((x)&0xF)<<0x8)
#define MCF_DMA_DCR_DMOD_DIS                 (0)
#define MCF_DMA_DCR_DMOD_16                  (0x1)
#define MCF_DMA_DCR_DMOD_32                  (0x2)
#define MCF_DMA_DCR_DMOD_64                  (0x3)
#define MCF_DMA_DCR_DMOD_128                 (0x4)
#define MCF_DMA_DCR_DMOD_256                 (0x5)
#define MCF_DMA_DCR_DMOD_512                 (0x6)
#define MCF_DMA_DCR_DMOD_1K                  (0x7)
#define MCF_DMA_DCR_DMOD_2K                  (0x8)
#define MCF_DMA_DCR_DMOD_4K                  (0x9)
#define MCF_DMA_DCR_DMOD_8K                  (0xA)
#define MCF_DMA_DCR_DMOD_16K                 (0xB)
#define MCF_DMA_DCR_DMOD_32K                 (0xC)
#define MCF_DMA_DCR_DMOD_64K                 (0xD)
#define MCF_DMA_DCR_DMOD_128K                (0xE)
#define MCF_DMA_DCR_DMOD_256K                (0xF)
#define MCF_DMA_DCR_SMOD(x)                  (((x)&0xF)<<0xC)
#define MCF_DMA_DCR_SMOD_DIS                 (0)
#define MCF_DMA_DCR_SMOD_16                  (0x1)
#define MCF_DMA_DCR_SMOD_32                  (0x2)
#define MCF_DMA_DCR_SMOD_64                  (0x3)
#define MCF_DMA_DCR_SMOD_128                 (0x4)
#define MCF_DMA_DCR_SMOD_256                 (0x5)
#define MCF_DMA_DCR_SMOD_512                 (0x6)
#define MCF_DMA_DCR_SMOD_1K                  (0x7)
#define MCF_DMA_DCR_SMOD_2K                  (0x8)
#define MCF_DMA_DCR_SMOD_4K                  (0x9)
#define MCF_DMA_DCR_SMOD_8K                  (0xA)
#define MCF_DMA_DCR_SMOD_16K                 (0xB)
#define MCF_DMA_DCR_SMOD_32K                 (0xC)
#define MCF_DMA_DCR_SMOD_64K                 (0xD)
#define MCF_DMA_DCR_SMOD_128K                (0xE)
#define MCF_DMA_DCR_SMOD_256K                (0xF)
#define MCF_DMA_DCR_START                    (0x10000)
#define MCF_DMA_DCR_DSIZE(x)                 (((x)&0x3)<<0x11)
#define MCF_DMA_DCR_DSIZE_LONG               (0)
#define MCF_DMA_DCR_DSIZE_BYTE               (0x1)
#define MCF_DMA_DCR_DSIZE_WORD               (0x2)
#define MCF_DMA_DCR_DSIZE_LINE               (0x3)
#define MCF_DMA_DCR_DINC                     (0x80000)
#define MCF_DMA_DCR_SSIZE(x)                 (((x)&0x3)<<0x14)
#define MCF_DMA_DCR_SSIZE_LONG               (0)
#define MCF_DMA_DCR_SSIZE_BYTE               (0x1)
#define MCF_DMA_DCR_SSIZE_WORD               (0x2)
#define MCF_DMA_DCR_SSIZE_LINE               (0x3)
#define MCF_DMA_DCR_SINC                     (0x400000)
#define MCF_DMA_DCR_BWC(x)                   (((x)&0x7)<<0x19)
#define MCF_DMA_DCR_BWC_16K                  (0x1)
#define MCF_DMA_DCR_BWC_32K                  (0x2)
#define MCF_DMA_DCR_BWC_64K                  (0x3)
#define MCF_DMA_DCR_BWC_128K                 (0x4)
#define MCF_DMA_DCR_BWC_256K                 (0x5)
#define MCF_DMA_DCR_BWC_512K                 (0x6)
#define MCF_DMA_DCR_BWC_1024K                (0x7)
#define MCF_DMA_DCR_AA                       (0x10000000)
#define MCF_DMA_DCR_CS                       (0x20000000)
#define MCF_DMA_DCR_EEXT                     (0x40000000)
#define MCF_DMA_DCR_INT                      (0x80000000)


/*********************************************************************
*
* Clock Module (CLOCK)
*
*********************************************************************/

/* Register read/write macros */
#define MCF_CLOCK_ROCR                       (*(hcc_reg16*)(&_IPSBAR[0x120004]))
#define MCF_CLOCK_CCLR                       (*(hcc_reg8 *)(&_IPSBAR[0x120009]))
#define MCF_CLOCK_OCHR                       (*(hcc_reg8 *)(&_IPSBAR[0x12000A]))
#define MCF_CLOCK_OCLR                       (*(hcc_reg8 *)(&_IPSBAR[0x12000B]))
#define MCF_CLOCK_RTCCR                      (*(hcc_reg8 *)(&_IPSBAR[0x120012]))
#define MCF_CLOCK_BWCR                       (*(hcc_reg8 *)(&_IPSBAR[0x120013]))

/* Bit definitions and macros for MCF_CLOCK_ROCR */
#define MCF_CLOCK_ROCR_TRIM(x)               (((x)&0x3FF)<<0)

/* Bit definitions and macros for MCF_CLOCK_CCLR */
#define MCF_CLOCK_CCLR_OSCSEL0               (0x1)
#define MCF_CLOCK_CCLR_OSCSEL1               (0x2)

/* Bit definitions and macros for MCF_CLOCK_OCHR */
#define MCF_CLOCK_OCHR_STBY                  (0x40)
#define MCF_CLOCK_OCHR_OCOEN                 (0x80)

/* Bit definitions and macros for MCF_CLOCK_OCLR */
#define MCF_CLOCK_OCLR_RANGE                 (0x10)
#define MCF_CLOCK_OCLR_LPEN                  (0x20)
#define MCF_CLOCK_OCLR_REFS                  (0x40)
#define MCF_CLOCK_OCLR_OSCEN                 (0x80)

/* Bit definitions and macros for MCF_CLOCK_RTCCR */
#define MCF_CLOCK_RTCCR_RTCSEL               (0x1)
#define MCF_CLOCK_RTCCR_LPEN                 (0x2)
#define MCF_CLOCK_RTCCR_REFS                 (0x4)
#define MCF_CLOCK_RTCCR_KHZEN                (0x8)
#define MCF_CLOCK_RTCCR_OSCEN                (0x10)

/* Bit definitions and macros for MCF_CLOCK_BWCR */
#define MCF_CLOCK_BWCR_BWDSEL                (0x1)
#define MCF_CLOCK_BWCR_BWDSTOP               (0x2)


#endif
/****************************** END OF FILE **********************************/
