/*
 * File:        rtc.h
 * Purpose:     driver
 *
 * Notes:
 */

#ifndef __RTC_H__
#define __RTC_H__

/********************************************************************/

/* Driver-specific defines */

#define RTC_INTERRUPT

/* Specific Data types */

typedef struct
{
	hcc_u16 days;
	hcc_u8 hours;
	hcc_u8 minutes;
	hcc_u8 seconds;
	hcc_u8 pad;
}rtc_state_t;

/****************************Prototypes*********************************/

void RTCinit();
void RTCstart();
void RTCsetTime(rtc_state_t *rtc_state);
void RTCgetTime(rtc_state_t *rtc_state);
void RTCsetAlarm(rtc_state_t *rtc_state);
void RTCgetAlarm(rtc_state_t *rtc_state);
__declspec(interrupt:0) void rtc_ISR(void);

/********************************************************************/

#endif /* __RTC_H__ */