/****************************************************************************
 *
 *            Copyright (c) 2006-2007 by CMX Systems, Inc.
 *
 * This software is copyrighted by and is the sole property of
 * CMX.  All rights, title, ownership, or other interests
 * in the software remain the property of CMX.  This
 * software may only be used in accordance with the corresponding
 * license agreement.  Any unauthorized use, duplication, transmission,
 * distribution, or disclosure of this software is expressly forbidden.
 *
 * This Copyright notice may not be removed or modified without prior
 * written consent of CMX.
 *
 * CMX reserves the right to modify this software without notice.
 *
 * CMX Systems, Inc.
 * 12276 San Jose Blvd. #511
 * Jacksonville, FL 32223
 * USA
 *
 * Tel:  (904) 880-1840
 * Fax:  (904) 880-1632
 * http: www.cmx.com
 * email: cmx@cmx.com
 *
 ***************************************************************************/
#include "mcf5222x_reg.h"
#include "usb.h"
#include "usb_driver.h"

/* API used for control packets */
#include "drivers/rtc/rtc.h"

/****************************************************************************
 ************************** Function definitions ****************************
 ***************************************************************************/

extern hcc_u8 bulk_transfer;
hcc_u16 variable_length;

/* RTC struct */
rtc_state_t rtc_value;
  
/* temp variable */
hcc_u8 temp[5];

/****************************************************************************
 ************************** Function predefinitions. ************************
 ***************************************************************************/
callback_state_t new_rtc_time(void);
callback_state_t init_rtc_time(void);


#ifdef ON_THE_GO
/* If on-the-go is used pull-up control is done by the on-the-go driver.
   To avoid having trouble this callback must be empty. */
void enable_usb_pull_up(void)
{
}
#else
void enable_usb_pull_up(void)
{
  MCF_USB_OTG_CTRL = MCF_USB_OTG_CTRL_DP_HIGH |MCF_USB_OTG_CTRL_OTG_EN;
  //MCF_GPIO_PQSPAR |= MCF_GPIO_PQSPAR_PQSPAR5(3) | MCF_GPIO_PQSPAR_PQSPAR6(3);
  /*
   * Identify which MCU of which revision we are executing on
   */
  switch (MCF_CIM_CIR)
  {
	  case 0x1200:	//MCF52211 Rev 0
	  case 0x1240:	//MCF52210 Rev 0
	  case 0x1400:	//MCF52221 Rev 0
	  case 0x14C0:	//MCF52223 Rev 0
	  	// Below is "fix" for HOST resistor errattum.
	    MCF_USB_OTG_CTRL |= MCF_USB_OTG_CTRL_DM_LOW;
	    break;
	  default:
	    break;
  }
}
#endif

/*****************************************************************************
 * USB callback function. Is called by the USB driver if an USB error event
 * occurs.
 ****************************************************************************/
void usb_bus_error_event(void)
{
  /* empty */
}

/*****************************************************************************
 * USB callback function. Is called by the USB driver if an USB suspend event
 * occurs.
 ****************************************************************************/
void usb_suspend_event(void)
{
  /* empty */
}

/*****************************************************************************
 * USB callback function. Is called by the USB driver if an USB wakeup event
 * occurs.
 ****************************************************************************/
void usb_wakeup_event(void)
{
  /* empty */
}

/*****************************************************************************
 * USB callback function. Is called by the USB driver if an USB reset event
 * occurs.
 ****************************************************************************/
void usb_reset_event(void)
{
  /* empty */
}

/*****************************************************************************
 * USB callback function. Is called by the USB driver when a new RTC time
 * is sent by the host
 ****************************************************************************/
callback_state_t new_rtc_time(void)
{
  /* setting new time */
  rtc_value.days = (hcc_u16)((temp[0]<<8) + temp[1]);
  rtc_value.hours = temp[2];
  rtc_value.minutes = temp[3];
  rtc_value.seconds = temp[4];
  
  RTCsetTime(&rtc_value);
  
  return(clbst_ok);
}

/*****************************************************************************
 * USB callback function. Is called by the USB driver when a RTC is started
 ****************************************************************************/
callback_state_t init_rtc_time(void)
{
  RTCinit();
  RTCstart();
  
  return(clbst_ok);
}

/*****************************************************************************
 * USB callback function. Is called by the USB driver if a non standard
 * request is received from the HOST. This callback extends the known
 * requests by masstorage related ones.
 ****************************************************************************/
callback_state_t usb_ep0_callback(void)
{
  hcc_u8 *pdata=usb_get_rx_pptr(0);
  
  callback_state_t r=clbst_error;

    switch(STP_REQU_TYPE(pdata))
    {
	  /* A device vendor-specific device-to-host setup packet */
	  case (0xC0):
	    /* Host wants to get a descriptor */
	    switch (STP_REQUEST(pdata))
	    {
	      case RTC_GET_CLOCK:
	      
	      	RTCgetTime(&rtc_value);
	      
	      	/* time format for USB packet */
	      	temp[0] = (hcc_u8)(rtc_value.days & 0xFF00)>>8;
	      	temp[1] = (hcc_u8)(rtc_value.days & 0x00FF);
	      	temp[2] = rtc_value.hours;
	      	temp[3] = rtc_value.minutes;
	      	temp[4] = rtc_value.seconds;
	      
	        usb_send(0, 0, (void*)&temp, 5, STP_LENGTH(pdata));
	        r=clbst_in;  
	        break;      
	      default:
	        break;
	    }
      /* A device vendor-specific host-to-device setup packet */
      case (0x40):
        /* Host wants to send a descriptor */
        switch (STP_REQUEST(pdata))
        {
          case RTC_ENABLE:
          	r=clbst_out;
          	/* starting RTC module */
          	/* receiving dummy byte to get callback function */
            usb_receive(0, init_rtc_time, (void *)&temp, 1);
            break;
          case RTC_SET_CLOCK:
            usb_receive(0, new_rtc_time, (void *)&temp, 5);
            r=clbst_out;
            break;
          case UART_BULK_TRANSFER:
          	r=clbst_out;
            /* ready to receive from bulk endpoint */
            bulk_transfer = 1;
            variable_length = STP_VALUE(pdata);
            break;
          default:
            break;
        }
      /* not a known setup packet */
      default:
        break;
    }
  
  return(r);
}

/*****************************************************************************
* Name:
*    USBinput_ready
* In:
*    endpoint: endpoint number
*    ep_state: endpoint customized descriptor 
*
* Out:
*    0: nothing received
*    1: something received
*
* Description:
*    Will return one, if and endpoint contains any unread characters.
*
* Assumptions:
*    This function is called periodicaly. (Otherwise usb_receive call will
*    not bee made, and no data will get received over the USB.)
*****************************************************************************/
hcc_u8 USBinput_ready(hcc_u8 endpoint, ep_state_t *ep_state)
{
  /* See if host is talking to us */
  if (usb_get_state() == USBST_CONFIGURED)
  {
	  if(!(ep_state->ep_state))
	  {
	    /* We have no information how much data the host is willing to send,
	       and thus we don't know when the started transmission will end.
	       The usb driver will treat a trensmission ended if the number of
	       needed bytes has been received, or if a short packet has been
	       received. So we ask the driver to receive data that fits exactly
	       one packet. This way after the first frame the transfer will end.
	       (If the host sends less data than a packet, then it will end any way,
	       and if the host wants to send more data then a packet can hold, then
	       we will make an usb_receive call for each packet.
	       If we wold try to receive let's syat 64k, and the host has not that
	       much data, then we would wait till the end of time for data. */
	    usb_receive(endpoint, (void *) 0, (void *) ep_state->ep_buffer, ep_state->ep_length);
	    ep_state->ep_state = EP_READY;
	    return(0);
	  }
	  else
	  {
		  /* If we get here, then the rx buffer is empty, and a frame reception is
		     started. So we check for the status of the reception. */
		  if (!usb_ep_is_busy(endpoint))
		  {
		    /* Read out error status of endpoint. The reception may be aborted due
		       to a status change on the USB (disconnect, sleep, etc..) or due to
		       an error (CRC, bit stuffing, etc...). In both case wee need to restart
		       reception if possible.  */
		    switch(usb_ep_error(endpoint))
		    {
		    case USBEPERR_NONE: /* Reception finished with no error. */
		      /* Read out number of received bytes. This will make us to return
		         received characters for the next call. Note: the transfer may
		         contain 0 characters, so we return the first character only when
		         the next call is made. */
		      ep_state->ep_length = (hcc_u8)usb_get_done(endpoint);
		      /* we have received something */
		      ep_state->ep_state = EP_NOT_READY;
		      return 1;
		      break;
		    case USBEPERR_PROTOCOL_ERROR:
		      /* If we have an error, then we restart the reception. */
		      usb_receive(endpoint, (void *) 0, (void *) ep_state->ep_buffer, ep_state->ep_length);		      
		      return 0;
		      break;
		    case USBEPERR_HOST_ABORT:
		      /* USB disconnected or in low power mode.
		         Do nothing because this is handled by the second if above. */
		      break;
		    case USBEPERR_USER_ABORT:
		    case USBEPERR_TO_MANY_DATA:
		    default:
		      /* Upps! unexpected error. Stop here. */
		      while(1)
		      ;
		    }
		  }
	  }
  }
  return(0);
}


/*****************************************************************************
* Name:
*    USBsend
* In:
*    endpoint: endpoint number
*    ep_state: endpoint customized descriptor
* Out:
*    1 if packet was sent, otherwise 0
*
* Description:
*    Put an array into specified endpoint.
*
* Assumptions:
*    --
*****************************************************************************/
hcc_u8 USBsend(hcc_u8 ep, ep_state_t *ep_state)
{
  /* Store character into current buffer. */
  /* Handle USB. See if we need to send something. */
  if (ep_state->ep_length != 0)
  {
    /* Host properly connected us, and the TX endpoint is not busy */
    if (usb_get_state() == USBST_CONFIGURED)
    {
      if (!usb_ep_is_busy(ep))
      {
        /* Check the status of the next transfer. */
        switch (usb_ep_error(ep))
        {
	        case USBEPERR_NONE: /* Finished with no error. */
	          /* Start sending next chunk. */
	          usb_send(ep, (void *) 0, (void *) ep_state->ep_buffer, ep_state->ep_length, ep_state->ep_length);
	          return 1;
	          break;
	        case USBEPERR_PROTOCOL_ERROR:
	        case USBEPERR_HOST_ABORT:
	          /* It is possible to resend the previous buffer here. */
	          break;
	        case USBEPERR_USER_ABORT:
	        case USBEPERR_TO_MANY_DATA:
	        default:
	          /* Upps! unexpected error. Stop here. */
	          while(1)
	          ;
        }
      }
      return 0;
    }
  }
  return 0;
}
/****************************** END OF FILE **********************************/