Imports System.Runtime.InteropServices
Imports System.Text

Public Class GUI

    ' ep0 Interrupt IN
    Dim usb_ep0 As WINUSB_PIPE_INFORMATION
    ' ep1 BULK OUT
    Dim usb_ep1 As WINUSB_PIPE_INFORMATION

    'global variable
    Dim open_device As Integer

    Private Sub Enable_rtc_button_MouseClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Enable_rtc_button.MouseClick
        If rtc_enable() = False Then
            MsgBox("USB error")
        End If
    End Sub

    Private Sub GUI_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        If usb_init() = False Then

            MsgBox("USB error during init - connect usb device")

            Me.Close()

            Return

        End If
        If usb_endpoint_init() = False Then

            MsgBox("USB descriptor error")

            Me.Close()

            Return
        End If

        open_device = 1

    End Sub

    Private Sub GUI_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        If open_device = 1 Then
            usb_close()
        End If
    End Sub

    Private Sub uart_textbox_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles uart_textbox.TextChanged
        number_of_charecters.Text = uart_textbox.TextLength
    End Sub

    Private Sub send_button_MouseClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles send_button.MouseClick

        Dim UE As New UTF8Encoding()
        Dim by As Byte() = UE.GetBytes(uart_textbox.Text)

        If uart_bulk_transfer(by, uart_textbox.TextLength) = False Then
            MsgBox("Bulk error")
        End If

    End Sub

    Private Sub set_time_button_MouseClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles set_time_button.MouseClick
        Dim days As Integer
        Dim hours As Integer
        Dim minutes As Integer
        Dim seconds As Integer

        Dim by(0 To 4) As Byte

        'check if all of these are numbers
        If IsNumeric(days_text.Text) = False Then
            MsgBox("Days must be an integer")
            Return
        ElseIf IsNumeric(hours_text.Text) = False Then
            MsgBox("Hours must be an integer")
            Return
        ElseIf IsNumeric(minutes_text.Text) = False Then
            MsgBox("Minutes must be an integer")
            Return
        ElseIf IsNumeric(seconds_text.Text) = False Then
            MsgBox("Seconds must be an integer")
            Return
        End If

        'getting values from textboxes
        days = Val(days_text.Text)
        hours = Val(hours_text.Text)
        minutes = Val(minutes_text.Text)
        seconds = Val(seconds_text.Text)

        If days > 65535 Then
            MsgBox("Days cannot be greater than 65535")
            Return
        ElseIf hours > 23 Then
            MsgBox("Hours cannot be greater than 23")
            Return
        ElseIf minutes > 59 Then
            MsgBox("Minutes cannot be greater than 59")
            Return
        ElseIf seconds > 59 Then
            MsgBox("Seconds cannot be greater than 59")
            Return
        Else
            'getting RTC and sending through an array
            by(0) = (days And &HFF00) >> 8
            by(1) = (days And &HFF)
            by(2) = hours
            by(3) = minutes
            by(4) = seconds

            If rtc_set_clock(by) = False Then
                MsgBox("RTC set clock error")
            End If
        End If
    End Sub

    Private Sub get_time_button_MouseClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles get_time_button.MouseClick

        Dim by(0 To 4) As Byte

        If rtc_get_clock(by) = False Then
            MsgBox("RTC get clock error")
            Return
        End If

        days_text.Text = ((by(0) << 8) Or (by(1))).ToString
        hours_text.Text = by(2).ToString
        minutes_text.Text = by(3).ToString
        seconds_text.Text = by(4).ToString

    End Sub

    Private Sub interrupt_timer_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles interrupt_timer.Tick
        Dim Buffer(0 To 5) As Byte

        Dim x_axis As UInteger
        Dim y_axis As UInteger
        Dim z_axis As UInteger

        If usb_read_interrupt(Buffer) = False Then
            'something failed
            Return
        End If

        'building information
        x_axis = ((Buffer(0) << 8) + (Buffer(1)))
        y_axis = ((Buffer(2) << 8) + (Buffer(3)))
        z_axis = ((Buffer(4) << 8) + (Buffer(5)))

        'updating accelerometer
        x_bar.Value = x_axis
        y_bar.Value = y_axis
        z_bar.Value = z_axis
    End Sub

    Private Sub usb_device_interrupt_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles usb_device_interrupt.Tick
        If usb_still_connected() = False Then
            open_device = 0
            Me.Close()
        End If
    End Sub

    Private Sub about_button_MouseClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles about_button.MouseClick
        About.Show()
    End Sub

    '''''''''''''''''''''GENERAL FUNCTIONS'''''''''''''''''''''''''''''''''

    Public Function usb_init() As Boolean

        Dim a As Boolean

        'creating GUID for this device
        Dim my_guide As GUID_APP

        'guid for mcf52210 test board
        '----
        my_guide.DataA = &HC3AFBF6C
        my_guide.DataB = &H7C33
        my_guide.DataC = &H11DC
        my_guide.Data0 = &H97
        my_guide.Data1 = &H33
        my_guide.Data2 = &H2C
        my_guide.Data3 = &HD7
        my_guide.Data4 = &H55
        my_guide.Data5 = &HD8
        my_guide.Data6 = &H95
        my_guide.Data7 = &H93

        'starting USB module
        a = usb_open_device(my_guide)

        Return a

    End Function

    Public Function usb_still_connected() As Boolean

        Dim length As Long
        length = 1
        Dim device_desc(4) As Byte

        Dim a As Boolean

        a = usb_QueryDeviceInformation(1, length, device_desc)

        Return a

    End Function

    Public Function usb_endpoint_init() As Boolean

        Dim a As Boolean

        'getting endpoint information
        'not considering control endpoint
        'starting from zero and so on
        a = usb_QueryPipe(0, 0, usb_ep0)

        a = usb_QueryPipe(0, 1, usb_ep1)

        'endpoint timeout policy for IN and OUT endpoint
        'if an endpoint takes more than 5 ms, abort pipe
        Dim time As UInteger
        time = 5

        a = usb_SetPipePolicy(usb_ep0.PipeId, _
            PIPE_TRANSFER_TIMEOUT, 4, time)

        'setting endpoint timer and enabling it for interrupt ep

        interrupt_timer.Interval = 2 ^ (usb_ep0.Interval - 1)
        interrupt_timer.Enabled = True

        a = usb_SetPipePolicy(usb_ep1.PipeId, _
            PIPE_TRANSFER_TIMEOUT, 4, time)

        Return a

    End Function


    Public Function usb_read_interrupt(<[In](), Out()> ByVal Buffer() As Byte) As Boolean

        Dim how_data_transferred As Integer
        Dim a As Boolean

        a = usb_ReadPipe(usb_ep0.PipeId, Buffer, 6, _
            how_data_transferred)

        If how_data_transferred <> 6 Then
            a = False
        End If

        Return a

    End Function


    Public Function usb_write_bulk(<[In](), Out()> ByVal Buffer() As Byte, _
        ByVal BufferLength As Integer) As Boolean

        Dim how_data_transferred As Integer
        Dim a As Boolean

        a = usb_WritePipe(usb_ep1.PipeId, Buffer, BufferLength, _
            how_data_transferred)

        If BufferLength <> how_data_transferred Then
            a = False
        End If

        Return a
    End Function


    Public Function uart_bulk_transfer(<[In](), Out()> ByVal Buffer() As Byte, _
        ByVal BufferLength As Integer) As Boolean

        Dim control As WINUSB_SETUP_PACKET
        Dim how_data_transferred As Integer
        Dim device_desc(1) As Byte
        Dim a As Boolean

        control.RequestType = &H40   'RequestType (0x40 OUT, 0xC0 IN)
        control.Request = &H76    'Request - customized packet code
        control.Index = 0         'Index
        control.Length = 0        'Length - 1 byte
        control.Value = BufferLength 'Value

        'telling to host that we're going to send a bulk transfer
        a = usb_ControlTransfer(control, _
                                device_desc, _
                                0, _
                                how_data_transferred)


        'sending information
        a = usb_write_bulk(Buffer, BufferLength)

        Return a

    End Function

    Public Function rtc_set_clock(<[In](), Out()> ByVal Buffer() As Byte) As Boolean

        Dim control As WINUSB_SETUP_PACKET
        Dim how_data_transferred As Integer
        Dim a As Boolean

        control.RequestType = &H40   'RequestType (0x40 OUT, 0xC0 IN)
        control.Request = &H49    'Request - customized packet code
        control.Index = 0         'Index
        control.Length = 0        'Length - 1 byte
        control.Value = 5         'Value

        'telling to host that we're going to send a bulk transfer
        a = usb_ControlTransfer(control, _
                                Buffer, _
                                5, _
                                how_data_transferred)

        If how_data_transferred <> 5 Then
            a = False
        End If

        Return a
    End Function

    Public Function rtc_enable() As Boolean

        Dim control As WINUSB_SETUP_PACKET
        Dim how_data_transferred As Integer
        Dim device_desc(1) As Byte
        Dim a As Boolean

        control.RequestType = &H40   'RequestType (0x40 OUT, 0xC0 IN)
        control.Request = &H35    'Request - customized packet code
        control.Index = 0         'Index
        control.Length = 0        'Length - 1 byte
        control.Value = 1 'Value

        'telling to host that we're going to send a bulk transfer
        a = usb_ControlTransfer(control, _
                                device_desc, _
                                1, _
                                how_data_transferred)

        Return a

    End Function

    Public Function rtc_get_clock(<[In](), Out()> ByVal Buffer() As Byte) As Boolean

        Dim control As WINUSB_SETUP_PACKET
        Dim how_data_transferred As Integer
        Dim a As Boolean

        control.RequestType = &HC0   'RequestType (0x40 OUT, 0xC0 IN)
        control.Request = &H56    'Request - customized packet code
        control.Index = 0         'Index
        control.Length = 5        'Length - 1 byte
        control.Value = 0         'Value

        'telling to host that we're going to send a bulk transfer
        a = usb_ControlTransfer(control, _
                                Buffer, _
                                5, _
                                how_data_transferred)

        If how_data_transferred <> 5 Then
            a = False
        End If

        Return a

    End Function

    Public Function usb_close() As Boolean

        Dim a As Boolean

        'deleting winusb handler
        a = usb_Free()

        Return a

    End Function
End Class
