/**************************************************************************
 * FILE NAME: $RCSfile: fs_gpio.c,v $        COPYRIGHT (c) Freescale 2006 *
 * DESCRIPTION:                                     All Rights Reserved   *
 * This file contains the GPIO API for the MPC5500 family.                *
 *========================================================================*
 * ORIGINAL AUTHOR: Jeff Loeliger (r12110)                                *
 * $Log: fs_gpio.c,v $*
 *
 *........................................................................*
 *
 * File Name: fs_gpio.h
 *
 * Description:  This file contains the GPIO API for the MPC5500 family.
 *               This API works with all devices in the MPC5500 family.
 *
 * Compilers: Metrowerks CodeWarrior for MPC5500 V1.5
 *			       GreenHills
 *			       WindRiver Diab 5.1.1
 *
 * Original author: Jeff Loeliger  (jeff.loeliger@motorola.com)
 * REV      AUTHOR      DATE        DESCRIPTION OF CHANGE
 * ---   -----------  ----------    ---------------------
 * 0.1   J. Loeliger  16/Sep/03     Initial version.
 * 0.2   M. Kaspar    24/Nov/03     Updated naming convention
 * 0.3   M. Kaspar    18/Dec/03     Updated after the first review
 * 0.4   M. Kaspar    26/Jul/04     Updated for RM1.1 and Freescale
 *
 ****************************************************************************/
 
#include "typedefs.h"
#include "siu_struct.h"
/*
#if !defined(_MPC5554_H_)
#error mpc5554.h must be included before fs_gpio.h
#endif
*/
#include "fs_gpio.h"



/****************************************************************************/
uint8_t fs_gpio_read_data( uint16_t port )
{

	return( GPIO_SIU.GPDI[port].R );
}

/****************************************************************************/
void fs_gpio_write_data( uint16_t port, uint8_t value )
{

	GPIO_SIU.GPDO[port].R = value;
}

/****************************************************************************/
uint8_t fs_gpio_read_byte( uint16_t port_msb )
{

	return(uint8_t)(((GPIO_SIU.GPDI[port_msb].R<<7)+(GPIO_SIU.GPDI[port_msb+1].R<<6)+(GPIO_SIU.GPDI[port_msb+2].R<<5)+(GPIO_SIU.GPDI[port_msb+3].R<<4) +\
		(GPIO_SIU.GPDI[port_msb+4].R<<3)+(GPIO_SIU.GPDI[port_msb+5].R<<2)+(GPIO_SIU.GPDI[port_msb+6].R<<1)+(GPIO_SIU.GPDI[port_msb+7].R) ));
}

/****************************************************************************/
void fs_gpio_write_byte( uint16_t port_msb, uint8_t value )
{

	GPIO_SIU.GPDO[port_msb].R = (uint8_t)(value >> 7);
	GPIO_SIU.GPDO[port_msb+1].R = (uint8_t)(value >> 6);
	GPIO_SIU.GPDO[port_msb+2].R = (uint8_t)(value >> 5);
	GPIO_SIU.GPDO[port_msb+3].R = (uint8_t)(value >> 4);
	GPIO_SIU.GPDO[port_msb+4].R = (uint8_t)(value >> 3);
	GPIO_SIU.GPDO[port_msb+5].R = (uint8_t)(value >> 2);
	GPIO_SIU.GPDO[port_msb+6].R = (uint8_t)(value >> 1);
	GPIO_SIU.GPDO[port_msb+7].R = (uint8_t)(value);

}

/****************************************************************************/
void fs_gpio_config_input(uint16_t port, uint16_t hysteresis, uint16_t weak_pull )
{

	GPIO_SIU.PCR[port].R = (vuint16_t)(FS_GPIO_IO_FUNCTION + FS_GPIO_INPUT_BUFFER_ENABLE +\
		              hysteresis + weak_pull);
}

/****************************************************************************/
void fs_gpio_config_output( uint16_t port, uint16_t drive_strength, \
                         uint16_t slew_rate, uint16_t open_drain,\
                         uint16_t readback )
{

	GPIO_SIU.PCR[port].R = (vuint16_t)(FS_GPIO_IO_FUNCTION + FS_GPIO_OUTPUT_BUFFER_ENABLE +\
		              drive_strength + slew_rate + open_drain + readback);
}

/****************************************************************************/
void fs_gpio_config( uint16_t port, uint16_t config )
{

	GPIO_SIU.PCR[port].R = config;
}

/****************************************************************************/
void fs_gpio_config_array( uint16_t size, fs_gpio_config_array_ts *config_array )
{

	int i;   /* local loop counter */

	for ( i=0; i < size; i++)

		GPIO_SIU.PCR[config_array[i].port].R = config_array[i].config;
}

/*********************************************************************
 *
 * Copyright:
 *	Freescale Semiconductor, Inc. All Rights Reserved.
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Freescale Semiconductor, Inc. This
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, FREESCALE SEMICONDUCTOR
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY
 *  ACCOMPANYING WRITTEN MATERIALS.
 *
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL FREESCALE SEMICONDUCTOR BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.
 *
 *  Freescale Semiconductor assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/
