#ifdef DEBUG
/**************************************************************************
 * FILE NAME: $RCSfile: siu_struct.h,v $     COPYRIGHT (c) Freescale 2006 *
 * DESCRIPTION:                                     All Rights Reserved   *
 * This file defines the registers and bit fields for the SIU.            *
 *========================================================================*
 * ORIGINAL AUTHOR: Jeff Loeliger (r12110)                                *
 * $Log: siu_struct.h,v $
 *
 *........................................................................*
 * 0.1   J. Loeliger  17/Feb/03    Initial version of file.               *
 * 0.2   J. Loeliger  07/May/03    Changed to ISO standard data types,    *
 *                                  updated for latest BG and fixed errors*
 * 0.3   J. Loeliger  14/May/03    Fixed problem with RSR.                *
 * 0.4   J. Loeliger  05/Jun/03    updated CCR register.                  *
 * 0.5   J. Loeliger  22/Jul/03    Updated CCR register again & added CMP *
 *                                  registers at end of map.              *
 * 0.6   J. Loeliger  03/Nov/03    Updated compare and ISEL reg. names.   *
 **************************************************************************/
#endif

/****************************************************************************/
/*                     MODULE : SIU                                         */
/****************************************************************************/
struct SIU_struct {
    int32_t SIU_reserved0;

    union {					/* MCU ID Register */
        vuint32_t R;
        struct {
            vuint32_t PARTNUM:16;
            vuint32_t MASKNUM:16;
        } B;
    } MIDR;

    int32_t SIU_reserved00;

    union {					/* Reset Status Register */
        vuint32_t R;
        struct {
            vuint32_t PORS:1;
            vuint32_t ERS:1;
            vuint32_t LLRS:1;
            vuint32_t LCRS:1;
            vuint32_t WDRS:1;
            vuint32_t CRS:1;
            vuint32_t :8;
            vuint32_t SSRS:1;
            vuint32_t SERF:1;
            vuint32_t WKPCFG:1;
            vuint32_t :12;
            vuint32_t BOOTCFG:2;
            vuint32_t RGF:1;
        } B;
    } RSR;

    union {					/* System Reset Control Register */
        vuint32_t R;
        struct {
            vuint32_t SSR:1;
            vuint32_t SER:1;
            vuint32_t :14;
            vuint32_t CRE:1;
            vuint32_t :15;
        } B;
    } SRCR;

    union {					/* External Interrupt Status Register */
        vuint32_t R;
        struct {
            vuint32_t :16;
            vuint32_t EIF15:1;
            vuint32_t EIF14:1;
            vuint32_t EIF13:1;
            vuint32_t EIF12:1;
            vuint32_t EIF11:1;
            vuint32_t EIF10:1;
            vuint32_t EIF9:1;
            vuint32_t EIF8:1;
            vuint32_t EIF7:1;
            vuint32_t EIF6:1;
            vuint32_t EIF5:1;
            vuint32_t EIF4:1;
            vuint32_t EIF3:1;
            vuint32_t EIF2:1;
            vuint32_t EIF1:1;
            vuint32_t EIF0:1;
        } B;
    } EISR;

    union {					/* DMA/Interrupt Request Enable Register */
        vuint32_t R;
        struct {
            vuint32_t :16;
            vuint32_t EIRE15:1;
            vuint32_t EIRE14:1;
            vuint32_t EIRE13:1;
            vuint32_t EIRE12:1;
            vuint32_t EIRE11:1;
            vuint32_t EIRE10:1;
            vuint32_t EIRE9:1;
            vuint32_t EIRE8:1;
            vuint32_t EIRE7:1;
            vuint32_t EIRE6:1;
            vuint32_t EIRE5:1;
            vuint32_t EIRE4:1;
            vuint32_t EIRE3:1;
            vuint32_t EIRE2:1;
            vuint32_t EIRE1:1;
            vuint32_t EIRE0:1;
        } B;
    } DIRER;

    union {					/* DMA/Interrupt Select Register */
        vuint32_t R;
        struct {
            vuint32_t :28;
            vuint32_t DIRS3:1;
            vuint32_t DIRS2:1;
            vuint32_t DIRS1:1;
            vuint32_t DIRS0:1;
        } B;
    } DIRSR;

    union {					/* Overrun Status Register */
        vuint32_t R;
        struct {
            vuint32_t :16;
            vuint32_t OVF15:1;
            vuint32_t OVF14:1;
            vuint32_t OVF13:1;
            vuint32_t OVF12:1;
            vuint32_t OVF11:1;
            vuint32_t OVF10:1;
            vuint32_t OVF9:1;
            vuint32_t OVF8:1;
            vuint32_t OVF7:1;
            vuint32_t OVF6:1;
            vuint32_t OVF5:1;
            vuint32_t OVF4:1;
            vuint32_t OVF3:1;
            vuint32_t OVF2:1;
            vuint32_t OVF1:1;
            vuint32_t OVF0:1;
        } B;
    } OSR;

    union {					/* Overrun Request Enable Register */
        vuint32_t R;
        struct {
            vuint32_t :16;
            vuint32_t ORE15:1;
            vuint32_t ORE14:1;
            vuint32_t ORE13:1;
            vuint32_t ORE12:1;
            vuint32_t ORE11:1;
            vuint32_t ORE10:1;
            vuint32_t ORE9:1;
            vuint32_t ORE8:1;
            vuint32_t ORE7:1;
            vuint32_t ORE6:1;
            vuint32_t ORE5:1;
            vuint32_t ORE4:1;
            vuint32_t ORE3:1;
            vuint32_t ORE2:1;
            vuint32_t ORE1:1;
            vuint32_t ORE0:1;
        } B;
    } ORER;

    union {					/* External IRQ Rising-Edge Event Enable Register */
        vuint32_t R;
        struct {
            vuint32_t :16;
            vuint32_t IREE15:1;
            vuint32_t IREE14:1;
            vuint32_t IREE13:1;
            vuint32_t IREE12:1;
            vuint32_t IREE11:1;
            vuint32_t IREE10:1;
            vuint32_t IREE9:1;
            vuint32_t IREE8:1;
            vuint32_t IREE7:1;
            vuint32_t IREE6:1;
            vuint32_t IREE5:1;
            vuint32_t IREE4:1;
            vuint32_t IREE3:1;
            vuint32_t IREE2:1;
            vuint32_t IREE1:1;
            vuint32_t IREE0:1;
        } B;
    } IREER;

    union {					/* External IRQ Falling-Edge Event Enable Register */
        vuint32_t R;
        struct {
            vuint32_t :16;
            vuint32_t IFEE15:1;
            vuint32_t IFEE14:1;
            vuint32_t IFEE13:1;
            vuint32_t IFEE12:1;
            vuint32_t IFEE11:1;
            vuint32_t IFEE10:1;
            vuint32_t IFEE9:1;
            vuint32_t IFEE8:1;
            vuint32_t IFEE7:1;
            vuint32_t IFEE6:1;
            vuint32_t IFEE5:1;
            vuint32_t IFEE4:1;
            vuint32_t IFEE3:1;
            vuint32_t IFEE2:1;
            vuint32_t IFEE1:1;
            vuint32_t IFEE0:1;
        } B;
    } IFEER;

    union {					/* External IRQ Digital Filter Register */
        vuint32_t R;
        struct {
            vuint32_t :28;
            vuint32_t DFL:4;
        } B;
    } IDFR;

    int32_t SIU_reserved1[3];


    union {					/* Pad Configuration Registers */
        vuint16_t R;
        struct {
            vuint16_t :3;
            vuint16_t PA:3;
            vuint16_t OBE:1;
            vuint16_t IBE:1;
            vuint16_t DSC:2;
            vuint16_t ODE:1;
            vuint16_t HYS:1;
            vuint16_t SRC:2;
            vuint16_t WPE:1;
            vuint16_t WPS:1;
        } B;
    } PCR[231];

    int16_t SIU_reserved_5554_0[1];
    int32_t SIU_reserved_5554_1[252];

    union {					/* GPIO Pin Data Output Registers */
        vuint8_t R;
        struct {
            vuint8_t :7;
            vuint8_t PDO:1;
        } B;
    } GPDO[214];

    int8_t  SIU_reserved_5554_2[2];
    int32_t SIU_reserved_5554_3[74];

    union {					/* GPIO Pin Data Input Registers */
        vuint8_t R;
        struct {
            vuint8_t :7;
            vuint8_t PDI:1;
        } B;
    } GPDI[214];

    int8_t  SIU_reserved_5554_3a[2];
    int32_t SIU_reserved5554_4[10];


    union {					/* IMUX Register */
        vuint32_t R;
        struct {
            vuint32_t TSEL5:2;
            vuint32_t TSEL4:2;
            vuint32_t TSEL3:2;
            vuint32_t TSEL2:2;
            vuint32_t TSEL1:2;
            vuint32_t TSEL0:2;
            vuint32_t :20;
        } B;
    } ETISR;

    union {					/* IMUX Register */
        vuint32_t R;
        struct {
            vuint32_t ESEL15:2;
            vuint32_t ESEL14:2;
            vuint32_t ESEL13:2;
            vuint32_t ESEL12:2;
            vuint32_t ESEL11:2;
            vuint32_t ESEL10:2;
            vuint32_t ESEL9:2;
            vuint32_t ESEL8:2;
            vuint32_t ESEL7:2;
            vuint32_t ESEL6:2;
            vuint32_t ESEL5:2;
            vuint32_t ESEL4:2;
            vuint32_t ESEL3:2;
            vuint32_t ESEL2:2;
            vuint32_t ESEL1:2;
            vuint32_t ESEL0:2;
        } B;
    } EIISR;

    union {					/* IMUX Register */
        vuint32_t R;
        struct {
            vuint32_t SINSELA:2;
            vuint32_t SSSELA:2;
            vuint32_t SCKSELA:2;
            vuint32_t TRIGSELA:2;
            vuint32_t SINSELB:2;
            vuint32_t SSSELB:2;
            vuint32_t SCKSELB:2;
            vuint32_t TRIGSELB:2;
            vuint32_t SINSELC:2;
            vuint32_t SSSELC:2;
            vuint32_t SCKSELC:2;
            vuint32_t TRIGSELC:2;
            vuint32_t SINSELD:2;
            vuint32_t SSSELD:2;
            vuint32_t SCKSELD:2;
            vuint32_t TRIGSELD:2;
        } B;
    } DISR;

    int32_t SIU_reserved2[29];

    union {					/* Chip Configuration Register Register */
        vuint32_t R;
        struct {
            vuint32_t :14;
            vuint32_t MATCH:1;
            vuint32_t DISNEX:1;
            vuint32_t :16;
        } B;
    } CCR;

    union {					/* External Clock Configuration Register Register */
        vuint32_t R;
        struct {
            vuint32_t :18;
            vuint32_t ENGDIV:6;
            vuint32_t :4;
            vuint32_t EBTS:1;
            vuint32_t :1;
            vuint32_t EBDF:2;
        } B;
    } ECCR;

    union {
        vuint32_t R;
  } CARH;

    union {
        vuint32_t R;
    } CARL;

    union {
        vuint32_t R;
    } CBRH;

    union {
        vuint32_t R;
    } CBRL;


};

#define GPIO_SIU       (*( struct SIU_struct *)       0xC3F90000)

/*********************************************************************
 *
 * Copyright:
 *	Freescale Semiconductor, INC. All Rights Reserved.
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Freescale
 *  Semiconductor, Inc. This software is provided on an "AS IS"
 *  basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, Freescale
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH
 *  REGARD TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF)
 *  AND ANY ACCOMPANYING WRITTEN MATERIALS.
 *
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.
 *
 *  Freescale Semiconductor assumes no responsibility for the
 *  maintenance and support of this software
 *
 ********************************************************************/
