/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2006 Freescale Semiconductor, Inc.
* (c) Copyright 2001-2004 Motorola, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file   freemaster_MPC55xx.h
*
* @brief  FreeMASTER Driver hardware dependent stuff
*
* @version 1.0.4.0
* 
* @date Feb-23-2006
* 
*******************************************************************************/

#ifndef __FREEMASTER_MPC55xx_H
#define __FREEMASTER_MPC55xx_H

/******************************************************************************
* platform-specific default configuration
******************************************************************************/

/* use 32-bit (EX) commands by default */
#ifndef FMSTR_USE_EX_CMDS
#define FMSTR_USE_EX_CMDS 1
#endif

/* do not use 16-bit (no-EX) commands by default */
#ifndef FMSTR_USE_NOEX_CMDS
#define FMSTR_USE_NOEX_CMDS 0
#endif

/* at least one of EX or no-EX command handling must be enabled */
#if !FMSTR_USE_EX_CMDS && !FMSTR_USE_NOEX_CMDS
    #error At least one of EX or no-EX command handling must be enabled (please set FMSTR_USE_EX_CMDS)
    #undef  FMSTR_USE_EX_CMDS
    #define FMSTR_USE_EX_CMDS 1
#endif

/*****************************************************************************
* Board configuration information 
******************************************************************************/

#define FMSTR_PROT_VER           3      /* protocol version 3 */
#define FMSTR_CFG_FLAGS  FMSTR_CFGFLAG_BIGENDIAN /* board info flags */
#define FMSTR_CFG_BUS_WIDTH      1      /* data bus width */
#define FMSTR_GLOB_VERSION_MAJOR 2      /* driver version */
#define FMSTR_GLOB_VERSION_MINOR 0
#define FMSTR_IDT_STRING "MPC55xx FreeMASTER Drv."
#define FMSTR_TSA_FLAGS          0

/******************************************************************************
* platform-specific types
******************************************************************************/

typedef unsigned char  FMSTR_U8;       /* smallest memory entity */
typedef unsigned short FMSTR_U16;      /* 16bit value */
typedef unsigned long  FMSTR_U32;      /* 32bit value */

typedef signed char    FMSTR_S8;       /* signed 8bit value */
typedef signed short   FMSTR_S16;      /* signed 16bit value */
typedef signed long    FMSTR_S32;      /* signed 32bit value */

typedef unsigned char  FMSTR_FLAGS;    /* type to be union-ed with flags (at least 8 bits) */
typedef unsigned char  FMSTR_SIZE8;    /* one-byte size value */
typedef signed short   FMSTR_INDEX;    /* general for-loop index (must be signed) */

typedef unsigned char  FMSTR_BCHR;     /* type of a single character in comm.buffer */
typedef unsigned char* FMSTR_BPTR;     /* pointer within a communication buffer */

typedef unsigned long  FMSTR_SCISR;    /* data type to store SCI status register */

/******************************************************************************
* communication buffer access functions 
******************************************************************************/

void FMSTR_CopyMemory(FMSTR_ADDR nDestAddr, FMSTR_ADDR nSrcAddr, FMSTR_SIZE8 nSize);
FMSTR_BPTR FMSTR_CopyToBuffer(FMSTR_BPTR pDestBuff, FMSTR_ADDR nSrcAddr, FMSTR_SIZE8 nSize);
FMSTR_BPTR FMSTR_CopyFromBuffer(FMSTR_ADDR nDestAddr, FMSTR_BPTR pSrcBuff, FMSTR_SIZE8 nSize);
void FMSTR_CopyFromBufferWithMask(FMSTR_ADDR nDestAddr, FMSTR_BPTR pSrcBuff, FMSTR_SIZE8 nSize);

/* mixed EX and non-EX commands may occur */
#if FMSTR_USE_EX_CMDS && FMSTR_USE_NOEX_CMDS
void FMSTR_SetExAddr(FMSTR_BOOL bNextAddrIsEx);
#else
/* otherwise, we always know what addresses are used, (ignore FMSTR_SetExAddr) */
#define FMSTR_SetExAddr(bNextAddrIsEx) 
#endif

/*********************************************************************************
* communication buffer access functions. Most of them are trivial simple on HC12
*********************************************************************************/

#define FMSTR_ValueFromBuffer8(pDest, pSrc) \
    ( (*((FMSTR_U8*)(pDest)) = *(FMSTR_U8*)(pSrc)), (((FMSTR_BPTR)(pSrc))+1) )

#define FMSTR_ValueFromBuffer16(pDest, pSrc) \
    ( (*((FMSTR_U16*)(pDest)) = *(FMSTR_U16*)(pSrc)), (((FMSTR_BPTR)(pSrc))+2) )

#define FMSTR_ValueFromBuffer32(pDest, pSrc) \
    ( (*((FMSTR_U32*)(pDest)) = *(FMSTR_U32*)(pSrc)), (((FMSTR_BPTR)(pSrc))+4) )


#define FMSTR_ValueToBuffer8(pDest, src) \
    ( (*((FMSTR_U8*)(pDest)) = (FMSTR_U8)(src)), (((FMSTR_BPTR)(pDest))+1) )

#define FMSTR_ValueToBuffer16(pDest, src) \
    ( (*((FMSTR_U16*)(pDest)) = (FMSTR_U16)(src)), (((FMSTR_BPTR)(pDest))+2) )

#define FMSTR_ValueToBuffer32(pDest, src) \
    ( (*((FMSTR_U32*)(pDest)) = (FMSTR_U32)(src)), (((FMSTR_BPTR)(pDest))+4) )


#define FMSTR_SkipInBuffer(pDest, nSize) \
    ( ((FMSTR_BPTR)(pDest)) + (nSize) )


#define FMSTR_ConstToBuffer8  FMSTR_ValueToBuffer8
#define FMSTR_ConstToBuffer16 FMSTR_ValueToBuffer16

/* EX address used only: fetching 32bit word */
#if FMSTR_USE_EX_CMDS && !FMSTR_USE_NOEX_CMDS
    #define FMSTR_AddressFromBuffer(pDest, pSrc) \
        FMSTR_ValueFromBuffer32(pDest, pSrc)
    #define FMSTR_AddressToBuffer(pDest, nAddr) \
        FMSTR_ValueToBuffer32(pDest, nAddr)
        
/* no-EX address used only: fetching 16bit word  */
#elif !FMSTR_USE_EX_CMDS && FMSTR_USE_NOEX_CMDS
    #define FMSTR_AddressFromBuffer(pDest, pSrc) \
        FMSTR_ValueFromBuffer16(pDest, pSrc)
    #define FMSTR_AddressToBuffer(pDest, nAddr) \
        FMSTR_ValueToBuffer16(pDest, nAddr)
        
/* mixed addresses used, need to process it programatically */
#else
    FMSTR_BPTR FMSTR_AddressFromBuffer(FMSTR_ADDR* pAddr, FMSTR_BPTR pSrc);
    FMSTR_BPTR FMSTR_AddressToBuffer(FMSTR_BPTR pDest, FMSTR_ADDR nAddr);
#endif

#define FMSTR_GetS8(addr)  ( *(FMSTR_S8*)(addr) )
#define FMSTR_GetU8(addr)  ( *(FMSTR_U8*)(addr) )
#define FMSTR_GetS16(addr) ( *(FMSTR_S16*)(addr) )
#define FMSTR_GetU16(addr) ( *(FMSTR_U16*)(addr) )
#define FMSTR_GetS32(addr) ( *(FMSTR_S32*)(addr) )
#define FMSTR_GetU32(addr) ( *(FMSTR_U32*)(addr) )

/****************************************************************************************
* Other helper macros
*****************************************************************************************/

/* This macro assigns C pointer to FMSTR_ADDR-typed variable */
#define FMSTR_PTR2ADDR(tmpAddr,ptr) ( tmpAddr = (FMSTR_ADDR) (FMSTR_U8*) ptr )
#define FMSTR_ARR2ADDR FMSTR_PTR2ADDR

/****************************************************************************************
* Platform-specific configuration check
*****************************************************************************************/

#ifndef FMSTR_USE_SCI
#define FMSTR_USE_SCI 1
#endif

#if FMSTR_USE_SCI
    /* user must select what SCI to use */
    #ifndef FMSTR_SCI_BASE
    #error You have to define FMSTR_SCI_BASE as a base address of SCI register space
    #endif
#endif

/****************************************************************************************
* General peripheral space access macros
*****************************************************************************************/

#define FMSTR_SETBIT32(base, offset, bit)     ((*(volatile FMSTR_U32*)(((FMSTR_U8*)(base))+(offset))) |= bit)
#define FMSTR_CLRBIT32(base, offset, bit)     ((*(volatile FMSTR_U32*)(((FMSTR_U8*)(base))+(offset))) &= ~(bit))
#define FMSTR_SETREG32(base, offset, value)   ((*(volatile FMSTR_U32*)(((FMSTR_U8*)(base))+(offset))) = value)
#define FMSTR_SETGETREG32(base, offset, value, output)   ((*(volatile FMSTR_U32*)(((FMSTR_U8*)(base))+(offset))) = (output = value))
#define FMSTR_GETREG32(base, offset)          (*(volatile FMSTR_U32*)(((FMSTR_U8*)(base))+(offset)))

#define FMSTR_SETREG16(base, offset, value)   ((*(volatile FMSTR_U16*)(((FMSTR_U8*)(base))+(offset))) = value)
#define FMSTR_GETREG16(base, offset)          (*(volatile FMSTR_U16*)(((FMSTR_U8*)(base))+(offset)))

/****************************************************************************************
* SCI module constants
*****************************************************************************************/

/* SCI module registers */
#define FMSTR_SCICR1_OFFSET 0  /* 32bit register */
#define FMSTR_SCICR2_OFFSET 4  /* 16bit register */
#define FMSTR_SCIDR_OFFSET  6  /* 16bit register */
#define FMSTR_SCISR_OFFSET  8  /* 32bit register */

/* ESCI Control Register 1 bits */
#define FMSTR_SCICR1_LOOPS     0x00008000
#define FMSTR_SCICR1_RSRC      0x00002000
#define FMSTR_SCICR1_M         0x00001000
#define FMSTR_SCICR1_WAKE      0x00000800
#define FMSTR_SCICR1_ILT       0x00000400
#define FMSTR_SCICR1_PE        0x00000200
#define FMSTR_SCICR1_PT        0x00000100
#define FMSTR_SCICR1_TIE       0x00000080
#define FMSTR_SCICR1_TCIE      0x00000040
#define FMSTR_SCICR1_RIE       0x00000020
#define FMSTR_SCICR1_ILIE      0x00000010
#define FMSTR_SCICR1_TE        0x00000008
#define FMSTR_SCICR1_RE        0x00000004
#define FMSTR_SCICR1_RWU       0x00000002
#define FMSTR_SCICR1_SBK       0x00000001

/* ESCI Status registers bits */
#define FMSTR_SCISR_TDRE       0x80000000
#define FMSTR_SCISR_TC         0x40000000
#define FMSTR_SCISR_RDRF       0x20000000
#define FMSTR_SCISR_IDLE       0x10000000
#define FMSTR_SCISR_OR         0x08000000
#define FMSTR_SCISR_NF         0x04000000
#define FMSTR_SCISR_FE         0x02000000
#define FMSTR_SCISR_PF         0x01000000

/*******************************************************************************************
* SCI access macros
*****************************************************************************************/

/* transmitter enable/disable */
#define FMSTR_SCI_TE() FMSTR_SETBIT32(FMSTR_SCI_BASE, FMSTR_SCICR1_OFFSET, FMSTR_SCICR1_TE)
#define FMSTR_SCI_TD() FMSTR_CLRBIT32(FMSTR_SCI_BASE, FMSTR_SCICR1_OFFSET, FMSTR_SCICR1_TE)

/* receiver enable/disable */
#define FMSTR_SCI_RE() FMSTR_SETBIT32(FMSTR_SCI_BASE, FMSTR_SCICR1_OFFSET, FMSTR_SCICR1_RE)
#define FMSTR_SCI_RD() FMSTR_CLRBIT32(FMSTR_SCI_BASE, FMSTR_SCICR1_OFFSET, FMSTR_SCICR1_RE)

/* Transmitter-empty interrupt enable/disable */
#define FMSTR_SCI_ETXI() FMSTR_SETBIT32(FMSTR_SCI_BASE, FMSTR_SCICR1_OFFSET, FMSTR_SCICR1_TIE)
#define FMSTR_SCI_DTXI() FMSTR_CLRBIT32(FMSTR_SCI_BASE, FMSTR_SCICR1_OFFSET, FMSTR_SCICR1_TIE)

/* Receiver-full interrupt enable/disable */
#define FMSTR_SCI_ERXI() FMSTR_SETBIT32(FMSTR_SCI_BASE, FMSTR_SCICR1_OFFSET, FMSTR_SCICR1_RIE)
#define FMSTR_SCI_DRXI() FMSTR_CLRBIT32(FMSTR_SCI_BASE, FMSTR_SCICR1_OFFSET, FMSTR_SCICR1_RIE)

/* Tranmsit character */
#define FMSTR_SCI_PUTCHAR(ch) FMSTR_SETREG16(FMSTR_SCI_BASE, FMSTR_SCIDR_OFFSET, (FMSTR_U16) (ch))

/* Get received character */
#define FMSTR_SCI_GETCHAR() ((FMSTR_U8) FMSTR_GETREG16(FMSTR_SCI_BASE, FMSTR_SCIDR_OFFSET))

/* read status register */
#define FMSTR_SCI_GETSR()   FMSTR_GETREG32(FMSTR_SCI_BASE, FMSTR_SCISR_OFFSET)

/* read & clear status register  */
#define FMSTR_SCI_RDCLRSR(output) FMSTR_SETGETREG32(FMSTR_SCI_BASE, FMSTR_SCISR_OFFSET, FMSTR_GETREG32(FMSTR_SCI_BASE, FMSTR_SCISR_OFFSET),output)

#endif /* __FREEMASTER_MPC55xx_H */
