/******************************************************************************
*
* freemaster_cfg.h
*
* FreeMASTER Serial Communication Driver configuration file. This is the 
* placeholder file which further includes the main application configuration
* header file (appconfig.h) and enables the FreeMATSER driver is configured 
* in the Graphical Configuration Tool
*
* See all FreeMASTER configuration options in the "appconfig.h" file 
*
*******************************************************************************/

#ifndef __FREEMASTER_CFG_H
#define __FREEMASTER_CFG_H

//#include "c_types.h"    /* ITU types defined here */
//#include "appconfig.h"  /* FreeMASTER driver is configured by GCT */
#include "mpc563m.h"    /* SCI base address defined in this file */

/*
 * The GCT selects the communication channel using an enumeration constant,
 *  we need to convert it into USE_SCI or USE_JTAG settings 
 */



/****************************************************************************
* FMSTR Configuration
*****************************************************************************/
#define FMSTR_COMM_INTERFACE              1
#define FMSTR_LONG_INTR                   0
#define FMSTR_SHORT_INTR                  1
#define FMSTR_POLL_DRIVEN                 0

#define FMSTR_USE_READMEM                 1
#define FMSTR_USE_WRITEMEM                1
#define FMSTR_USE_WRITEMEMMASK            1

#define FMSTR_USE_READVAR                 1
#define FMSTR_USE_WRITEVAR                1
#define FMSTR_USE_WRITEVARMASK						1

#define FMSTR_USE_APPCMD                  0
#define FMSTR_MAX_APPCMD_CALLS            4
#define FMSTR_USE_SCOPE                   1

#define FMSTR_USE_RECORDER                1
#define FMSTR_REC_BUFF_SIZE               6144

#define FMSTR_USE_TSA                     1
#define FMSTR_USE_TSA_SAFETY              0
 
//#define ESCI_B    (*( struct ESCI_tag *)      0xFFFB4000)
//Geoff: Already defined

/* SCI_0 */
#if (FMSTR_COMM_INTERFACE) == 1 
    #define FMSTR_USE_SCI  1
    #if defined(ESCI_A)
    #define FMSTR_SCI_BASE (&ESCI_A)
    #else
    #error ESCI_A base address not specified in arch.h
    #endif

/* SCI_1 */
#elif (FMSTR_COMM_INTERFACE) == 2 
    #define FMSTR_USE_SCI  1
    #if defined(ESCI_B)
    #define FMSTR_SCI_BASE (&ESCI_B)
    #else
    #error ESCI_B base address not specified in arch.h
    #endif
    
#endif /* COMM_INTERFACE */

#endif /* __FREEMASTER_CFG_H */
