 /****************************************************************************
 * FILE NAME: $RCSfile: eng_pos_example.c,v $      COPYRIGHT (c) FREESCALE 2005 *
 * DESCRIPTION:                                        All Rights Reserved   *
 * This is a sample MPC5500 program to show a simple use of the eTPU ENG_POS    *
 * function.                                                                 *
 *===========================================================================*
 * ORIGINAL AUTHOR: Geoff Emerson (r47354)                                   *
 * $Log: eng_pos_example.c,v $
 * Revision 1.4  2009/02/03 14:57:34  r47354
 * Various minor changes prior to release
 *
 * Revision 1.3  2009/02/02 15:13:02  r47354
 * Remove unneeded comments
 *
 * Revision 1.2  2009/01/14 11:04:08  r47354
 * Revised for Monaco and GCT.
 *
 * Revision 1.1  2008/06/06 09:57:42  r47354
 * Initial revision
 *
 *
 *...........................................................................*
 *****************************************************************************/

/* Freescale provided include files */
#include "mpc563m.h"    /* mpc5554 register definitions */
#include "etpu_util.h"   /* useful utility routines */
#include "fs_gpio.h"     /* GPIO API for the MPC5500 family */
#include "etpu_app_eng_pos.h"   /* eTPU ENG_POS API */
#include "eng_pos_etpu_gct_example.h"     /* eTPU engine initialization - generated by eTPU GCT */

/* User written include files */
#include "eng_pos_example.h"  /* include application specific defines. */

#define ETPU_OUTPUT_PAD_CONFIG FS_GPIO_PRIMARY_FUNCTION + \
                               FS_GPIO_MAXIMUM_SLEW_RATE + \
                               FS_GPIO_OUTPUT_DRAIN_DISABLE + \
                               FS_GPIO_READBACK_ENABLE + \
                               FS_GPIO_OUTPUT_BUFFER_ENABLE

#define ETPU_INPUT_PAD_CONFIG  FS_GPIO_PRIMARY_FUNCTION + \
                               FS_GPIO_INPUT_BUFFER_ENABLE



int32_t init_error;    /*initialization error code. */

main()
{
  int32_t error_code;
  vuint16_t *upper_SCR16_cam; /* Pointers used to reference interrupt bits */
  vuint32_t *upper_SCR32_cam;
  vuint16_t *upper_SCR16_crank;
  vuint32_t *upper_SCR32_crank;

  FMPLL.SYNCR.R = 0x03000000; /*  8MHz*10=80MHz*/

  /* configure the eTPU channel pads */

  fs_gpio_config( FS_GPIO_ETPUA0, ETPU_INPUT_PAD_CONFIG);
  fs_gpio_config( FS_GPIO_ETPUA14, ETPU_INPUT_PAD_CONFIG);
  fs_gpio_config( FS_GPIO_ETPUA1, ETPU_OUTPUT_PAD_CONFIG);
  fs_gpio_config( FS_GPIO_ETPUA15, ETPU_OUTPUT_PAD_CONFIG);


  upper_SCR32_crank = &ETPU.CHAN[APP_ENG_POS0_CRANK].SCR.R;
  upper_SCR16_crank = (vuint16_t *) upper_SCR32_crank;
  *upper_SCR16_crank = 0xC0C0;        /* clear DMA/interrupt service request */
  upper_SCR32_cam = &ETPU.CHAN[APP_ENG_POS0_CAM].SCR.R;
  upper_SCR16_cam = (vuint16_t *) upper_SCR32_cam;
  *upper_SCR16_cam = 0xC0C0;        /* clear DMA/interrupt service request */


  error_code = my_system_etpu_init ();

  my_system_etpu_start();


  for (;;)
  {

  /* update calls may be added here */

  } /*Foo.*/
}