/**************************************************************************/
/*                                           COPYRIGHT (c) Freescale 2004 */
/* FILE NAME: MPC555x_H7Fa.h										      */
/*                                                                        */
/* INCLUDE FILES: None		                                              */
/* VERSION: 0.4                                                           */
/*                                                                        */
/*========================================================================*/
/*                                                                        */
/* DESCRIPTION: This file defines MACRO being used on the CopperHead	  *
/*																		  */
/*                                                                        */
/*========================================================================*/
/*                                                                        */
/* COMPILER: Diab Data        VERSION: 4.4b                               */
/*                                                                        */
/* AUTHOR:		Vincent Vu	                CREATION DATE:  06/26/03      */
/* LOCATION:	Austin, TX         		                                  */
/*                                                                        */
/*	UPDATE HISTORY                                                        */
/*	REV     AUTHOR		DATE		DESCRIPTION OF CHANGE                 */
/*	---		----------- ---------   ---------------------				  */
/*	0.1		Vincent Vu	06/26/03	Initial Release						  */
/*	0.2		Vincent Vu	09/07/03	Add Block size and base address info  */
/*	0.3		Vincent Vu	09/19/03	Add DWORD_SIZE						  */
/*	0.4		Vincent Vu	11/04/04	Change Shadow Row Base address from   */
/*									0xFFFE00 to 0xFFFC00 per MPC5554RM 1.1*/
/*									Change Shadow Row Size from 0x200 to  */
/*									0x400 per MPC5554RM V1.1			  */
/**************************************************************************/

#ifndef	__MPC5554_H7FX_H__
#define	__MPC5554_H7FX_H__

#include "m_common.h"

#define	INTERNAL_MEMORY_BASE	0

#if !DEVICE_5516
    #define FLASH_CTL_REG_BASE	0xC3F88000					// Control Registers Base Address
#else
    #define FLASH_CTL_REG_BASE	0xFFFF8000					// Control Registers Base Address - 5516
#endif

#define	FLASH_ARRAY_BASE		0x00000000					//	Flash Array Base Address.

#define ONE_MB	                0x00100000		            //  1 MB
#define TWO_MB					0x00200000					//  2 MB
#define THREE_MB	            0x00300000		       	    //  3 MB

#define BLK_16KB				0x00004000					// 16KB
#define BLK_48KB   				0x0000C000					// 48KB
#define BLK_64KB   				0x00010000					// 64KB
#define BLK_128KB 				0x00020000					// 128KB

///////////////////////////////////////////////////////////////////////////////////////////////////
//	LOW ADDRESS BASE, SIZE, BLOCK BASE, BLOCK SIZE, BLOCK MASK									 //
///////////////////////////////////////////////////////////////////////////////////////////////////
//	LAS Configuration
//				 ------------
//	block 0		|	16 BK	 |
//				 ------------
//	block 1		|	48 BK	 |
//				 ------------
//	block 2		|	48 BK	 |
//				 ------------
//	block 3		|	16 BK	 |
//				 ------------
//	block 4		|	64 BK	 |
//				 ------------
//	block 5		|	64 BK	 |
//				 ------------
#define	LAS_BASE			FLASH_ARRAY_BASE				//	Low Address Space Base Address
#define LAS_SIZE			0x00040000						//	Low Address Space Memory size 256KB
#define	LBLOCK0_BASE		LAS_BASE						//	Block0 Base Address
#define	LBLOCK0_SIZE		BLK_16KB						//	16 KB
#define	LBLOCK1_BASE		(LBLOCK0_BASE + LBLOCK0_SIZE)	//	Block1 Base Address
#if DEVICE_5516
    #define	LBLOCK1_SIZE		BLK_16KB						//	16 KB
    #define	LBLOCK2_BASE		(LBLOCK1_BASE + LBLOCK1_SIZE)	//	Block2 Base Address
    #define	LBLOCK2_SIZE		BLK_16KB						//	16 KB
    #define	LBLOCK3_BASE		(LBLOCK2_BASE + LBLOCK2_SIZE)	//	Block3 Base Address
    #define	LBLOCK3_SIZE		BLK_16KB						//	16 KB
    #define	LBLOCK4_BASE		(LBLOCK3_BASE + LBLOCK3_SIZE)	//	Block4 Base Address
    #define	LBLOCK4_SIZE		BLK_16KB						//	16 KB
    #define	LBLOCK5_BASE		(LBLOCK4_BASE + LBLOCK4_SIZE)	//	Block5 Base Address
    #define	LBLOCK5_SIZE		BLK_16KB						//	16 KB
    #define	LBLOCK6_BASE		(LBLOCK5_BASE + LBLOCK5_SIZE)	//	Block6 Base Address
    #define	LBLOCK6_SIZE		BLK_16KB						//	16 KB
    #define	LBLOCK7_BASE		(LBLOCK6_BASE + LBLOCK6_SIZE)	//	Block7 Base Address
    #define	LBLOCK7_SIZE		BLK_16KB						//	16 KB
    #define	LBLOCK8_BASE		(LBLOCK7_BASE + LBLOCK7_SIZE)	//	Block8 Base Address
    #define	LBLOCK8_SIZE		BLK_64KB						//	64 KB
    #define	LBLOCK9_BASE		(LBLOCK8_BASE + LBLOCK8_SIZE)	//	Block9 Base Address
    #define	LBLOCK9_SIZE		BLK_64KB						//	64 KB
#else
    #define	LBLOCK1_SIZE		BLK_48KB						//	48 KB
    #define	LBLOCK2_BASE		(LBLOCK1_BASE + LBLOCK1_SIZE)	//	Block2 Base Address
    #define	LBLOCK2_SIZE		BLK_48KB						//	48 KB
    #define	LBLOCK3_BASE		(LBLOCK2_BASE + LBLOCK2_SIZE)	//	Block3 Base Address
    #define	LBLOCK3_SIZE		BLK_16KB						//	16 KB
    #define	LBLOCK4_BASE		(LBLOCK3_BASE + LBLOCK3_SIZE)	//	Block4 Base Address
    #define	LBLOCK4_SIZE		BLK_64KB						//	64 KB
    #define	LBLOCK5_BASE		(LBLOCK4_BASE + LBLOCK4_SIZE)	//	Block5 Base Address
    #define	LBLOCK5_SIZE		BLK_64KB						//	64 KB
#endif
#define	LBLOCK0				0x00000001						//	blocks 0 mask
#define	LBLOCK1				0x00000002						//	blocks 1 mask
#define	LBLOCK2				0x00000004						//	blocks 2 mask
#define	LBLOCK3				0x00000008						//	blocks 3 mask
#define	LBLOCK4				0x00000010						//	blocks 4 mask
#define	LBLOCK5				0x00000020						//	blocks 5 mask
#define	LBLOCK6				0x00000040						//	Block 6 select mask - 5516 support
#define	LBLOCK7				0x00000080						//	Block 7 select mask - 5516 support
#define	LBLOCK8				0x00000100						//	Block 8 select mask - 5516 support
#define	LBLOCK9				0x00000200						//	Block 9 select mask - 5516 support
#define	LBLOCK10			0x00000400						//	Block 10 select mask - 5516 support

///////////////////////////////////////////////////////////////////////////////////////////////////
//	MID ADDRESS BASE, SIZE, BLOCK BASE, BLOCK SIZE, BLOCK MASK									 //
///////////////////////////////////////////////////////////////////////////////////////////////////
//	MAS Configuration
//				 ------------
//	block 0		|	128 BK	 |
//				 ------------
//	block 1		|	128 BK	 |
//				 ------------
#define	MAS_BASE			(LAS_BASE + LAS_SIZE)			//	Mid Address Space Base Address
#define	MAS_SIZE			0x00040000						//	Mid Address Space Memory size 256KB
#define	MBLOCK_SIZE			BLK_128KB						//	128 KB
#define	MBLOCK0_BASE		MAS_BASE						//	Block0 base address
#define	MBLOCK1_BASE		(MBLOCK0_BASE + MBLOCK_SIZE)	//	Block1 base address
#define	MBLOCK0				0x00000001						//	blocks 0 mask
#define	MBLOCK1				0x00000002						//	blocks 1 mask

///////////////////////////////////////////////////////////////////////////////////////////////////
//	HIGH ADDRESS BASE, SIZE, BLOCK BASE, BLOCK SIZE, BLOCK MASK									 //
///////////////////////////////////////////////////////////////////////////////////////////////////
//	HAS Configuration
//				 ------------
//	block 0		|	128 BK	 |
//				 ------------
//	block 1		|	128 BK	 |
//				 ------------
//	block 2		|	128 BK	 |
//				 ------------
//	block 3		|	128 BK	 |
//				 ------------
//	block 4		|	128 BK	 |
//				 ------------
//	block 5		|	128 BK	 |
//				 ------------
//	block 6		|	128 BK	 |
//				 ------------
//	block 7		|	128 BK	 |
//				 ------------
//	block 8		|	128 BK	 |
//				 ------------
//	block 9		|	128 BK	 |
//				 ------------
//	block 10	|	128 BK	 |
//				 ------------
//	block 11	|	128 BK	 |
//				 ------------
#define	HAS_BASE			(MAS_BASE + MAS_SIZE)			//	High Address Space Base Address
#define	HAS_SIZE			0x00180000						//	Mid Address Space Memory size 1.5MB
#define	HBLOCK_SIZE			BLK_128KB						//	128 KB
#define	HBLOCK0_BASE		HAS_BASE						//	Block 0 base address
#define	HBLOCK1_BASE		(HBLOCK0_BASE + HBLOCK_SIZE)	//	Block 1 base address
#define	HBLOCK2_BASE		(HBLOCK1_BASE + HBLOCK_SIZE)	//	Block 2 base address
#define	HBLOCK3_BASE		(HBLOCK2_BASE + HBLOCK_SIZE)	//	Block 3 base address
#define	HBLOCK4_BASE		(HBLOCK3_BASE + HBLOCK_SIZE)	//	Block 4 base address
#define	HBLOCK5_BASE		(HBLOCK4_BASE + HBLOCK_SIZE)	//	Block 5 base address
#define	HBLOCK6_BASE		(HBLOCK5_BASE + HBLOCK_SIZE)	//	Block 6 base address
#define	HBLOCK7_BASE		(HBLOCK6_BASE + HBLOCK_SIZE)	//	Block 7 base address
#define	HBLOCK8_BASE		(HBLOCK7_BASE + HBLOCK_SIZE)	//	Block 8 base address
#define	HBLOCK9_BASE		(HBLOCK8_BASE + HBLOCK_SIZE)	//	Block 9 base address
#define	HBLOCK10_BASE		(HBLOCK9_BASE + HBLOCK_SIZE)	//	Block 10 base address
#define	HBLOCK11_BASE		(HBLOCK10_BASE + HBLOCK_SIZE)	//	Block 11 base address
#define	HBLOCK12_BASE		(HBLOCK11_BASE + HBLOCK_SIZE)	//	Block 12 base address
#define	HBLOCK13_BASE		(HBLOCK12_BASE + HBLOCK_SIZE)	//	Block 13 base address
#define	HBLOCK14_BASE		(HBLOCK13_BASE + HBLOCK_SIZE)	//	Block 14 base address
#define	HBLOCK15_BASE		(HBLOCK14_BASE + HBLOCK_SIZE)	//	Block 15 base address
#define	HBLOCK16_BASE		(HBLOCK15_BASE + HBLOCK_SIZE)	//	Block 16 base address
#define	HBLOCK17_BASE		(HBLOCK16_BASE + HBLOCK_SIZE)	//	Block 17 base address
#define	HBLOCK18_BASE		(HBLOCK17_BASE + HBLOCK_SIZE)	//	Block 18 base address
#define	HBLOCK19_BASE		(HBLOCK18_BASE + HBLOCK_SIZE)	//	Block 19 base address
#define	HBLOCK0				0x00000001						//	Block 0 select mask
#define	HBLOCK1				0x00000002						//	Block 1 select mask
#define	HBLOCK2				0x00000004						//	Block 2 select mask
#define	HBLOCK3				0x00000008						//	Block 3 select mask
#define	HBLOCK4				0x00000010						//	Block 4 select mask
#define	HBLOCK5				0x00000020						//	Block 5 select mask
#define	HBLOCK6				0x00000040						//	Block 6 select mask
#define	HBLOCK7				0x00000080						//	Block 7 select mask
#define	HBLOCK8				0x00000100						//	Block 8 select mask
#define	HBLOCK9				0x00000200						//	Block 9 select mask
#define	HBLOCK10			0x00000400						//	Block 10 select mask
#define	HBLOCK11			0x00000800						//	Block 11 select mask
#define	HBLOCK12			0x00001000						//	Block 12 select mask
#define	HBLOCK13			0x00002000						//	Block 13 select mask
#define	HBLOCK14			0x00004000						//	Block 14 select mask
#define	HBLOCK15			0x00008000						//	Block 15 select mask
#define	HBLOCK16			0x00010000						//	Block 16 select mask
#define	HBLOCK17			0x00020000						//	Block 17 select mask
#define	HBLOCK18			0x00040000						//	Block 18 select mask
#define	HBLOCK19			0x00080000						//	Block 19 select mask

#define	NOBLOCK				0				//	No block selected.

///////////////////////////////////////////////////////////////////////////////////////////////////
//	PASSWORDS USED TO ENABLE LOW/MID AND HI ADDRESS LOCK REGISTERS								 //
///////////////////////////////////////////////////////////////////////////////////////////////////
#define	LME_PASSWORD		0xA1A11111		//	Low/Mid Address Lock Enable Password
#define	HBE_PASSWORD		0xB2B22222		//	High Address Lock Enable Password
#define	SLE_PASSWORD		0xC3C33333		//	Secondary Low Address Lock Enable Password
	
///////////////////////////////////////////////////////////////////////////////////////////////////
//	SHADOW ROW BASE ADDRESS AND SIZE															 //
///////////////////////////////////////////////////////////////////////////////////////////////////

#define SHADOW_BASE_32K             0x00FF8000		//h7fb shadow size
#define SHADOW_BASE_1K              0x00FFFC00
#define THIRTY_TWO_KB               0x00008000
#define ONE_KB                      0x00000400

#define SHADOW_CODE1                0x00FFFCC8
#define SHADOW_CODE2                0x00FFFCE8
#define SHADOW_BAM                  0x00FFFDD8              
#define SHADOW_CENSORSHIP           0x00FFFDE0

#define CODE1	0xFEEDFACE
#define CODE2	0xCAFEBEEF
#define CODE3	0x55AA55AA

#define SHADOW_BITS         SHADOW_SIZE*8           //  Total number of shadow row bits
#define SHADOW_END          SHADOW_BASE + SHADOW_SIZE

///////////////////////////////////////////////////////////////////////////////////////////////////
//	TEST ROW BASE ADDRESS AND SIZE																 //
///////////////////////////////////////////////////////////////////////////////////////////////////
#define	TESTROW_BASE		LAS_BASE		//	Test Row Base Address
#define	TESTROW_SIZE		0x00000400		//	Test Row Size. 1024 Bytes.

///////////////////////////////////////////////////////////////////////////////
//	MEMORY MODES MACRO
///////////////////////////////////////////////////////////////////////////////
#define	ARRAY				0x01				//  Main array.
#define	SHADOW				0x02				//	Shadow row.
#define	TESTROW				0x04				//	Test row.

#define H7FA				0
#define H7FB				1

#define	BLANK_DATA			0xFFFFFFFF
#define PROG_DATA			0x00000000

#define	TIMEOUT_DONE_FLAG	0xFFFFFFF
#define DONE_FLAG_TIMEOUT	180					// 180 seconds done flag timeout

///////////////////////////////////////////////////////////////////////////////////////////////////
//	PATTERN DESIGNATOR																			 //
///////////////////////////////////////////////////////////////////////////////////////////////////
#define	PAT_ALL_ZEROS			(UINT8)0x0		//	All zeros Pattern
#define	PAT_DIAG				(UINT8)0x1		//	Diagonal Pattern
#define	PAT_PCB					(UINT8)0x2		//	Physical Checkerboard Pattern
#define	PAT_LCB					(UINT8)0x3		//	Logical Checkerboard Pattern
#define	PAT_IPCB				(UINT8)0x4		//	Physical Invers Checkerboard Pattern		
#define	PAT_ILCB				(UINT8)0x5		//	Logical Inverse Checkerboard Pattern
#define	PAT_IDIAG				(UINT8)0x6		//	Reverse Diagonal Pattern
#define	PAT_ALL_ONES			(UINT8)0x7		//	All ones Pattern
#define	PAT_ADDR				(UINT8)0x8		//	Logical Address Pattern
#define	PAT_IADDR				(UINT8)0x9		//  Complement Logical Address Pattern
#define	PAT_ABF					(UINT8)0xA		//	Any Bit Fast Pattern
#define	PAT_IABF				(UINT8)0xB		//  Inverse Any Bit Fast Pattern
#define PAT_PB                  (UINT8)0xC      //  Performance Background Pattern
#define PAT_ADDR_NEW            (UINT8)0xD      //  Addr new - from CE BIST implementation
#define	PAT_PASSFAIL			(UINT8)0xFC		//	Reading Pass/Fail Code
#define	PAT_DONT_CARE			(UINT8)0xff		//	Don't care Pattern

#define	FAIL					0x01
#define	PASS					(!FAIL)
#define	TIMEOUT_ERROR			0x02
#define	INVALID_PARAMETER		0x04
#define	EER_ERROR_FLASH			0x08
#define	EDC_ERROR				0x10
#define	RWE_NOT_SET_ERROR		0x20
#define ERROR_INVALID_ADDRESS	0x40
#define	EER_ERROR_SRAM			0x80			// L2RAM double bit ECC Error
#define	SRAM_ECC_ERROR			0x80			// L2RAM double bit ECC Error
#define SRAM_EDC_ERROR			0x81			// SRAM Single bit ECC Error 
#define ERROR_WORD_ALIGNMENT	0x100
#define ERROR_DWORD_ALIGNMENT	0x200
#define RWE_NOT_CLEAR_ERROR		0x400			// 

#define	MAX_ERASE_ATTEMPT		500
#define	MAX_PROGRAM_ATTEMPT		50

//This is actually 16 for h7fb, but its taken care of when buffer size is passed into functions
//this is just used to initialize the size of the buffer in case we are working on h7fa device
#define	PAGE_SIZE_IN_BYTE		32				//	page size in bytes.  

#define	WORD_SIZE				4				//	word size in byte
#define	DWORD_SIZE				8				//	double word size in byte	v.vu	09/19/03
#define	PAGE_SIZE_IN_WORD		(PAGE_SIZE_IN_BYTE/WORD_SIZE)	//	read/program page size in word
#define	DWORD_PAGE_SIZE			(PAGE_SIZE_IN_BYTE/DWORD_SIZE)	//	read/program page size in double word.

#define	BUFFER_SIZE_IN_BYTE		PAGE_SIZE_IN_BYTE 				// one programming page

//this one was 16/4 for Coral, but leave bigger (32/4) so both can use it
#define	BUFFER_SIZE_IN_WORD		(BUFFER_SIZE_IN_BYTE/WORD_SIZE)

/* macros for bitmap and pattern generator */
/* these taken from pattern gen library provide by chen he */	  \
/*

//Now taken care of at run-time by looking at MIDR register

#if CORAL

#define H7FX_ROW0(addr)     ((addr & 0x10) >> 4)
#define H7FX_COL0(addr)     ((addr & 0x200) >> 9)
#define H7FX_COLS(addr)     ((addr & 0x3E00) >> 9)
#define H7FX_ROWS(addr)     ((addr & 0x1F0) >> 4)
#define COLS_MASK           0x1F
#define CHK_ROW4            0 
//#define H7FX_ROW4(addr)     ((addr & 0x200) >> 9)
#define H7FX_ROW4(addr)     ((addr & 0x100) >> 8)

#elif HAMMOND

#define H7FX_ROW0(addr)     ((addr & 0x10) >> 4)
#define H7FX_COL0(addr)     ((addr & 0x200) >> 9)
#define H7FX_COLS(addr)     ((addr & 0x3E00) >> 9)
#define H7FX_ROWS(addr)     ((addr & 0x1F0) >> 4)
#define COLS_MASK           0x1F
#define CHK_ROW4            0 
#define H7FX_ROW4(addr)     ((addr & 0x100) >> 8)

#else   //CUHEAD    by default

#define H7FX_ROW0(addr)     ((addr & 0x20) >> 5)
#define H7FX_COL0(addr)     ((addr & 0x400) >> 10)
#define H7FX_COLS(addr)     ((addr & 0x3C00) >> 10)
#define H7FX_ROWS(addr)     ((addr & 0x1E0) >> 5)
#define COLS_MASK           0xF
#define CHK_ROW4            1 
#define H7FX_ROW4(addr)     ((addr & 0x200) >> 9)

#endif
*/


typedef struct
{
	UINT32 status;
	UINT32 data[2];
	UINT32 operation;
	UINT32 address;
	UINT32 bitcnt;
} ERROR;

typedef struct _pulses
{
	// ======== WARNING WARNING WARNING ======== //
	// Watch the PULSE_SIZE value and you need to make sure
	// PULSE_SIZE * number of blocks is divisible by 8 to avoid ECC error
	// because ECC is calculated on double-word(8 bytes) boundary.
	#if REL_MON
		#define	PULSE_TYPE_COUNT 8
		UINT32 *ipp; 	// pre-program pulses
		UINT32 *tipp;	// total pre-program pulses
		UINT32 *ep;		// erase pulse count
		UINT32 *et;		// erase time
		UINT32 *icp;	// compaction pulses
		UINT32 *ticp;	// total compaction pulses	
		UINT32 *isp;	// interleaved pre-program pulses
		UINT32 *tisp; 	// total interleaved pre-program pulses
	#else
		#define PULSE_SIZE	6
		//UINT16 *ipp;	// changed from 16-bit to 8-bit to accommodate Viper v.vu 08-23-06
		UINT8 *ipp;
		UINT16 *ep;
		UINT16 *icp;
		//UINT16 *isp;	// changed from 16-bit to 8-bit to accommodate Viper v.vu 08-23-06
		UINT8 *isp;  
	#endif
} sPULSE;
#endif //	__MPC5554_H7FA_H__
