#include "derivative.h" /* include peripheral declarations */
#include "LCD.h"

byte bLCD_CharPosition = 0;
byte RamBuffer[RamBufferSize];


byte bpaPlace [ ] =
{
	Char1a,   // LCD4 --- Pin:5
	Char1b,   // LCD5 --- Pin:6
	Char1c,   // LCD6 --- Pin:7
	Char1d,   // LCD7 --- Pin:8
	Char2a,   // LCD8 --- Pin:9
	Char2b,   // LCD9 --- Pin:10
	Char2c,   // LCD10 --- Pin:11
	Char2d,   // LCD11 --- Pin:12
	Char3a,   // LCD29 --- Pin:44
	Char3b,   // LCD30 --- Pin:43
	Char3c,   // LCD37 --- Pin:42
	Char3d,   // LCD38 --- Pin:41
	Char4a,   // LCD39 --- Pin:40
	Char4b,   // LCD40 --- Pin:39
	Char4c,   // LCD31 --- Pin:38
	Char4d,   // LCD32 --- Pin:37
	Char5a,   // LCD17 --- Pin:36
	Char5b,   // LCD18 --- Pin:35
	Char5c,   // LCD19 --- Pin:34
	Char5d,   // LCD20 --- Pin:33
	Char6a,   // LCD21 --- Pin:32
	Char6b,   // LCD35 --- Pin:31
	Char6c,   // LCD36 --- Pin:30
	Char6d,   // LCD22 --- Pin:29
	Char7a,   // LCD12 --- Pin:13
	Char7b,   // LCD13 --- Pin:14
	Char7c,   // LCD33 --- Pin:15
	Char7d,   // LCD34 --- Pin:16
	Char8a,   // LCD41 --- Pin:17
	Char8b,   // LCD42 --- Pin:18
	Char8c,   // LCD43 --- Pin:19
	Char8d,   // LCD14 --- Pin:20
	Char9a,   // LCD15 --- Pin:21
	Char9b,   // LCD16 --- Pin:22
	Char9c,   // LCD28 --- Pin:23
	Char9d   // LCD27 --- Pin:24
};

byte baBackup [ ] =
{
   _Backupd,
   _Backupc,
   _Backupb,
   _Backupa
};

const byte baAscii [ ] =
{
	_0
	_1
	_2
	_3
	_4
	_5
	_6
	_7
	_8
	_9
	_AllOff
	_SemiColon
	_MinusThan
	_Equal
	_GreaterThan
	_Question
	_AllOn
	_A
	_B
	_C
	_D
	_E
	_F
	_G
	_H
	_I
	_J
	_K
	_L
	_M
	_N
	_O
	_P
	_Q
	_R
	_S
	_T
	_U
	_V
	_X
	_Y
	_Z        

} ;



void vfnLCD_Init  (void)
{
	SCGC2_LCD = 1;									//Enable clock to LCD module
	LCDDISABLE;
	LCDSUPPLY_INIT;								// Configure  the Voltage Supply 
	LCDC1_INIT;										// Configure  the LCD1 register
	LCDC0_INIT;										// Configure  the LCD0 register   			     
	vfnEnablePins ();									//Give to the LCDx the functionality  of a LCD pin
	vfnLCD_ConfigureBackplanes (); 			//Enable the characterisitcs of a Backplane
	LCDENABLE; 												// Enable the LCD module
}	

/*	LCDRVC_INIT;										// Configure  the Regulated Voltage Control
	LCDBCTL_INIT; 									// Configure  the Blink Control register
*/	

  						         	
  void vfnEnablePins (void)
  {
  	PEN0;											// Give to the LCDx the functionality  of a LCD pin
  	PEN1;
  	PEN2;
  	PEN3;
	PEN4;
	PEN5;
  }
  
 
  void vfnLCD_ConfigureBackplanes (void)
  {

		LCDBPEN0 = 0;
		LCDBPEN1 = 0;
		LCDBPEN2 = 0;
		LCDBPEN3 = 0;
		  
		BPEN0; 										//Enable the characterisitcs of a Backplane
		BPEN1;
		BPEN2;
		BPEN3;
		BPEN4;
		BPEN5;

		SetCom1;	 									//Give to each backplane previously enbale his COM number
		SetCom2;
		SetCom3;
		SetCom4;

  }

 void  vfnLCD_Write_Msg (byte  _POINTER lbpMessage)
 {
      byte lbCounter;          
     
     vfnLCD_Home ();						//Point to the first alphanumeric
     lbCounter = _CHARNUM;
     
     
    while (lbCounter--)						
    {
      if (*lbpMessage)						//Write  String						 
      {
         vfnLCD_Write_Char (*lbpMessage);
         lbpMessage ++;
      }
      else								//Write Blanks 
      {
      	vfnLCD_Write_Char(' ');
      }
    }
      
 }
 
 void  vfnLCD_Write_MsgPlace(byte _POINTER lbpMessage, byte n_chars, byte lbPlace) 
 {
    byte lb_Counter = 0;          
    
    vfnLCD_GoTo(lbPlace);						//Point to the alphanumeric
   
    while (n_chars--)							//Write String 
    {
       if (bLCD_CharPosition <= _CHARNUM*_LCDTYPE) 
       {
	       vfnLCD_Write_Char (*lbpMessage);
	       lbpMessage ++;     
       }
    }
 } 

void vfnLCD_Write_Char (byte lbValue)
{
          byte *lbpLCDWF = &LCDWFRef;
          byte lbOffset=0;
          byte lbCounter ;
          byte *lbpLCDWFCopy = &RamBuffer[0];

          if(lbValue >= 'a' && lbValue <= 'z') lbValue=lbValue-'a' + 'A';				//Change 	small letters to capitals
          if(lbValue < '0' || lbValue > 'Z') lbValue=':';							//Change ascii space to alloff 
          
          lbValue = (lbValue-'0')*_LCDTYPE;								//Find the value at the ascii table
          lbCounter = _LCDTYPE;										//Set the number of waveforms needed to write one alphanumeric
          
          while (lbCounter--)
          {
          
             lbOffset = bpaPlace[bLCD_CharPosition];						//Find the Waveform offset                       
             *(lbpLCDWFCopy + lbOffset)&=(~(baBackup[lbCounter] & 0xFF));		//Backup of the waveforms
             *(lbpLCDWFCopy + lbOffset) |= baAscii[lbValue];
             *(lbpLCDWF + lbOffset) = *(lbpLCDWFCopy + lbOffset);			//Write the value to the waveform
             lbValue++;  
              bLCD_CharPosition++;           
          }            
  
}


void vfnLCD_Set_Display (void)
{
	Segment1_ON;       										//Turn on all the segments
	Segment2_ON;
	Segment3_ON;
	Segment4_ON;
	Segment5_ON;
	Segment6_ON;
	Segment7_ON;
	Segment8_ON;
	Segment9_ON;
	Segment10_ON;
	Segment11_ON;       									
	Segment12_ON ;
	Segment13_ON;
	Segment14_ON;

	#ifdef MC9RS08LA8
		Segment15_ON;
		Segment16_ON;
		Segment17_ON;
		Segment18_ON;
		Segment19_ON;
		Segment20_ON;
		Segment21_ON;  
	#endif
	
	#ifdef MC9S08LL16
		Segment15_ON;
		Segment16_ON;
		Segment17_ON;
		Segment18_ON;
		Segment19_ON;
		Segment20_ON;
		Segment21_ON;  
		Segment22_ON;
		Segment23_ON;
		Segment24_ON;
	#endif

	#ifdef MC9S08LG32
		Segment15_ON;
		Segment16_ON;
		Segment17_ON;
		Segment18_ON;
		Segment19_ON;
		Segment20_ON;
		Segment21_ON;  
		Segment22_ON;
		Segment23_ON;
		Segment24_ON;
		Segment25_ON;
		Segment26_ON;  
		Segment27_ON;
		Segment28_ON;
		Segment29_ON;
		Segment30_ON;
		Segment31_ON;  
		Segment32_ON;
		Segment33_ON;
		Segment34_ON;
		Segment35_ON;
		Segment36_ON;  
		Segment37_ON;
		Segment38_ON;
		Segment39_ON;
		Segment40_ON;
	#endif
}

void vfnLCD_Clear_Display (void)
{
	Segment1_OFF;       										//Turn off all the segments
	Segment2_OFF;
	Segment3_OFF;
	Segment4_OFF;
	Segment5_OFF;
	Segment6_OFF;
	Segment7_OFF;
	Segment8_OFF;
	Segment9_OFF;
	Segment10_OFF;
	Segment11_OFF;       									
	Segment12_OFF ;
	Segment13_OFF;
	Segment14_OFF;
	
	#ifdef  MC9RS08LA8
		Segment15_OFF;
		Segment16_OFF;
		Segment17_OFF;
		Segment18_OFF;
		Segment19_OFF;
		Segment20_OFF;
		Segment21_OFF;  
	#endif  
	
	#ifdef MC9S08LL16
		Segment15_OFF;
		Segment16_OFF;
		Segment17_OFF;
		Segment18_OFF;
		Segment19_OFF;
		Segment20_OFF;
		Segment21_OFF;  
		Segment22_OFF;
		Segment23_OFF;
		Segment24_OFF;
	#endif

	#ifdef MC9S08LG32
		Segment15_OFF;
		Segment16_OFF;
		Segment17_OFF;
		Segment18_OFF;
		Segment19_OFF;
		Segment20_OFF;
		Segment21_OFF;  
		Segment22_OFF;
		Segment23_OFF;
		Segment24_OFF;
		Segment25_OFF;
		Segment26_OFF;  
		Segment27_OFF;
		Segment28_OFF;
		Segment29_OFF;
		Segment30_OFF;
		Segment31_OFF;  
		Segment32_OFF;
		Segment33_OFF;
		Segment34_OFF;
		Segment35_OFF;
		Segment36_OFF;  
		Segment37_OFF;
		Segment38_OFF;
		Segment39_OFF;
		Segment40_OFF;
	#endif

}


