/******************************************************************************
  FILE        : StartRS08.c
  PURPOSE     : RS08 standard startup code
  LANGUAGE    : ANSI-C / INLINE ASSEMBLER
  ----------------------------------------------------------------------------
  HISTORY
     oct 2006         Created.
 ******************************************************************************/

extern void main(void); /* prototype of main function */

#ifdef __ONLY_INIT_SP 


#pragma NO_ENTRY
#pragma NO_EXIT
#pragma NO_RETURN  /* we are not returning. This avoids the generation of a RTS at the end of _Startup */
#pragma NO_CALLER  /* we don't have a caller. This generates debug information to stop at this function. */

#ifdef __cplusplus
extern "C" 
#endif

void _Startup(void)  {
   __asm jmp main;
}

#else
#include <startrs08.h>

#pragma push
#pragma CONST_SEG __FAR_SEG _STARTUP
const struct _tagStartup _startupData={0}; /* contains initialization information. The content is linker generated. */
#pragma pop

#include "startrs08_init.c" /* include C file so we can use BSR */


#pragma NO_ENTRY
#pragma NO_EXIT
#pragma NO_RETURN  /* we are not returning. This avoids the generation of a RTS at the end of _Startup */
#pragma NO_CALLER  /* we don't have a caller. This generates debug information to stop at this function. */
void _Startup(void)  {
  _DoZeroOut();   /* zero initialize global variables */
  _DoCopyDown();  /* handle non zero initialized variables */
  __asm JMP main  /* start with main. */
}

#endif /* __ONLY_INIT_SP */
 