/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __LCD_HAL_H
#define __LCD_HAL_H

/*****************************************************************************************************
* Include files
*****************************************************************************************************/

/** Variable types and common definitions */
#include "FslTypes.h"

#define MC9RS08LE4
//#define MC9RS08LA8
//#define MC9S08LL16
//#define MC9S08LG32
//#define MCF51EM256
/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/

/*^^^^^^^^^^^^^^^^      LCD Configuration                        ^^^^^^^^^^^^^^^^^^^^^^^^*/

#define _LCDBACKPLANES			(8)				// # of backplanes  
#define _LCDCLKSOURCE			(1)				// 0 -- External clock       1 --  Alternate clock  (Internal)

#define _LCDCLKPSL				(5)				//  Clock divider to generate the LCD Waveforms

#define _LCDCPSEL				(1)				//0 -- Resistor network   1 -- Charge pump  
#define _LCDVSUPPLY				(3)				//0  --  VLL2 from VDD    1 --   VLL3 from VDD  2 -- VLL1 from VLCD  3 -- VLL3 external 
#define _LCDLOADADJUST			(3)				//Charge pump 		0 -- 8000 pf 1 -- 6000 pf  2 -- 4000 pf  3 -- 2000 pf
#define _LCDHIGHREF				(0)				//0 -- VIREG=1.0v   1 -- VIREG=1.67v

#define _LCDFRAMEINTERRUPT		(0)             //0 Disabel  Interrupt 1 Enable aLCD interrupt that coincides with the LCD frame frequency

#define _LCDBLINKRATE 			(0)				//Blink frequecy preescaler  any number between 0-7

#define _CHARNUM				(6)				// Number of characters on the display

#define _LCDTYPE				(2)				//Number of LCDWF  nedded  to drive one character 

/*^^^^^^^^^^^^^^^^      LCD Hardware Connection 			 ^^^^^^^^^^^^^^^^^^^^^^^^*/

#define EnableLCDpins(RegNum,Mask)		LCDPEN##RegNum = Mask
#define EnableBackplanes(RegNum, Mask)	LCDBPEN##RegNum = Mask   
#define SetBackplane(ComNum, LCDn)		LCDWF##LCDn  = (1 <<  (##ComNum##))
#define CharacterPlace(LCDn)        	LCDWF##LCDn
#define AllSegmentsON(LCDn,ComMask)		LCDWF##LCDn = ComMask
#define SymbolON(LCDn, BitNumber)		LCDWF##LCDn = (gu8RamBuffer[LCDn] |= (1<< BitNumber))
#define SymbolOFF(LCDn, BitNumber)		LCDWF##LCDn = (gu8RamBuffer[LCDn] &= ~(1<< BitNumber))
#define MapSegment(BitNumber)  			(1<<(##BitNumber##)) 
#define LCDWFRef          				LCDWF0
#define LCD_AlphanumericPlace(Place)	gu8LCD_CharPosition = _LCDTYPE*##(Place-1)
/*
EnableLCDpins
Habilitate the mcu pin with the characteristics of a LCD pin 
param: RegNum -- Number of register to write     Mask --- Mask that habilitate the LCDx pins
*/
	#define _PEN0()       EnableLCDpins (0,255)
	#define _PEN1()       EnableLCDpins (1,255)
	#define _PEN2()       EnableLCDpins (2,63)

/* 
EnableBackplanes
Enable the LCD pin like a Backplane functionality  
param: RegNum -- Number of register to write     LCDpin --- LCDn pin number that the Backplane it's connected 
*/
	#define   _BPEN0()        EnableBackplanes (0, 15)
	#define   _BPEN1()        EnableBackplanes (1, 0)
	#define   _BPEN2()        EnableBackplanes (2, 60)

/*
SetBackplane
 Give the COM number  to the previous enable Backplane     
param: ComNum -- COM number     LCDpin --- LCDn number of pin that its connected  
*/
	#define   _SETCOM1()        SetBackplane (0, 3)
	#define   _SETCOM2()        SetBackplane (1, 2)
	#define   _SETCOM3()        SetBackplane (2, 1)
	#define   _SETCOM4()        SetBackplane (3, 0)
	#define   _SETCOM5()        SetBackplane (4, 21)
	#define   _SETCOM6()        SetBackplane (5, 20)
	#define   _SETCOM7()        SetBackplane (6, 19)
	#define   _SETCOM8()        SetBackplane (7, 18)

/*
Character place
This macro defines the LDCWavefroms directions needed for write the alphanumerics        
param:  LCDpin --- LCDn number of pin that its connected */
	#define   CHAR1B       (15)
	#define   CHAR2B       (14)
	#define   CHAR3B       (4)
	#define   CHAR4B       (17)
	#define   CHAR5B       (16)
	#define   CHAR6B       (13)
	#define   CHAR6A       (10)
	#define   CHAR5A       (9)
	#define   CHAR4A       (8)
	#define   CHAR3A       (7)
	#define   CHAR2A       (6)
	#define   CHAR1A       (5)

/* 
AllSegmentsON
Turns on all the segments of the custom glass   
param: LCDn -- LCDWF that needs to be turn on	ComMask -- Bits that are turn on example: 8 COM = 255   2 COM = 3
*/
	#define SEGMENT1_ON               AllSegmentsON (15 , 255 )
	#define SEGMENT2_ON               AllSegmentsON (14 , 255 )
	#define SEGMENT3_ON               AllSegmentsON (4  , 255 )
	#define SEGMENT4_ON               AllSegmentsON (17 , 255 )
	#define SEGMENT5_ON               AllSegmentsON (16 , 255 )
	#define SEGMENT6_ON               AllSegmentsON (13 , 255 )
	#define SEGMENT7_ON               AllSegmentsON (12 , 255 )
	#define SEGMENT8_ON               AllSegmentsON (11 , 255 )
	#define SEGMENT9_ON               AllSegmentsON (10 , 255 )
	#define SEGMENT10_ON              AllSegmentsON (9  , 255 )
	#define SEGMENT11_ON              AllSegmentsON (8  , 255 )
	#define SEGMENT12_ON              AllSegmentsON (7  , 255 )
	#define SEGMENT13_ON              AllSegmentsON (6  , 255 )
	#define SEGMENT14_ON              AllSegmentsON (5  , 255 )
/* 
AllSegmentsOFF
Turns on all the segments of the custom glass   
param: LCDn -- LCDWF that needs to be turn on	ComMask -- Bits that are turn on example: 8 COM = 255   2 COM = 3*/
	#define SEGMENT1_OFF               AllSegmentsON (15 , 0 )
	#define SEGMENT2_OFF               AllSegmentsON (14 , 0 )
	#define SEGMENT3_OFF               AllSegmentsON (4  , 0 )
	#define SEGMENT4_OFF               AllSegmentsON (17 , 0 )
	#define SEGMENT5_OFF               AllSegmentsON (16 , 0 )
	#define SEGMENT6_OFF               AllSegmentsON (13 , 0 )
	#define SEGMENT7_OFF               AllSegmentsON (12 , 0 )
	#define SEGMENT8_OFF               AllSegmentsON (11 , 0 )
	#define SEGMENT9_OFF               AllSegmentsON (10 , 0 )
	#define SEGMENT10_OFF              AllSegmentsON (9  , 0 )
	#define SEGMENT11_OFF              AllSegmentsON (8  , 0 )
	#define SEGMENT12_OFF              AllSegmentsON (7  , 0 )
	#define SEGMENT13_OFF              AllSegmentsON (6  , 0 )
	#define SEGMENT14_OFF              AllSegmentsON (5  , 0 )


/* 
SymbolON
Turns on the  segment that its dedicated to write one Symbol     
param:  LCDpin --- LCDn number of pin that its connected   BitNumber -- COM Number that turns on that Symbol 
*/
	#define _LCD_TIME_ON 			SymbolON(15,7)
	#define _LCD_DATE_ON			SymbolON(14,7)
	#define _LCD_TEMP_ON 			SymbolON(4,7)
	#define _LCD_VOLUME_ON 			SymbolON(17,7)
	#define _LCD_CONTRAST_ON		SymbolON(16,7)
	#define _LCD_MODE_ON 			SymbolON(13,7)
	#define _LCD_VOL1_ON 			SymbolON(12,0)
	#define _LCD_VOL2_ON 			SymbolON(12,1)
	#define _LCD_VOL_ON 			SymbolON(12,2)
	#define _LCD_BATTERY_ON 		SymbolON(12,3)
	#define _LCD_BAT4_ON 			SymbolON(12,4)
	#define _LCD_BAT3_ON 			SymbolON(12,5)
	#define _LCD_BAT2_ON 			SymbolON(12,6)
	#define _LCD_BAT1_ON 			SymbolON(12,7)
	#define _LCD_POWER_ON		 	SymbolON(11,0)
	#define _LCD_VOL3_ON 			SymbolON(11,1)
	#define _LCD_VOL4_ON 			SymbolON(11,2)
	#define _LCD_VOL5_ON 			SymbolON(11,3)
	#define _LCD_AM_ON 				SymbolON(11,4)
	#define _LCD_PM_ON 				SymbolON(11,5)
	#define _LCD_DOT6_ON 			SymbolON(11,6)
	#define _LCD_CLOCK_ON 			SymbolON(11,7)
	#define _LCD_DOT5_ON 			SymbolON(10,6)
	#define _LCD_COL3_ON 			SymbolON(10,7)
	#define _LCD_DOT4_ON 			SymbolON(9,6)
	#define _LCD_COL2_ON 			SymbolON(9,7)
	#define _LCD_DOT3_ON 			SymbolON(8,6)
	#define _LCD_COOL_ON 			SymbolON(8,7)
	#define _LCD_DOT2_ON 			SymbolON(7,6)
	#define _LCD_COL1_ON 			SymbolON(7,7)
	#define _LCD_DOT1_ON 			SymbolON(6,6)
	#define _LCD_HEAT_ON 			SymbolON(6,7)
	#define _LCD_MINUS_ON 			SymbolON(5,6)
	#define _LCD_FREESCALE_ON 		SymbolON(5,7)
						
/*
SymbolOFF
Turns off the  segment   that its dedicated to write one Symbol     
param:  LCDpin --- LCDn number of pin that its connected   BitNumber -- COM Number that turns off that Symbol 
*/
	#define _LCD_TIME_OFF 			SymbolOFF(15,7)
	#define _LCD_DATE_OFF			SymbolOFF(14,7)
	#define _LCD_TEMP_OFF 			SymbolOFF(4,7)
	#define _LCD_VOLUME_OFF 		SymbolOFF(17,7)
	#define _LCD_COFFTRAST_OFF		SymbolOFF(16,7)
	#define _LCD_MODE_OFF 			SymbolOFF(13,7)
	#define _LCD_VOL1_OFF	 		SymbolOFF(12,0)
	#define _LCD_VOL2_OFF 			SymbolOFF(12,1)
	#define _LCD_VOL_OFF 			SymbolOFF(12,2)
	#define _LCD_BATTERY_OFF 		SymbolOFF(12,3)
	#define _LCD_BAT4_OFF 			SymbolOFF(12,4)
	#define _LCD_BAT3_OFF 			SymbolOFF(12,5)
	#define _LCD_BAT2_OFF 			SymbolOFF(12,6)
	#define _LCD_BAT1_OFF 			SymbolOFF(12,7)
	#define _LCD_POWER_OFF		 	SymbolOFF(11,0)
	#define _LCD_VOL3_OFF 			SymbolOFF(11,1)
	#define _LCD_VOL4_OFF 			SymbolOFF(11,2)
	#define _LCD_VOL5_OFF 			SymbolOFF(11,3)
	#define _LCD_AM_OFF 			SymbolOFF(11,4)
	#define _LCD_PM_OFF 			SymbolOFF(11,5)
	#define _LCD_DOT6_OFF 			SymbolOFF(11,6)
	#define _LCD_CLOCK_OFF 			SymbolOFF(11,7)
	#define _LCD_DOT5_OFF 			SymbolOFF(10,6)
	#define _LCD_COL3_OFF 			SymbolOFF(10,7)
	#define _LCD_DOT4_OFF 			SymbolOFF(9,6)
	#define _LCD_COL2_OFF 			SymbolOFF(9,7)
	#define _LCD_DOT3_OFF 			SymbolOFF(8,6)
	#define _LCD_COOL_OFF 			SymbolOFF(8,7)
	#define _LCD_DOT2_OFF 			SymbolOFF(7,6)
	#define _LCD_COL1_OFF 			SymbolOFF(7,7)
	#define _LCD_DOT1_OFF 			SymbolOFF(6,6)
	#define _LCD_HEAT_OFF 			SymbolOFF(6,7)
	#define _LCD_MINUS_OFF 			SymbolOFF(5,6)
	#define _LCD_FREESCALE_OFF 		SymbolOFF(5,7)

/*
MapSegments
Give the apropiate mask to set one segment of the display
param: BitNumber  -- Number of bit that needs to be turn on
*/ 
 #define  SEG1       MapSegment(0)
 #define  SEG2       MapSegment(1)
 #define  SEG3       MapSegment(2)
 #define  SEG4       MapSegment(3)
 #define  SEG5       MapSegment(4)
 #define  SEG6       MapSegment(5)
 #define  SEG7       MapSegment(6)
 #define  SEG8       MapSegment(7)
	      
	  #define SEGA		SEG1
	  #define SEGH		SEG2
	  #define SEGF		SEG3
	  #define SEGG		SEG4
	  #define SEGE		SEG5
	  #define SEGN      SEG6
	  #define SEGJ		SEG1
	  #define SEGK		SEG2
	  #define SEGB		SEG3
	  #define SEGC		SEG4
	  #define SEGL		SEG5
	  #define SEGM      SEG6
	  #define SEGD		SEG7

// All Symbols ON
#define _Backupa	(SEGA+SEGH+SEGF+SEGG+SEGE+SEGN)
#define _Backupb	(SEGJ+SEGK+SEGB+SEGC+SEGL+SEGM+SEGD)      


// Ascii table for the DEMO09RS08LE4
#define _0			(  SEGA + !SEGH +  SEGF + !SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK +  SEGB +  SEGC + !SEGL + !SEGM +  SEGD ) ,   //Char = 0 ,   offset =0
#define _1			( !SEGA + !SEGH + !SEGF + !SEGG + !SEGE + !SEGN ) ,     ( !SEGJ + !SEGK +  SEGB +  SEGC + !SEGL + !SEGM + !SEGD ) ,   //Char = 1 ,   offset =2
#define _2			(  SEGA + !SEGH + !SEGF +  SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK +  SEGB + !SEGC + !SEGL + !SEGM +  SEGD ) ,   //Char = 2 ,   offset =4
#define _3			(  SEGA + !SEGH + !SEGF +  SEGG + !SEGE + !SEGN ) ,     ( !SEGJ + !SEGK +  SEGB +  SEGC + !SEGL + !SEGM +  SEGD ) ,   //Char = 3 ,   offset =6
#define _4			( !SEGA + !SEGH +  SEGF +  SEGG + !SEGE + !SEGN ) ,     ( !SEGJ + !SEGK +  SEGB +  SEGC + !SEGL + !SEGM + !SEGD ) ,   //Char = 4 ,   offset =8
#define _5			(  SEGA + !SEGH +  SEGF +  SEGG + !SEGE + !SEGN ) ,     ( !SEGJ + !SEGK + !SEGB +  SEGC + !SEGL + !SEGM +  SEGD ) ,   //Char = 5 ,   offset =10
#define _6			(  SEGA + !SEGH +  SEGF +  SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK + !SEGB +  SEGC + !SEGL + !SEGM +  SEGD ) ,   //Char = 6 ,   offset =12
#define _7			(  SEGA + !SEGH + !SEGF + !SEGG + !SEGE + !SEGN ) ,     ( !SEGJ + !SEGK +  SEGB +  SEGC + !SEGL + !SEGM + !SEGD ) ,   //Char = 7 ,   offset =14
#define _8			(  SEGA + !SEGH +  SEGF +  SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK +  SEGB +  SEGC + !SEGL + !SEGM +  SEGD ) ,   //Char = 8 ,   offset =16
#define _9			(  SEGA + !SEGH +  SEGF +  SEGG + !SEGE + !SEGN ) ,     ( !SEGJ + !SEGK +  SEGB +  SEGC + !SEGL + !SEGM +  SEGD ) ,   //Char = 9 ,   offset =18
#define _AllOff		( 0 ) ,     ( 0) ,  
#define _Semicolon	( !SEGA + !SEGH + !SEGF + !SEGG + !SEGE + !SEGN ) ,     ( !SEGJ + !SEGK + !SEGB + !SEGC +  SEGL +  SEGM + !SEGD ) ,   //Char = ; ,   offset =22
#define _MinusThan	( !SEGA + !SEGH + !SEGF + !SEGG + !SEGE + !SEGN ) ,     ( !SEGJ +  SEGK + !SEGB + !SEGC +  SEGL + !SEGM + !SEGD ) ,   //Char = < ,   offset =24
#define _Equal		( !SEGA + !SEGH + !SEGF +  SEGG + !SEGE + !SEGN ) ,     ( !SEGJ + !SEGK + !SEGB + !SEGC + !SEGL + !SEGM +  SEGD ) ,   //Char = = ,   offset =26
#define _GreaterThan  !SEGA +  SEGH + !SEGF + !SEGG + !SEGE +  SEGN   ,     ( !SEGJ + !SEGK + !SEGB + !SEGC + !SEGL + !SEGM + !SEGD ) ,   //Char = > ,   offset =28
#define _Question	(  SEGA +  SEGH + !SEGF + !SEGG + !SEGE +  SEGN ) ,     ( !SEGJ +  SEGK + !SEGB + !SEGC + !SEGL + !SEGM + !SEGD ) ,   //Char = ? ,   offset =30
#define _AllOn		(  SEGA +  SEGH +  SEGF +  SEGG +  SEGE +  SEGN ) ,     (  SEGJ +  SEGK +  SEGB +  SEGC +  SEGL +  SEGM +  SEGD ) ,   //Char = @ ,   offset =32
#define _A			( SEGA + !SEGH +  SEGF +  SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK +  SEGB +  SEGC + !SEGL + !SEGM + !SEGD ) ,   //Char = A ,   offset =34
#define _B			( !SEGA + !SEGH +  SEGF +  SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK + !SEGB +  SEGC + !SEGL + !SEGM +  SEGD ) ,   //Char = B ,   offset =36
#define _C			( SEGA + !SEGH +  SEGF + !SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK + !SEGB + !SEGC + !SEGL + !SEGM +  SEGD ) ,   //Char = C ,   offset =38
#define _D			( !SEGA + !SEGH + !SEGF +  SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK +  SEGB +  SEGC + !SEGL + !SEGM +  SEGD ) ,   //Char = D ,   offset =40
#define _E			(  SEGA + !SEGH +  SEGF +  SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK + !SEGB + !SEGC + !SEGL + !SEGM +  SEGD ) ,   //Char = E ,   offset =42
#define _F			(  SEGA + !SEGH +  SEGF +  SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK + !SEGB + !SEGC + !SEGL + !SEGM + !SEGD ) ,   //Char = F ,   offset =44
#define _G			(  SEGA + !SEGH +  SEGF +  SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK + !SEGB +  SEGC + !SEGL + !SEGM +  SEGD ) ,   //Char = G ,   offset =46
#define _H			( !SEGA + !SEGH +  SEGF +  SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK +  SEGB +  SEGC + !SEGL + !SEGM + !SEGD ) ,   //Char = H ,   offset =48
#define _I			(  SEGA + !SEGH + !SEGF + !SEGG + !SEGE + !SEGN ) ,     (  SEGJ + !SEGK + !SEGB + !SEGC + !SEGL +  SEGM +  SEGD ) ,   //Char = I ,   offset =50
#define _J			( !SEGA + !SEGH + !SEGF + !SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK +  SEGB +  SEGC + !SEGL + !SEGM +  SEGD ) ,   //Char = J ,   offset =52
#define _K			( !SEGA + !SEGH + !SEGF + !SEGG + !SEGE + !SEGN ) ,     (  SEGJ +  SEGK + !SEGB + !SEGC +  SEGL +  SEGM + !SEGD ) ,   //Char = K ,   offset =54
#define _L			( !SEGA + !SEGH +  SEGF + !SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK + !SEGB + !SEGC + !SEGL + !SEGM +  SEGD ) ,   //Char = L ,   offset =56
#define _M			( !SEGA +  SEGH +  SEGF + !SEGG +  SEGE + !SEGN ) ,     ( !SEGJ +  SEGK +  SEGB +  SEGC + !SEGL + !SEGM + !SEGD ) ,   //Char = M ,   offset =58
#define _N			( !SEGA +  SEGH +  SEGF + !SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK +  SEGB +  SEGC +  SEGL + !SEGM + !SEGD ) ,   //Char = N ,   offset =60
#define _O			(  SEGA + !SEGH +  SEGF + !SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK +  SEGB +  SEGC + !SEGL + !SEGM +  SEGD ) ,   //Char = O ,   offset =62
#define _P			(  SEGA + !SEGH +  SEGF +  SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK +  SEGB + !SEGC + !SEGL + !SEGM + !SEGD ) ,   //Char = P ,   offset =64
#define _Q			(  SEGA + !SEGH +  SEGF + !SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK +  SEGB +  SEGC +  SEGL + !SEGM +  SEGD ) ,   //Char = Q ,   offset =66
#define _R			(  SEGA + !SEGH +  SEGF +  SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK +  SEGB + !SEGC +  SEGL + !SEGM + !SEGD ) ,   //Char = R ,   offset =68
#define _S			(  SEGA + !SEGH +  SEGF +  SEGG + !SEGE + !SEGN ) ,     ( !SEGJ + !SEGK + !SEGB +  SEGC + !SEGL + !SEGM +  SEGD ) ,   //Char = S ,   offset =70
#define _T			(  SEGA + !SEGH + !SEGF + !SEGG + !SEGE + !SEGN ) ,     (  SEGJ + !SEGK + !SEGB + !SEGC + !SEGL +  SEGM + !SEGD ) ,   //Char = T ,   offset =72
#define _U			( !SEGA + !SEGH +  SEGF + !SEGG +  SEGE + !SEGN ) ,     ( !SEGJ + !SEGK +  SEGB +  SEGC + !SEGL + !SEGM +  SEGD ) ,   //Char = U ,   offset =74
#define _V			( !SEGA + !SEGH +  SEGF + !SEGG + !SEGE +  SEGN ) ,     ( !SEGJ + !SEGK +  SEGB + !SEGC +  SEGL +  SEGM + !SEGD ) ,   //Char = V ,   offset =76
#define _W			( !SEGA + !SEGH +  SEGF + !SEGG +  SEGE +  SEGN ) ,     ( !SEGJ + !SEGK +  SEGB +  SEGC +  SEGL + !SEGM + !SEGD ) ,   //Char = W ,   offset =78
#define _X			( !SEGA +  SEGH + !SEGF + !SEGG + !SEGE +  SEGN ) ,     ( !SEGJ +  SEGK + !SEGB + !SEGC +  SEGL + !SEGM + !SEGD ) ,   //Char = X ,   offset =80
#define _Y			( !SEGA +  SEGH + !SEGF + !SEGG + !SEGE + !SEGN ) ,     ( !SEGJ +  SEGK + !SEGB + !SEGC + !SEGL +  SEGM + !SEGD ) ,   //Char = Y ,   offset =82
#define _Z			(  SEGA + !SEGH + !SEGF + !SEGG + !SEGE +  SEGN ) ,     ( !SEGJ +  SEGK + !SEGB + !SEGC + !SEGL + !SEGM +  SEGD ) ,   //Char = Z ,   offset =84    

/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

#endif /* __LCD_HAL_H */

