/****************************************************************************************************/
/*
\file       LCD_HAL.h
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		August 2009      
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.		*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end	*/
/* product.                                                                                     	*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __LCD_HAL_H
#define __LCD_HAL_H

/*****************************************************************************************************
* Include files
*****************************************************************************************************/

/** Variable types and common definitions */
#include "FslTypes.h"

//#define MC9RS08LE4
#define MC9RS08LA8
//#define MC9S08LL16
//#define MC9S08LG32
//#define MCF51EM256
/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/

/*^^^^^^^^^^^^^^^^      LCD Configuration                        ^^^^^^^^^^^^^^^^^^^^^^^^*/

#define _LCDBACKPLANES			(8)				// # of backplanes  
#define _LCDCLKSOURCE			(1)				// 0 -- External clock       1 --  Alternate clock  (Internal)

#define _LCDCLKPSL				(3)				//  Clock divider to generate the LCD Waveforms

#define _LCDCPSEL				(1)				//0 -- Resistor network   1 -- Charge pump  
#define _LCDVSUPPLY				(1)				//0  --  VLL2 from VDD    1 --   VLL3 from VDD  2 -- VLL1 from VLCD  3 -- VLL3 external 
#define _LCDLOADADJUST			(3)				//Charge pump 		0 -- 8000 pf 1 -- 6000 pf  2 -- 4000 pf  3 -- 2000 pf
                                                //Resistor Network	0 -- 2000 pf 1 -- 2000 pf  2 -- 8000 pf   3 -- 8000 pf 

#define _LCDFRAMEINTERRUPT		(0)             //0 Disabel  Interrupt 1 Enable aLCD interrupt that coincides with the LCD frame frequency

#define _LCDBLINKRATE 			(0)				//Blink frequecy preescaler  any number between 0-7

#define _CHARNUM				(9)				// Number of characters on the display

#define _LCDTYPE				(2)				//Number of LCDWF  nedded  to drive one character 

/*^^^^^^^^^^^^^^^^      LCD Hardware Connection 			 ^^^^^^^^^^^^^^^^^^^^^^^^*/

#define EnableLCDpins(RegNum,Mask)		LCDPEN##RegNum = Mask
#define EnableBackplanes(RegNum, Mask)	LCDBPEN##RegNum = Mask   
#define SetBackplane(ComNum, LCDn)		LCDWF##LCDn  = (1 <<  (##ComNum##))
#define CharacterPlace(LCDn)        	LCDWF##LCDn
#define AllSegmentsON(LCDn,ComMask)		LCDWF##LCDn = ComMask
#define SymbolON(LCDn, BitNumber)		LCDWF##LCDn = (gu8RamBuffer[LCDn] |= (1<< BitNumber))
#define SymbolOFF(LCDn, BitNumber)		LCDWF##LCDn = (gu8RamBuffer[LCDn] &= ~(1<< BitNumber))
#define MapSegment(BitNumber)  			(1<<(##BitNumber##)) 
#define LCDWFRef          				LCDWF0
#define LCD_AlphanumericPlace(Place)	bLCD_CharPosition=_LCDTYPE*##(Place-1)
/*
EnableLCDpins
Habilitate the mcu pin with the characteristics of a LCD pin 
param: RegNum -- Number of register to write     Mask --- Mask that habilitate the LCDx pins
*/
	#define _PEN0()       EnableLCDpins (0,0xFF)
	#define _PEN1()       EnableLCDpins (1,0xFF)
	#define _PEN2()       EnableLCDpins (2,0xFF)
	#define _PEN3()       EnableLCDpins (3,0x1F)

/* 
EnableBackplanes
Enable the LCD pin like a Backplane functionality  
param: RegNum -- Number of register to write     LCDpin --- LCDn pin number that the Backplane it's connected 
*/
	#define   _BPEN0()        EnableBackplanes (0, 0x80)
	#define   _BPEN1()        EnableBackplanes (1, 0x7F)
	#define   _BPEN2()        EnableBackplanes (2, 0x00)
	#define   _BPEN3()        EnableBackplanes (3, 0x00)

/* Give the COM number  to the previous enable Backplane     
param: ComNum -- COM number     LCDpin --- LCDn number of pin that its connected  */
	#define   _SETCOM1()        SetBackplane(0,14)
	#define   _SETCOM2()        SetBackplane(1,13)
	#define   _SETCOM3()        SetBackplane(2,12)
	#define   _SETCOM4()        SetBackplane(3,11)
	#define   _SETCOM5()        SetBackplane(4,10)
	#define   _SETCOM6()        SetBackplane(5,9)
	#define   _SETCOM7()        SetBackplane(6,8)
	#define   _SETCOM8()        SetBackplane(7,7)

/*
Character place
This macro defines the LDCWavefroms directions needed for write the alphanumerics        
param:  LCDpin --- LCDn number of pin that its connected */
	#define   CHAR1A       (6)
	#define   CHAR1B       (16)
	#define   CHAR2A       (5)
	#define   CHAR2B       (17)
	#define   CHAR3A       (4)
	#define   CHAR3B       (18)
	#define   CHAR4A       (3)
	#define   CHAR4B       (19)
	#define   CHAR5A       (2)
	#define   CHAR5B       (20)
	#define   CHAR6A       (1)
	#define   CHAR6B       (21)
	#define   CHAR7A       (0)
	#define   CHAR7B       (22)
	#define   CHAR8A       (28)
	#define   CHAR8B       (23)
	#define   CHAR9A       (27)
	#define   CHAR9B       (24)

/* 
AllSegmentsON
Turns on all the segments of the custom glass   
param: LCDn -- LCDWF that needs to be turn on	ComMask -- Bits that are turn on example: 8 COM = 255   2 COM = 3
*/
	#define SEGMENT1_ON     AllSegmentsON (6 , 255 )
	#define SEGMENT2_ON		AllSegmentsON (5 , 255 )
	#define SEGMENT3_ON		AllSegmentsON (4 , 255 )
	#define SEGMENT4_ON		AllSegmentsON (3 , 255 )
	#define SEGMENT5_ON		AllSegmentsON (2 , 255 )
	#define SEGMENT6_ON		AllSegmentsON (1 , 255 )
	#define SEGMENT7_ON		AllSegmentsON (0 , 255 )
	#define SEGMENT8_ON		AllSegmentsON (28 , 255 )
	#define SEGMENT9_ON		AllSegmentsON (27 , 255 )
	#define SEGMENT10_ON	AllSegmentsON (26 , 255 )
	#define SEGMENT11_ON    AllSegmentsON (25 , 255 )
	#define SEGMENT12_ON    AllSegmentsON (24 , 255 )
	#define SEGMENT13_ON    AllSegmentsON (23 , 255 )
	#define SEGMENT14_ON    AllSegmentsON (22 , 255 )
	#define SEGMENT15_ON    AllSegmentsON (21 , 255 )
	#define SEGMENT16_ON    AllSegmentsON (20 , 255 )
	#define SEGMENT17_ON    AllSegmentsON (19 , 255 )
	#define SEGMENT18_ON    AllSegmentsON (18 , 255 )
	#define SEGMENT19_ON    AllSegmentsON (17 , 255 )
	#define SEGMENT20_ON    AllSegmentsON (16 , 255 )
	#define SEGMENT21_ON    AllSegmentsON (15, 255 )

/* 							         
AllSegmentsOFF
Turns on all the segments of the custom glass   
param: LCDn -- LCDWF that needs to be turn on	ComMask -- Bits that are turn off example: 0*/
	#define SEGMENT1_OFF		AllSegmentsON (6 , 0 )
	#define SEGMENT2_OFF		AllSegmentsON (5 , 0 )
	#define SEGMENT3_OFF		AllSegmentsON (4 , 0 )
	#define SEGMENT4_OFF		AllSegmentsON (3 , 0 )
	#define SEGMENT5_OFF		AllSegmentsON (2 , 0 )
	#define SEGMENT6_OFF		AllSegmentsON (1 , 0 )
	#define SEGMENT7_OFF		AllSegmentsON (0 , 0 )
	#define SEGMENT8_OFF		AllSegmentsON (28 , 0 )
	#define SEGMENT9_OFF		AllSegmentsON (27 , 0 )
	#define SEGMENT10_OFF		AllSegmentsON (26 , 0 )
	#define SEGMENT11_OFF		AllSegmentsON (25 , 0 )
	#define SEGMENT12_OFF		AllSegmentsON (24 , 0 )
	#define SEGMENT13_OFF		AllSegmentsON (23 , 0 )
	#define SEGMENT14_OFF		AllSegmentsON (22 , 0 )
	#define SEGMENT15_OFF		AllSegmentsON (21 , 0 )
	#define SEGMENT16_OFF		AllSegmentsON (20 , 0 )
	#define SEGMENT17_OFF		AllSegmentsON (19 , 0 )
	#define SEGMENT18_OFF		AllSegmentsON (18 , 0 )
	#define SEGMENT19_OFF		AllSegmentsON (17 , 0 )
	#define SEGMENT20_OFF		AllSegmentsON (16 , 0 )
	#define SEGMENT21_OFF		AllSegmentsON (15, 0 )
	       

/* 
SymbolON
Turns on the  segment that its dedicated to write one Symbol     
param:  LCDpin --- LCDn number of pin that its connected   BitNumber -- COM Number that turns on that Symbol 
*/
	#define _LCD_PROGRAM_ON 	SymbolON(0,7)
	#define _LCD_MODE_ON	  	SymbolON(1,7)
	#define _LCD_CONTRAST_ON 	SymbolON(2,7)
	#define _LCD_DT3_ON 		SymbolON(19,6)
	#define _LCD_DT4_ON 		SymbolON(20,6)
	#define _LCD_DT5_ON 		SymbolON(21,6)
	#define _LCD_PM_ON			SymbolON(26,5)
	#define _LCD_AM_ON			SymbolON(26,3)
	#define _LCD_KWH_ON 		SymbolON(26,4)
	#define _LCD_VOLUME_ON 		SymbolON(3,7)
	#define _LCD_VOL1_ON 		SymbolON(25,1)
	#define _LCD_VOL2_ON 		SymbolON(25,0)
	#define _LCD_VOL3_ON 		SymbolON(26,0)
	#define _LCD_VOL4_ON 		SymbolON(26,1)
	#define _LCD_VOL5_ON 		SymbolON(26,2)
	#define _LCD_COL4_ON 		SymbolON(24,7)
	#define _LCD_POWER_ON 		SymbolON(22,7)
	#define _LCD_VOL_ON 		SymbolON(25,2)
	#define _LCD_BATTERY_ON	 	SymbolON(25,3)
	#define _LCD_BAT4_ON 		SymbolON(25,4)
	#define _LCD_BAT3_ON 		SymbolON(25,5)
	#define _LCD_BAT2_ON 		SymbolON(25,6)
	#define _LCD_BAT1_ON 		SymbolON(25,7)
	#define _LCD_M5_ON		  	SymbolON(15,0)
	#define _LCD_M4_ON 			SymbolON(15,1)
	#define _LCD_M3_ON 			SymbolON(15,3)
	#define _LCD_M2_ON		  	SymbolON(15,5)
	#define _LCD_M1_ON 		  	SymbolON(15,6)
	#define _LCD_M8_ON 		  	SymbolON(15,7)
	#define _LCD_M7_ON 		  	SymbolON(15,4)
	#define _LCD_M6_ON		  	SymbolON(15,2)
	#define _LCD_AMPS_ON 		SymbolON(26,6)
	#define _LCD_VOLTS_ON 		SymbolON(26,7)
	#define _LCD_OHMS_ON 	  	SymbolON(20,7)
	#define _LCD_DT8_ON 		SymbolON(24,6)
	#define _LCD_COL3_ON 		SymbolON(23,7)
	#define _LCD_DT6_ON 		SymbolON(22,6)
	#define _LCD_DT7_ON 		SymbolON(23,6)
	#define _LCD_CLOCK_ON 		SymbolON(28,7)
	#define _LCD_FREESCALE_ON 	SymbolON(16,7)
	#define _LCD_MINUS_ON 		SymbolON(16,6)
	#define _LCD_TIME_ON 		SymbolON(6,7)
	#define _LCD_DATE_ON 		SymbolON(5,7)
	#define _LCD_TEMP_ON 		SymbolON(4,7)
	#define _LCD_COL1_ON 		SymbolON(18,7)
	#define _LCD_DT1_ON 		SymbolON(17,6)
	#define _LCD_DT2_ON 		SymbolON(18,6)
	#define _LCD_FREEZE_ON  	SymbolON(19,7)
  	#define _LCD_HEAT_ON     	SymbolON(17,7)
  	#define _LCD_DT9_ON 		SymbolON(27,7)

/*
SymbolOFF
 Turns off the  segment   that its dedicated to write one Symbol     
param:  LCDpin --- LCDn number of pin that its connected   BitNumber -- COM Number that turns off that Symbol 
*/
	#define _LCD_PROGRAM_OFF 	SymbolOFF(0,7)
	#define _LCD_MODE_OFF		SymbolOFF(1,7)
	#define _LCD_COFFTRAST_OFF 	SymbolOFF(2,7)
	#define _LCD_VOLUME_OFF		SymbolOFF(25,2)  
	#define _LCD_DT3_OFF 		SymbolOFF(19,6)
	#define _LCD_DT4_OFF 		SymbolOFF(20,6)
	#define _LCD_DT5_OFF 		SymbolOFF(21,6)
	#define _LCD_PM_OFF 		SymbolOFF(26,5)
	#define _LCD_AM_OFF			SymbolOFF(26,3)
	#define _LCD_KWH_OFF 		SymbolOFF(26,4)
	#define _LCD_VOL1_OFF 		SymbolOFF(25,1)
	#define _LCD_VOL2_OFF 		SymbolOFF(25,0)
	#define _LCD_VOL3_OFF 		SymbolOFF(26,0)
	#define _LCD_VOL4_OFF 		SymbolOFF(26,1)
	#define _LCD_VOL5_OFF 		SymbolOFF(26,2)
	#define _LCD_COL4_OFF 		SymbolOFF(24,7)
	#define _LCD_POWER_OFF 		SymbolOFF(22,7)
	#define _LCD_VOL_OFF 		SymbolOFF(25,2)
	#define _LCD_BATTERY_OFF	SymbolOFF(25,3)
	#define _LCD_BAT4_OFF 		SymbolOFF(25,4)
	#define _LCD_BAT3_OFF 		SymbolOFF(25,5)
	#define _LCD_BAT2_OFF 		SymbolOFF(25,6)
	#define _LCD_BAT1_OFF 		SymbolOFF(25,7)
	#define _LCD_M5_OFF			SymbolOFF(15,0)
	#define _LCD_M4_OFF 		SymbolOFF(15,1)
	#define _LCD_M3_OFF 		SymbolOFF(15,3)
	#define _LCD_M2_OFF			SymbolOFF(15,5)
	#define _LCD_M1_OFF 		SymbolOFF(15,6)   
	#define _LCD_M8_OFF 		SymbolOFF(15,7)
	#define _LCD_M7_OFF 		SymbolOFF(15,4)
	#define _LCD_M6_OFF			SymbolOFF(15,2)
	#define _LCD_AMPS_OFF 		SymbolOFF(26,6)
	#define _LCD_VOLTS_OFF 		SymbolOFF(26,7)
	#define _LCD_OHMS_OFF 		SymbolOFF(20,7)
	#define _LCD_DT8_OFF 		SymbolOFF(24,6)
	#define _LCD_COL3_OFF 		SymbolOFF(23,7)
	#define _LCD_DT6_OFF 		SymbolOFF(22,6)
	#define _LCD_DT7_OFF 		SymbolOFF(23,6)
	#define _LCD_CLOCK_OFF 		SymbolOFF(28,7)
	#define _LCD_FREESCALE_OFF 	SymbolOFF(16,7)
	#define _LCD_MINUS_OFF 		SymbolOFF(16,6)
	#define _LCD_TIME_OFF 		SymbolOFF(6,7)
	#define _LCD_DATE_OFF 		SymbolOFF(5,7)
	#define _LCD_TEMP_OFF 		SymbolOFF(4,7)
	#define _LCD_COL1_OFF 		SymbolOFF(18,7)
	#define _LCD_DT1_OFF 		SymbolOFF(17,6)
	#define _LCD_DT2_OFF 		SymbolOFF(18,6)
	

/*
MapSegments
Give the apropiate mask to set one segment of the display
param: BitNumber  -- Number of bit that needs to be turn on
*/ 
#define  SEG1         MapSegment (0)
#define  SEG2         MapSegment (2)
#define  SEG3         MapSegment (3)
#define  SEG4         MapSegment (6)
#define  SEG5         MapSegment (4)
#define  SEG6         MapSegment (2)
#define  SEG7         MapSegment (3)
#define  SEG8         MapSegment (1)
#define  SEG9         MapSegment (0)
#define  SEG10        MapSegment (0)
#define  SEG11        MapSegment (1)
#define  SEG12        MapSegment (4)
#define  SEG13        MapSegment (5)
#define  SEG14        MapSegment (5)
#define  SEG15        MapSegment (0)
#define  SEG16        MapSegment (0)


/*
Name Segments 
Create a mask to turn on alphanumeric segments
*/ 
#define SEGP        SEG16
#define SEGB        SEG2
#define SEGK        SEG11
#define SEGG        SEG7
#define SEGC        SEG3
#define SEGI        SEG9
#define SEGM        SEG13
#define SEGD        SEG4
#define SEGA        SEG1
#define SEGF        SEG6
#define SEGH        SEG8
#define SEGJ        SEG10
#define SEGL        SEG12
#define SEGE        SEG5
#define SEGN        SEG14
#define SEGO        SEG15


#define _Backupb	(  SEGN +  SEGF +  SEGH +  SEGE +  SEGG +  SEGA ) 				//Charb all segments on
#define _Backupa	(  SEGL +  SEGM +  SEGD +  SEGC +  SEGK +  SEGJ +  SEGB)  			//Chara all segments on  		      

// Ascii table for the DEMO09RS08LA8
#define _0			(!SEGL+!SEGM+ SEGD+ SEGC+ !SEGK+!SEGJ+ SEGB) , (!SEGN+ SEGF+!SEGH+  SEGE+!SEGG+ SEGA) ,   //Char = 0 ,   offset =0
#define _1			(!SEGL+!SEGM+!SEGD+ SEGC+ !SEGK+!SEGJ+ SEGB) , (!SEGN+!SEGF+!SEGH+ !SEGE+!SEGG+!SEGA) ,   //Char = 1 ,   offset =2
#define _2			(!SEGL+!SEGM+ SEGD+!SEGC+ !SEGK+!SEGJ+ SEGB) , (!SEGN+!SEGF+!SEGH+  SEGE+ SEGG+ SEGA) ,   //Char = 2 ,   offset =4
#define _3			(!SEGL+!SEGM+ SEGD+ SEGC+ !SEGK+!SEGJ+ SEGB) , (!SEGN+!SEGF+!SEGH+ !SEGE+ SEGG+ SEGA) ,   //Char = 3 ,   offset =6
#define _4			(!SEGL+!SEGM+!SEGD+ SEGC+ !SEGK+!SEGJ+ SEGB) , (!SEGN+ SEGF+!SEGH+ !SEGE+ SEGG+!SEGA) ,   //Char = 4 ,   offset =8
#define _5			(!SEGL+!SEGM+ SEGD+ SEGC+ !SEGK+!SEGJ+!SEGB) , (!SEGN+ SEGF+!SEGH+ !SEGE+ SEGG+ SEGA) ,   //Char = 5 ,   offset =10
#define _6			(!SEGL+!SEGM+ SEGD+ SEGC+ !SEGK+!SEGJ+!SEGB) , (!SEGN+ SEGF+!SEGH+  SEGE+ SEGG+ SEGA) ,   //Char = 6 ,   offset =12
#define _7			(!SEGL+!SEGM+!SEGD+ SEGC+ !SEGK+!SEGJ+ SEGB) , (!SEGN+!SEGF+!SEGH+ !SEGE+!SEGG+ SEGA) ,   //Char = 7 ,   offset =14
#define _8			(!SEGL+!SEGM+ SEGD+ SEGC+ !SEGK+!SEGJ+ SEGB) , (!SEGN+ SEGF+!SEGH+  SEGE+ SEGG+ SEGA) ,   //Char = 8 ,   offset =16
#define _9			(!SEGL+!SEGM+ SEGD+ SEGC+ !SEGK+!SEGJ+ SEGB) , (!SEGN+ SEGF+!SEGH+ !SEGE+ SEGG+ SEGA) ,   //Char = 9 ,   offset =18
#define _AllOff		(!SEGL+!SEGM+!SEGD+!SEGC+ !SEGK+!SEGJ+!SEGB) , (!SEGN+!SEGF+!SEGH+ !SEGE+!SEGG+!SEGA) ,   //Char = : ,   offset =20
#define _Semicolon	( SEGL+ SEGM+!SEGD+!SEGC+ !SEGK+!SEGJ+!SEGB) , (!SEGN+!SEGF+!SEGH+ !SEGE+!SEGG+!SEGA) ,   //Char = ; ,   offset =22
#define _MinusThan	( SEGL+!SEGM+!SEGD+!SEGC+  SEGK+!SEGJ+!SEGB) , (!SEGN+!SEGF+!SEGH+ !SEGE+!SEGG+!SEGA) ,   //Char = < ,   offset =24
#define _Equal		(!SEGL+!SEGM+ SEGD+!SEGC+ !SEGK+!SEGJ+!SEGB) , (!SEGN+!SEGF+!SEGH+ !SEGE+ SEGG+!SEGA) ,   //Char = = ,   offset =26
#define _GreaterThan (!SEGL+!SEGM+!SEGD+!SEGC+ !SEGK+!SEGJ+!SEGB) , ( SEGN+!SEGF+ SEGH+ !SEGE+!SEGG+!SEGA) ,   //Char = > ,   offset =28
#define _Question	(!SEGL+!SEGM+!SEGD+!SEGC+  SEGK+!SEGJ+!SEGB) , ( SEGN+!SEGF+ SEGH+ !SEGE+!SEGG+ SEGA) ,   //Char = ? ,   offset =30
#define _AllOn		( SEGL+ SEGM+ SEGD+ SEGC+  SEGK+ SEGJ+ SEGB) , ( SEGN+ SEGF+ SEGH+  SEGE+ SEGG+ SEGA) ,   //Char = @ ,   offset =32
#define _A			(!SEGL+!SEGM+!SEGD+ SEGC+ !SEGK+!SEGJ+ SEGB) , (!SEGN+ SEGF+!SEGH+  SEGE+ SEGG+ SEGA) ,   //Char = A ,   offset =34
#define _B			(!SEGL+!SEGM+ SEGD+ SEGC+ !SEGK+!SEGJ+!SEGB) , (!SEGN+ SEGF+!SEGH+  SEGE+ SEGG+!SEGA) ,   //Char = B ,   offset =36
#define _C			(!SEGL+!SEGM+ SEGD+!SEGC+ !SEGK+!SEGJ+!SEGB) , (!SEGN+ SEGF+!SEGH+  SEGE+!SEGG+ SEGA) ,   //Char = C ,   offset =38
#define _D			(!SEGL+!SEGM+ SEGD+ SEGC+ !SEGK+!SEGJ+ SEGB) , (!SEGN+!SEGF+!SEGH+  SEGE+ SEGG+!SEGA) ,   //Char = D ,   offset =40
#define _E			(!SEGL+!SEGM+ SEGD+!SEGC+ !SEGK+!SEGJ+!SEGB) , (!SEGN+ SEGF+!SEGH+  SEGE+ SEGG+ SEGA) ,   //Char = E ,   offset =42
#define _F			(!SEGL+!SEGM+!SEGD+!SEGC+ !SEGK+!SEGJ+!SEGB) , (!SEGN+ SEGF+!SEGH+  SEGE+ SEGG+ SEGA) ,   //Char = F ,   offset =44
#define _G			(!SEGL+!SEGM+ SEGD+ SEGC+ !SEGK+!SEGJ+!SEGB) , (!SEGN+ SEGF+!SEGH+  SEGE+ SEGG+ SEGA) ,   //Char = G ,   offset =46
#define _H			(!SEGL+!SEGM+!SEGD+ SEGC+ !SEGK+!SEGJ+ SEGB) , (!SEGN+ SEGF+!SEGH+  SEGE+ SEGG+!SEGA) ,   //Char = H ,   offset =48
#define _I			(!SEGL+ SEGM+ SEGD+!SEGC+ !SEGK+ SEGJ+!SEGB) , (!SEGN+!SEGF+!SEGH+ !SEGE+!SEGG+ SEGA) ,   //Char = I ,   offset =50
#define _J			(!SEGL+!SEGM+ SEGD+ SEGC+ !SEGK+!SEGJ+ SEGB) , (!SEGN+!SEGF+!SEGH+  SEGE+!SEGG+!SEGA) ,   //Char = J ,   offset =52
#define _K			( SEGL+ SEGM+!SEGD+!SEGC+  SEGK+ SEGJ+!SEGB) , (!SEGN+!SEGF+!SEGH+ !SEGE+!SEGG+!SEGA) ,   //Char = K ,   offset =54
#define _L			(!SEGL+!SEGM+ SEGD+!SEGC+ !SEGK+!SEGJ+!SEGB) , (!SEGN+ SEGF+!SEGH+  SEGE+!SEGG+!SEGA) ,   //Char = L ,   offset =56
#define _M			(!SEGL+!SEGM+!SEGD+ SEGC+  SEGK+!SEGJ+ SEGB) , (!SEGN+ SEGF+ SEGH+  SEGE+!SEGG+!SEGA) ,   //Char = M ,   offset =58
#define _N			( SEGL+!SEGM+!SEGD+ SEGC+ !SEGK+!SEGJ+ SEGB) , (!SEGN+ SEGF+ SEGH+  SEGE+!SEGG+!SEGA) ,   //Char = N ,   offset =60
#define _O			(!SEGL+!SEGM+ SEGD+ SEGC+ !SEGK+!SEGJ+ SEGB) , (!SEGN+ SEGF+!SEGH+  SEGE+!SEGG+ SEGA) ,   //Char = O ,   offset =62
#define _P			(!SEGL+!SEGM+!SEGD+!SEGC+ !SEGK+!SEGJ+ SEGB) , (!SEGN+ SEGF+!SEGH+  SEGE+ SEGG+ SEGA) ,   //Char = P ,   offset =64
#define _Q			( SEGL+!SEGM+ SEGD+ SEGC+ !SEGK+!SEGJ+ SEGB) , (!SEGN+ SEGF+!SEGH+  SEGE+!SEGG+ SEGA) ,   //Char = Q ,   offset =66
#define _R			( SEGL+!SEGM+!SEGD+!SEGC+ !SEGK+!SEGJ+ SEGB) , (!SEGN+ SEGF+!SEGH+  SEGE+ SEGG+ SEGA) ,   //Char = R ,   offset =68
#define _S			(!SEGL+!SEGM+ SEGD+ SEGC+ !SEGK+!SEGJ+!SEGB) , (!SEGN+ SEGF+!SEGH+ !SEGE+ SEGG+ SEGA) ,   //Char = S ,   offset =70
#define _T			(!SEGL+ SEGM+!SEGD+!SEGC+ !SEGK+ SEGJ+!SEGB) , (!SEGN+!SEGF+!SEGH+ !SEGE+!SEGG+ SEGA) ,   //Char = T ,   offset =72
#define _U			(!SEGL+!SEGM+ SEGD+ SEGC+ !SEGK+!SEGJ+ SEGB) , (!SEGN+ SEGF+!SEGH+  SEGE+!SEGG+!SEGA) ,   //Char = U ,   offset =74
#define _V			( SEGL+ SEGM+!SEGD+!SEGC+ !SEGK+!SEGJ+ SEGB) , ( SEGN+ SEGF+!SEGH+ !SEGE+!SEGG+!SEGA) ,   //Char = V ,   offset =76
#define _W			( SEGL+!SEGM+!SEGD+ SEGC+ !SEGK+!SEGJ+ SEGB) , ( SEGN+ SEGF+!SEGH+  SEGE+!SEGG+!SEGA) ,   //Char = W ,   offset =78
#define _X			( SEGL+!SEGM+!SEGD+!SEGC+  SEGK+!SEGJ+!SEGB) , ( SEGN+!SEGF+ SEGH+ !SEGE+!SEGG+!SEGA) ,   //Char = X ,   offset =80
#define _Y			(!SEGL+ SEGM+!SEGD+!SEGC+  SEGK+!SEGJ+!SEGB) , (!SEGN+!SEGF+ SEGH+ !SEGE+!SEGG+!SEGA) ,   //Char = Y ,   offset =82
#define _Z			(!SEGL+!SEGM+ SEGD+!SEGC+  SEGK+!SEGJ+!SEGB) , ( SEGN+!SEGF+!SEGH+ !SEGE+!SEGG+ SEGA) ,   //Char = Z ,   offset =84

/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

#endif /* __LCD_HAL_H */
