/****************************************************************************************************/
/*
\file       LCD.h
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		August 2009      
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.		*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end	*/
/* product.                                                                                     	*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __LCD_H
#define __LCD_H

/*****************************************************************************************************
* Include files
*****************************************************************************************************/

/** Variable types and common definitions */
#include "FslTypes.h"
#include "derivative.h"
#include "LCD_HAL.h"

/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/
#ifdef MC9RS08LE4
  #define _RAM_BUFFER_SIZE			22
  #define  _POINTER					*__paged
#endif


 #ifdef MC9RS08LA8
   #define _RAM_BUFFER_SIZE			29
   #define  _POINTER					*__paged
#endif


#ifdef MC9S08LL16
  #define _RAM_BUFFER_SIZE			32
  #define _POINTER					*
  #define vfnLCD_Contrast(Contrast)		LCDRVC_RVTRIM=Contrast	/**  Write the contrast value to the register on the mcu*/
#endif

#ifdef MC9S08LG32
  #define _RAM_BUFFER_SIZE			45
  #define _POINTER					*
  #define vfnLCD_Contrast(Contrast)		LCDRVC_RVTRIM=Contrast	/**  Write the contrast value to the register on the mcu*/
#endif


#ifdef MCF51EM256
  #define _RAM_BUFFER_SIZE			44
  #define _POINTER					*
  #define vfnLCD_Contrast(Contrast)		LCDRVC_RVTRIM=Contrast	/**  Write the contrast value to the register on the mcu*/
#endif

/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/
extern UINT8 gu8RamBuffer[_RAM_BUFFER_SIZE];

/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/
#define vfnLCD_Home()		gu8LCD_CharPosition = 0	
#define vfnLCD_GoTo(Place)	gu8LCD_CharPosition =(UINT8)((Place-1)*_LCDTYPE) 


/*******************************LCD Control Register 0 LCDC0*****************************************/

#define _LCDENABLE			(0)	/** 0 All frontplanes and backplanes are disable
                                    1 LCD module is enable */

#define  _LCDDUTY		(_LCDBACKPLANES-1)		//# of Backplanes 

/*******************************LCD Control Register 1 LCDC1*****************************************/

#define _LCDWAITMODE		(0)	/** 0 Charge pump running during wait mode
                               	    1 Disable the LCD when the MCU goes into wait mode */

#define _LCDSTOPMODE		(0)	/** 0 Allows the LCD driver and charge pump during stop modes
                               	    1 Disable the LCD when the mcu goes to stop mode */                                                              


/*******************************LCD  Voltage Supply Register LCDSUPPLY*********************************/
#define _LCDHIGHREF			(0)	/** 0 Divide input VIREG=1.0v 
                                	1 Do not divide the input VIREG=1.67v */
								
#define _LCDBBYPASS			(0)	/** Determines wheter the internal LCD op amp buffer is bypassed
                                	0 Buffered mode
                                	1 Unbuffered mode */
                                

/*******************************LCD  Regulated Voltage Control LCDRVC *********************************/
#define _LCDCONTRAST		(1)	/** Contrast by software   
									0 Disable
								    1 Enable */		  
								    
								    
#define _LVLCONTRAST		(0)	/** Any number between 0  and 15, if the number is bigger the glass get darker*/

/*******************************LCD  Blink Control Register LCDBCTL ***********************************/
#define _LCDBLINKCONTROL	(0) /** 0 Disable blink mode
                                    1 Enable blink mode  */
                                  
#define _LCDALTMODE			(0) /** 0 Normal display 
                                    1 Alternate display
                                NOTE!! for 4 backplanes alternate display only */

#define _LCDBLANKDISP		(0) /** 0 Do not blank display
                                    1 Blank display */    

#define _LCDBLINKMODE		(0) /** 0 Display blank during the blink period 
                                 	1 Display alternate displat during blink period 
                                NOTE!! blink mode is ignored if duty is 5 or greater */



#define LCDBCTL_INIT	LCDBCTL = (_LCDBLINKCONTROL<<7) | (_LCDALTMODE<<6) | (_LCDBLANKDISP<<5)  | (_LCDBLINKMODE<<3) | (_LCDBLINKRATE)  
#define LCDC1_INIT      LCDC1 =  (_LCDFRAMEINTERRUPT << 7) | (_LCDWAITMODE<<1) | _LCDSTOPMODE  
#define LCDRVC_INIT		LCDRVC = (_LCDCONTRAST<<7) | (_LVLCONTRAST)    
#define LCDSUPPLY_INIT 	LCDSUPPLY =  (_LCDCPSEL<<7)  | (_LCDHIGHREF<<6)   | (_LCDLOADADJUST<<4) | (_LCDBBYPASS<<2)  | (_LCDVSUPPLY) 
#define LCDEN           LCDC0 |= (1<<7)
#define LCDDISABLE      LCDC0 &= ~(1<<7)
#define LCDC0_INIT		LCDC0 = (_LCDENABLE<<7) | (_LCDCLKSOURCE<<6) | (_LCDCLKPSL<<3)| (_LCDDUTY)  

/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/
void vfnLCD_Init  (void);
void vfnLCD_Clear_Display (void);
void vfnLCD_Set_Display (void);
void vfnLCD_Write_Char (UINT8 u8Value);
void vfnLCD_Write_Msg (UINT8 _POINTER pu8Message);
void vfnLCD_Write_MsgPlace(UINT8 _POINTER pu8Message, UINT8 u8NumChars, UINT8 u8Place); 
/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

#endif /* __LCD_H */ 

	     


