/****************************************************************************************************/
/*
\file          LCD_HAL.c
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		August 2009      
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.		*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end	*/
/* product.                                                                                     	*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "LCD.h"
#include "FslTypes.h"

/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/


/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/


/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/


/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/
UINT8 gu8LCD_CharPosition = 0;
UINT8 gu8RamBuffer[_RAM_BUFFER_SIZE];


/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/** LCD waveform for each alphanumeric */
const UINT8 aPlace [ ] =
{
	CHAR1A,   // LCD4 --- Pin:5
	CHAR1B,   // LCD5 --- Pin:6
	CHAR1C,   // LCD6 --- Pin:7
	CHAR1D,   // LCD7 --- Pin:8
	CHAR2A,   // LCD8 --- Pin:9
	CHAR2B,   // LCD9 --- Pin:10
	CHAR2C,   // LCD10 --- Pin:11
	CHAR2D,   // LCD11 --- Pin:12
	CHAR3A,   // LCD29 --- Pin:44
	CHAR3B,   // LCD30 --- Pin:43
	CHAR3C,   // LCD37 --- Pin:42
	CHAR3D,   // LCD38 --- Pin:41
	CHAR4A,   // LCD39 --- Pin:40
	CHAR4B,   // LCD40 --- Pin:39
	CHAR4C,   // LCD31 --- Pin:38
	CHAR4D,   // LCD32 --- Pin:37
	CHAR5A,   // LCD17 --- Pin:36
	CHAR5B,   // LCD18 --- Pin:35
	CHAR5C,   // LCD19 --- Pin:34
	CHAR5D,   // LCD20 --- Pin:33
	CHAR6A,   // LCD21 --- Pin:32
	CHAR6B,   // LCD35 --- Pin:31
	CHAR6C,   // LCD36 --- Pin:30
	CHAR6D,   // LCD22 --- Pin:29
	CHAR7A,   // LCD12 --- Pin:13
	CHAR7B,   // LCD13 --- Pin:14
	CHAR7C,   // LCD33 --- Pin:15
	CHAR7D,   // LCD34 --- Pin:16
	CHAR8A,   // LCD41 --- Pin:17
	CHAR8B,   // LCD42 --- Pin:18
	CHAR8C,   // LCD43 --- Pin:19
	CHAR8D,   // LCD14 --- Pin:20
	CHAR9A,   // LCD15 --- Pin:21
	CHAR9B,   // LCD16 --- Pin:22
	CHAR9C,   // LCD28 --- Pin:23
	CHAR9D,   // LCD27 --- Pin:24
};


/** Backup mask array */
const UINT8 aBackup [ ] =
{
   _Backupd,
   _Backupc,
   _Backupb,
   _Backupa
};

/** Ascii table */
const byte aAscii [ ] =
{
	_0
	_1
	_2
	_3
	_4
	_5
	_6
	_7
	_8
	_9
	_AllOff
	_SemiColon
	_MinusThan
	_Equal
	_GreaterThan
	_Question
	_AllOn
	_A
	_B
	_C
	_D
	_E
	_F
	_G
	_H
	_I
	_J
	_K
	_L
	_M
	_N
	_O
	_P
	_Q
	_R
	_S
	_T
	_U
	_V
	_X
	_Y
	_Z        

};

/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief  Initialize all the LCD registers on the mcu module   
* \param  void 
* \return void
* \todo     
*/
/****************************************************************************************************/
void vfnLCD_Init(void)
{
	LCDEN;
	LCDC1_INIT;										// Configure  the LCD1 register
	LCDC0_INIT;										// Configure  the LCD0 register   			     
	LCDSUPPLY_INIT;								// Configure  the Voltage Supply 
	LCDRVC_INIT;										 Configure  the Regulated Voltage Control
	LCDBCTL_INIT; 									// Configure  the Blink Control register
	vfnLCD_ConfigureBackplanes(); 			//Enable the characterisitcs of a Backplane
	LCDEN; 												// Enable the LCD module   
}	 


/****************************************************************************************************/
/**
* \brief   Writes one ASCII character on the next alphanumeric. The global variable gu8LCD_CharPosition 
will indicate the index of the next alphanumeric LCD register to write. 
* \param   UINT8 u8Value --- Ascii to write  
* \return   void
*/
/****************************************************************************************************/

void vfnLCD_Write_Char (UINT8 u8Value)
{
          volatile UINT8 *pu8LCDWF = &LCDWF0;
          UINT8 u8Offset=0;
          UINT8 u8Counter ;
          UINT8 *pu8LCDWFCopy = &gu8RamBuffer[0];
 
       /*only ascci character if value not writeable write as @*/
          if (u8Value>='a' && u8Value<='z') u8Value -= ' '; 	 /**UpperCase*/
          if (u8Value<'0' || u8Value >'Z') u8Value = ':';        /**default value as space*/
   
			
		  u8Value = (UINT8)((u8Value-'0')*_LCDTYPE);			/**Find the value at the ascii table*/
          u8Counter = _LCDTYPE;									/**Set the number of waveforms needed to write one alphanumeric*/
          
          while (u8Counter--)
          {
          
             u8Offset = aPlace[gu8LCD_CharPosition];			/**Find the Waveform offset*/                       
             
             pu8LCDWF = &LCDWF0 + u8Offset;						/**Calculate waveform direction */
			 pu8LCDWFCopy = &gu8RamBuffer[0] + u8Offset;		/**Calculate direction for backup*/ 
				
			  *pu8LCDWFCopy &= (UINT8)(aBackup[u8Counter]);	   /**Clear alphanumeric segments*/
			  *pu8LCDWFCopy |= aAscii[u8Value];				   /**Write */
			  *pu8LCDWF = *pu8LCDWFCopy;
              u8Value++;  
              gu8LCD_CharPosition++;               
          }            
  
}


/****************************************************************************************************/
/**
* \brief Writes one string  on the LCD starting at the first alphanumeric,  this function will stop to write if the size of 
the string is bigger than the number of alphanumerics available at the custom glass (_CHARNUM). In case of smaller strings 
than the alphanumerics available the exceeding places will be writing with ASCII spaces.
* \param   UINT8 *pu8Message  --- pointer to the first ascii number of the string  to write   
* \return  void
*/
/****************************************************************************************************/
void  vfnLCD_Write_Msg (UINT8 _POINTER pu8Message)
 {
      UINT8 u8Counter;          
     
     vfnLCD_Home ();						/**Point to the first alphanumeric*/
     u8Counter = _CHARNUM;
     
     
    while (u8Counter--)						
    {
      if (*pu8Message)						/**Write  String*/						 
      {
         vfnLCD_Write_Char (*pu8Message);
         pu8Message ++;
      }
      else								/**Write Blanks*/ 
      {
      	vfnLCD_Write_Char(' ');
      }
    }
      
 }

/****************************************************************************************************/
/**
* \brief  Writes one string  on the LCD starting at the first alphanumeric,this function will stop to write if the size of 
the string is bigger than the number of alphanumeric available at the custom glass (_CHARNUM).
* \param   UINT8 *pu8Message  --- pointer to the first ascii number of the string  to write 
* \param   UINT8 u8NumChars  --- number of characters to write from the string
* \param   UINT8 u8Place  --- alphanumeric number to start writing 
* \return   void
*/
/****************************************************************************************************/
void  vfnLCD_Write_MsgPlace(UINT8 _POINTER pu8Message, UINT8 u8NumChars, UINT8 u8Place)
 {    
    vfnLCD_GoTo(u8Place);						/**Point to the alphanumeric*/
   
    while (u8NumChars--)							/**Write String*/ 
    {
       if (gu8LCD_CharPosition <= _CHARNUM*_LCDTYPE) 
       {
	       vfnLCD_Write_Char (*pu8Message);
	       pu8Message ++;     
       }
    }
 } 

/****************************************************************************************************/
/**
* \brief  Turns on  all the segments of the LCD    
* \param  void 
* \return void
* \todo     
*/
/****************************************************************************************************/
void vfnLCD_Set_Display (void)
{
	SEGMENT1_ON;
	SEGMENT2_ON;
	SEGMENT3_ON;
	SEGMENT4_ON;
	SEGMENT5_ON;
	SEGMENT6_ON;
	SEGMENT7_ON;
	SEGMENT8_ON;
	SEGMENT9_ON;
	SEGMENT10_ON;
	SEGMENT11_ON;
	SEGMENT12_ON;
	SEGMENT13_ON;
	SEGMENT14_ON;
	SEGMENT15_ON;
	SEGMENT16_ON;
	SEGMENT17_ON;
	SEGMENT18_ON;
	SEGMENT19_ON;
	SEGMENT20_ON;
	SEGMENT21_ON;
	SEGMENT22_ON;
	SEGMENT23_ON;
	SEGMENT24_ON;
	SEGMENT25_ON;
	SEGMENT26_ON;
	SEGMENT27_ON;
	SEGMENT28_ON;
	SEGMENT29_ON;
	SEGMENT30_ON;
	SEGMENT31_ON;
	SEGMENT32_ON;
	SEGMENT33_ON;
	SEGMENT34_ON;
	SEGMENT35_ON;
	SEGMENT36_ON;
	SEGMENT37_ON;
	SEGMENT38_ON;
	SEGMENT39_ON;
	SEGMENT40_ON;

}

/****************************************************************************************************/
/**
* \brief  Turns off  all the segments of the LCD    
* \param  void 
* \return void
*/
/****************************************************************************************************/
void vfnLCD_Clear_Display (void)
{
	SEGMENT1_OFF;
	SEGMENT2_OFF;
	SEGMENT3_OFF;
	SEGMENT4_OFF;
	SEGMENT5_OFF;
	SEGMENT6_OFF;
	SEGMENT7_OFF;
	SEGMENT8_OFF;
	SEGMENT9_OFF;
	SEGMENT10_OFF;
	SEGMENT11_OFF;
	SEGMENT12_OFF;
	SEGMENT13_OFF;
	SEGMENT14_OFF;
	SEGMENT15_OFF;
	SEGMENT16_OFF;
	SEGMENT17_OFF;
	SEGMENT18_OFF;
	SEGMENT19_OFF;
	SEGMENT20_OFF;
	SEGMENT21_OFF;
	SEGMENT22_OFF;
	SEGMENT23_OFF;
	SEGMENT24_OFF;
	SEGMENT25_OFF;
	SEGMENT26_OFF;
	SEGMENT27_OFF;
	SEGMENT28_OFF;
	SEGMENT29_OFF;
	SEGMENT30_OFF;
	SEGMENT31_OFF;
	SEGMENT32_OFF;
	SEGMENT33_OFF;
	SEGMENT34_OFF;
	SEGMENT35_OFF;
	SEGMENT36_OFF;
	SEGMENT37_OFF;
	SEGMENT38_OFF;
	SEGMENT39_OFF;
	SEGMENT40_OFF;
}

/****************************************************************************************************/
/**
* \brief  Enable all the pins of the mcu directly connected to the  LCD on use    
* \param  void 
* \return void
* \todo     
*/
/****************************************************************************************************/
void vfnLCD_EnablePins (void)
  {
  	_PEN0();					/** Give to the LCDx the functionality  of a LCD pin*/
  	_PEN1();
  	_PEN2();
  	_PEN3();
    _PEN4();
    _PEN5();
  }
  

/****************************************************************************************************/
/**
* \brief  Enable the function of Backplane and Set the COM number that corresponds to each backplane
* \param  void 
* \return void
* \todo     
*/
/****************************************************************************************************/
  void vfnLCD_ConfigureBackplanes (void)
  {
          
	LCDBPEN0 = 0;
	LCDBPEN1 = 0;
	LCDBPEN2 = 0;
	LCDBPEN3 = 0;
	LCDBPEN4 = 0;
            
	_BPEN0(); 					/**Enable the characterisitcs of a Backplane*/
	_BPEN1();
	_BPEN2();
	_BPEN3();
    _BPEN4();

    _SETCOM1();					/**Give to each backplane previously enbale his COM number*/
	_SETCOM2();  
	_SETCOM3();  
	_SETCOM4();  
}
