;**************************************************************************
;            This file is Freescale Confidential Proprietary
;            (C) Copyright Freescale 2006 ALL RIGHTS RESERVED
;**************************************************************************/
; FUNCTION     : cfg_FLASH                                                */
; PURPOSE      : This function reduces the wait states for internal Flash */
;                  and external Flash at CS0                              */
; WARNING      : This SRAM space was set up by the BAM                    */
;                Registers used: R6,R7 (Location is critical for use in   */
;                 SRAM loads).   For local use: R3,R4,R5,R10              */
;                 Registers R8 and R9 are used in commented example for   */
;                  optimization of external Flash boot.                   */
;                __SRAM_LOAD is set to ADDR(.heap)                        */
;**************************************************************************/


.global cfg_FLASH

.section .text  

; Flash Bus Interface Control Regsiter
.equ FLASH_PFCRP0, 	0xFFFF801C

; flash settings as per reference manual for various frequencies.
.equ _LESS_THAN_25MHZ,    0
.equ _BETWEEN_25_50_MHZ,  0
.equ _GREATER_THAN_50MHZ, 1
; Less or equal than 25MHZ
.equ PFCRP0_25MHZ,	0x00000855
; Greater or equal than 25MHz but Less or equal than 50MHZ
.equ PFCRP0_25_50MHZ,	0x00002955
; Greater than 50MHz
.equ PFCRP0_50MHZ,	0x00004BFD 



cfg_FLASH:
;  Save the Link Register into R3
   mflr  r3  

;********************************
; Prepare registers for SRAM load usage
; R6 holds address of FLASH_BIUCR

    	lis   r6, FLASH_PFCRP0@h     		; Load address of FLASH_BIUCR into R6
    	ori   r6, r6, FLASH_PFCRP0@l 	
.if _LESS_THAN_25MHZ
; R7 holds FLASH_PFCRP0 settings
    	lis   r7, PFCRP0_25MHZ@h     		; Store Flash BIU settings
    	ori   r7, r7, PFCRP0_25MHZ@l
.endif
.if _BETWEEN_25_50_MHZ
; R7 holds FLASH_PFCRP0 settings
    	lis   r7, PFCRP0_25_50MHZ@h     		; Store Flash BIU settings
    	ori   r7, r7, PFCRP0_25_50MHZ@l
.endif
.if _GREATER_THAN_50MHZ
; R7 holds FLASH_PFCRP0 settings
    	lis   r7, PFCRP0_50MHZ@h     		; Store Flash BIU settings
    	ori   r7, r7, PFCRP0_50MHZ@l
.endif

;.section .text
;*********************************************************************************
; This section configures the FLASH_PFCRP0 register with predefined PFCRP0 values
;*********************************************************************************
    stw   r7, 0(r6)    ; Reduce internal Flash wait states in the FLASH_BIUCR
   ;isync
    blr




            

