/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file       Sci_Cfg.c
  \brief      This file contains all Port Configuration Structures to be used \n
              as virtual sci channels.  
  \author     Freescale Semiconductor
  \author     r01160
  \author     Guadalajara Applications Laboratory RTAC Americas
  \version    0.1
  \date       8/19/2008 12:40:02 PM
    
  * History:
  
*/
 #include "Emsci_Cfg.h"
 #include "Emios.h"
 #include "Main.h"

#pragma section const_type ".configuration_structs"
__declspec(section ".rodata")

 /****************** Configuration Parameters *******************/
 /*                                                             */
 /*------------------- TX Parameters ---------------------------*/
 /* 1) Symbolic Emualted SCI Name                               */
 /* 2) Emios Channel assigned to handle TX communications       */
 /* 3) Emios Interrupt vector number (TX)                       */
 /* 4) Port pin number of the Emios channel (TX)                */
 /* 5) This parameter set the correct value to SIU_PAD register */
 /*    to enable the Emios functionality of the pin.            */
 /* 6) Function which TX routine will jump into once a complete */
 /*    byte has been transfer.                                  */
 /*                                                             */
 /*------------------- RX Parameters ---------------------------*/
 /* 7) Emios Channel assigned to handle RX communications       */
 /* 8) Emios Interrupt vector number (RX)                       */
 /* 9) Port pin number of the Emios channel (RX)                */
 /*10) This parameter set the correct value to SIU_PAD register */
 /*    to enable the Emios functionality of the pin.            */
 /*11) Function which RX routine will jump into once a complete */
 /*    byte has receive it correctly                            */
 /***************************************************************/
 const Emsci_ConfigType Emsci_ChannelConfig[EMSCI_CHANNELS] =
 {
   {
   	 EMSCI0,
   	 EMIOS_CH0,
     58,
     32,
     FNC_1,
     &TxInterrupt,
     EMIOS_CH1,
     59,
     33,
     FNC_1,
     &RxInterrupt
   }
  };

#pragma section code_type ".text"

