/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	emsci.h
  \brief    	Initialization, Transmit and Receive function declarations. \n
              Contains also macro definitions for Tx & Rx algorithms. 
  \author   	Freescale Semiconductor
  \author     R01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version    0.1
  \date     	9/15/2008 11:26:35 AM
  
    * History:
  
*/
#ifndef _EMSCI_H_
 #define _EMSCI_H_
 
 /*------- MISRA violation to rule 19.11: All macro identifiers shall be defined before use, except in */
 /*------- #ifdef and #ifndef preprocessor definitions                                                 */
 /** If Pwm Error Layer Enabled, validate errors */ 
 #if (EMSCI_ERROR_DETECT == ON)   
   #include "Emsci_ReportError.h"
 #endif  
    
 /** Includes all SCI configuration paramters */
 #include "Emsci_Cfg.h"
 /** Access all Emios functions needed to configure emsci channels */
 #include "Emios.h"

  
/*---------- Extern variables-----------------*/

/*---------- Function Prototypes -------------*/
/** These definitions shall include as many functions in the code as \n
    emulated SCI channels will requiered                                  */
#if (EMSCI_CHANNELS == 1)
   extern void vfn_Tx_Fnc_1(void);
   extern void vfn_Rx_Fnc_1(void);
#endif
#if (EMSCI_CHANNELS > 1)
   extern void vfn_Tx_Fnc_2(void);
   extern void vfn_Rx_Fnc_2(void);
#endif
#if (EMSCI_CHANNELS > 2)
   extern void vfn_Tx_Fnc_3(void);
   extern void vfn_Rx_Fnc_3(void);
#endif
#if (EMSCI_CHANNELS > 3)
  extern void vfn_Tx_Fnc_4(void);
  extern void vfn_Rx_Fnc_4(void);
#endif

void vfnemsci_init(const Emsci_ConfigType *sEmsciPtr);

#endif