/****************************************************************************************************/
/**
Copyright (c) 2008 Freescale Semiconductor
Freescale Confidential Proprietary
\file       Pit.c
\brief      This file handles all Pwm & Scheduler timebases
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     R01160
\version    0.1
\date       5/23/2008 
*/
/****************************************************************************************************/
/*                                                                                                  */
/* All software, source code, included documentation, and any implied know-how are property of      */
/* Freescale Semiconductor and therefore considered CONFIDENTIAL INFORMATION.                       */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY.                      */
/*                                                                                                  */
/* All Confidential Information remains the property of Freescale Semiconductor and will not be     */
/* copied or reproduced without the express written permission of the Discloser, except for copies  */
/* that are absolutely necessary in order to fulfill the Purpose.                                   */
/*                                                                                                  */
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.     */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end    */
/* product.                                                                                         */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/
 #include "Pit.h" 
 
 /** Scheduler Callback type */
 Pit_CallbackType Pit_CallBack_1 = NULL_PTR;
 Pit_CallbackType Pit_CallBack_2 = NULL_PTR;
 Pit_CallbackType Pit_CallBack_3 = NULL_PTR;
 Pit_CallbackType Pit_CallBack_4 = NULL_PTR;
  
 /*--------------------------------------------------------------------------------------*/ 
 /**
 * \brief     Configure desired Pit channel to operate with a resolution \n
              frequency of 0.5% from the original operation frequency,   \n
              Pit timer setup to generate the desired Pwm period and Pwm \n
              parameters.
 * \author    R01160
 * \param     Pit Channel to be used & Period Tick value
 * \return    none
 * \todo
 * \warning   Configured PIT channel when using this function will NOT be used \n
              by another resource in the program flow, otherwise a wrong Pwm   \n
              frequency might be generated.
 */  
 void vfnPit_Init(uint8_t u8PitChannel, uint32_t u32Period)
 {
     PIT_CTRL = (uint32_t)0x00;                                          /* MDIS = 0 - Enable Module */
     PIT_LOAD_VALUE(u8PitChannel, u32Period);
   #if Z0_CORE == ON 
     INT_PSR((uint8_t)((uint8_t)PIT_BASE_OFFSET + (uint8_t)u8PitChannel) ,(uint8_t)0xC1); /* Raise Pit Channel Priority */    
   #else
     INT_PSR((uint8_t)((uint8_t)PIT_BASE_OFFSET + (uint8_t)u8PitChannel) ,(uint8_t)1);    /* Raise Pit Channel Priority */                               
   #endif
     PIT_FLG      = (PIT_FLG    | (uint32_t)u8PitChannel); /* Clear Interrupt flag to avoid false triggers   */
     PIT_INTEN    = (PIT_INTEN  | (uint32_t)u8PitChannel); /* Enable Pit Interrupts                          */
     PIT_INTSEL   = (PIT_INTSEL | (uint32_t)u8PitChannel); /* Generate Hw interrupt instead of DMA Interrupt */
     //vfnPit_Set_Callback_Fnc(vfnAdc_Collect_Results);      /* Set function to call once Pit interrupt occurs */
     PIT_EN       = (PIT_EN     | (uint32_t)u8PitChannel); /* Enable PIT x Channel                           */
 }
 
 /*--------------------------------------------------------------------------------------*/ 
 /**
 * \brief     Sets the function to which the emios interrupt shall \n
              jump once interrupt occurs.
 * \author    R01160
 * \param     Emios_CallbackType - Callback type definition
 * \return    none
 * \warning   This function will skip any null pointer parameter passed \n
              as a input parameter.
 */  
void vfnPit_Set_Callback_Fnc(Pit_CallbackType Callback_Fnc)
{
	 #if (ADC_FLTR_ERROR_DETECT == ON)          /* If Pwm Error Layer Enabled validate errors */	
      if(Callback_Fnc == NULL_PTR)        /* Pwm module already initilized?             */     
      {
         vfnAdc_Filter_Report_Error(ADC_FLTR_CALLBACK_PTR_ID,ADC_FLTR_E_FNC_CALLBACK_UNINIT); /* Report None initilized module */
      }      
      else
      {
   #endif 
   
     /* Assign Function pointer to call when emios interrupt occurs */
     Pit_CallBack_1 = Callback_Fnc;  
   
     #if (ADC_FLTR_ERROR_DETECT == ON)      
      }
     #endif 
   
}

/*--------------------------------------------------------------------------------------*/ 
 /**
 * \brief     Enables a particular PIT channel timer.
 * \author    R01160
 * \param     PIT Channel
 * \return    none
 */
 void vfnPIT_Enable_Channel(uint8_t u8PitChannel)
 {
    PIT_EN = (PIT_EN | (uint32_t)u8PitChannel); /* Enables PIT x Channel     */	
 }
 
/*--------------------------------------------------------------------------------------*/ 
 /**
 * \brief     Stops a particular PIT channel timer.
 * \author    R01160
 * \param     PIT Channel
 * \return    none
 */
 void vfnPIT_Disable_Channel(uint8_t u8PitChannel)
 {
   /** Retrieves the current state of all PIT Channels */
   uint32_t u32PIT_Channel_Status;
   
   u32PIT_Channel_Status = (uint32_t)PIT_EN;
   //u32PIT_Channel_Status = (uint32_t)((uint32_t)u8PitChannel 
   PIT_EN       = (PIT_EN     | (uint32_t)u8PitChannel); /* Enable PIT x Channel     */	
 }
 /*--------------------------------------------------------------------------------------*/
/**
 * \brief     Handles the timing for the generation of all Pwm signals
 * \author    R01160
 * \param     none
 * \return    none
 * \warning  IF USER DECIDE TO USE OTHER INTERRUPT VECTOR RATHER THAN VECTOR 149 (PIT CH1) \n
              MUST BE MANDATORY TO DECLARE THIS DIFFERENT VECTOR INTO VECTOR TABLE.
 */
/*--------------------------------------------------------------------------------------*/
 void vfnPit_Ch1_Isr(void)
 {
   if (PIT_FLG_TIF1 == 1)   /* Is current interrupt flag valid?*/
   {  
     Pit_CallBack_1();
   }
   
   /* Clear the real time interrupt flag */
   PIT_FLG = (PIT_FLG | ((uint32_t)1<<(uint32_t)1));  /* Clear channel's flag */ 
 }
 
 
 