/****************************************************************************************/
/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	Adc_Cfg.c
  \brief    	This file contains all ADC configuration parameters
  \author   	Freescale Semiconductor
  \author     r01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version    0.1
  \date     	6/27/2008 6:22:51 PM
  
  * History:
  
*/
/****************************************************************************************/
 /** ADC Configuration parameters */
 #include "Adc_Cfg.h"
 
 
uint32_t au32Adc_Config_Params[MAX_CONFIG_PARAMS] =
{
   /* ADC PS = 8 -> ADC Clock = 8 MHz, ADC0 Enabled, Write to Configuration Control Register */
   ADC_CONFIGURATION_1,
   /* ADC PS = 16 -> ADC Clock = 4 MHz, ADC0 Enabled, Write to Configuration Control Register */
   ADC_CONFIGURATION_2
};
 
uint32_t au32Adc_Conversion_Params[MAX_CMDS_ALLOWED] =
{
   /* Message Tag = RFIFO 0, 8 Sampling Cycles, Format = unsigned right justification */
    ADC_CONV_CMD_1_FIFO_0,
   /* Message Tag = RFIFO 0, 8 Sampling Cycles, Format = unsigned right justification, EOQ bit enabled */
    ADC_CONV_CMD_2_FIFO_0_EOQ,
   /* Message Tag = RFIFO 1, 8 Sampling Cycles, Format = unsigned right justification */
    ADC_CONV_CMD_3_FIFO_0,
   /* Message Tag = RFIFO 1, CAL = 1, 8 Sampling Cycles, Format = unsigned right justification */
    ADC_CONV_CMD_4_FIFO_1
};
 
/** This array holds the ADC channels to be configured as inputs */ 
uint8_t au8Adc_Port_Pins[MAX_ADC_CHANNELS] = 
{
  ADC_CHANNEL_0,
  ADC_CHANNEL_1,
  ADC_CHANNEL_2,
  ADC_CHANNEL_3
};