/****************************************************************************************************/
/**
Copyright (c) 2008 Freescale Semiconductor
Freescale Confidential Proprietary
\file       Adc_Filter.h
\brief      This file contains all Configuration parameters of ADC Filter driver
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     R01160
\version    0.1
\date       11/23/2008 
*/
/****************************************************************************************************/
/*                                                                                                  */
/* All software, source code, included documentation, and any implied know-how are property of      */
/* Freescale Semiconductor and therefore considered CONFIDENTIAL INFORMATION.                       */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY.                      */
/*                                                                                                  */
/* All Confidential Information remains the property of Freescale Semiconductor and will not be     */
/* copied or reproduced without the express written permission of the Discloser, except for copies  */
/* that are absolutely necessary in order to fulfill the Purpose.                                   */
/*                                                                                                  */
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.     */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end    */
/* product.                                                                                         */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/
#ifndef __ADC_FLTR_H__
 #define __ADC_FLTR_H__
   
   #include "Adc.h"
   #include "Adc_Filter_ReportError.h"
   #include "AdcFltr_Cfg.h"
   /*------------- Function Like Macros ---------------------------------------------------*/
    /** Save new samples, Trigger eDMA module and reset the ADC channel counter  */
   #define AVERAGE_RELOAD_SAMPLE_BUFFER()     i8NumberOfChannels = (ATDFLTR_0_AVERAGECHANNELS - 1);     \
				                              ADC_CONVERT_AND_READ_EDMA_FLG();    	                    \
				                              vfnAdc_Average((tAdcFltr_FilterStruct*)AdcFltrCntl_t)             


   /*------------- Extern Variables  -----------------------------------------------------*/
    extern tAdcFltr_FilterStruct *AdcFltrCntl_t;
   

   /*------------- Function Prototypes ---------------------------------------------------*/
   extern void vfnADC_Start_Average(void);
   extern void vfnADC_Stop_Average(void);
   extern void vfnAdc_Sample_Acquire(void);
   extern void vfnFilter_1_End(void);
   extern void vfnAdc_Average(tAdcFltr_FilterStruct* filter);
   extern void vfnAdcFltr_Init(tAdcFltr_FilterStruct* filter);   
 #endif
 