/****************************************************************************************************/
/**
Copyright (c) 2008 Freescale Semiconductor
Freescale Confidential Proprietary
\file       Pit.c
\brief      This file handles all Pwm & Scheduler timebases
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     R01160
\version    0.1
\date       5/23/2008 
*/
/****************************************************************************************************/
/*                                                                                                  */
/* All software, source code, included documentation, and any implied know-how are property of      */
/* Freescale Semiconductor and therefore considered CONFIDENTIAL INFORMATION.                       */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY.                      */
/*                                                                                                  */
/* All Confidential Information remains the property of Freescale Semiconductor and will not be     */
/* copied or reproduced without the express written permission of the Discloser, except for copies  */
/* that are absolutely necessary in order to fulfill the Purpose.                                   */
/*                                                                                                  */
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.     */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end    */
/* product.                                                                                         */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/
#include "Derivative.h"
#include "Scheduler.h"
#include "Adc.h"
#include "Mcu.h"
#include "Pit.h"
#include "Adc_Filter.h"


extern uint32_t EXCEPTION_HANDLERS_P1;   // defined in the LCF
extern const uint32_t IntcIsrVectorTable_p1[];


void initINTC_Z0(void) 
{	
  INTC.MCR.B.HVEN_PRC1 = 0;   /* MPC551x PRC1: initialize for SW vector mode */
  INTC.MCR.B.VTES_PRC1 = 0;   /* MPC551x PRC1: default vector table 4B offsets*/
  INTC.IACKR_PRC1.R = (uint32_t) &IntcIsrVectorTable_p1[0]; /* MPC551x: ISR table base */
}

/* Load z0's IVPR from the value provided in the LCF */
asm void initIVPR_z0(void) 
{
  lis r3, EXCEPTION_HANDLERS_P1@ha
  ori r3, r3, EXCEPTION_HANDLERS_P1@l  
  mtivpr r3  
}

void enableIrq_z0(void) 
{
  INTC.CPR_PRC1.B.PRI = 0;   // Lower INTC PRC1 current priority
  asm(" wrteei 1");          // and enable external interrupts
}

void vfnAdc_Init_Port_Pins(void)
{
   uint8_t u8PortNo = 0;
   	
  	for(u8PortNo = MAX_ADC_CHANNELS ; u8PortNo > 0 ; u8PortNo-- )
  	{
  	    SIU.PCR[au8Adc_Port_Pins[u8PortNo - 1]].R = (uint16_t)0x0500;
  	}
}

void main_p1(void) 
{
      
   SIU.PCR[16].R = 0x0200;
   SIU.PCR[17].R = 0x0200;
   SIU.PCR[18].R = 0x0200;
   SIU.PCR[19].R = 0x0200;
   SIU.PCR[20].R = 0x0200;
   
   AdcFltrCntl_t = &sATD0;
   /* Initialise Scheduler handling variables */
   gu8SleepModeEnabled = 0;
   gu8Scheduler_Ctrl   = 0;
   gu8Scheduler_Flag   = 0;
   
   initINTC_Z0();        /* Enable Software Interrupts on Z0                */
   initIVPR_z0();
   vfnedma_init();       /* Initialize DMA engine to handle ADC conversions */
   vfndma_config_fcn();  /* Configures TCD channels 0 & 1                   */
   vfnAdc_Init_Port_Pins();   /* Initialize ADC pins                        */
   vfnAdc_Init();        /* Initialize ADC0 module with predefined parameters from Adc_Cfg.h file */
   vfnInitAdc_Calibration(ADC_FIFO_BUFFER); /* Start ADC0 Calibration       */
   vfnAdcFltr_Init((tAdcFltr_FilterStruct*) AdcFltrCntl_t);
   vfnScheduler_Init();  /* Configure Scheduler Time Base                   */
   vfnStart_Scheduler(); /* Start Scheduler Execution                       */
   enableIrq_z0();       /* Enable Interrupts                               */
   
   
  
 while (gu8SleepModeEnabled == 0)
  {
       if ((gu8Scheduler_Flag & (uint8_t)0x01) == (uint8_t)0x01)
        {
            /*-- Allow 10 ms periodic tasks to be executed --*/
            EXECUTE_10MS_TASKS(); 
                
            /* Scheduled tasks finished, clear control flag */
            gu8Scheduler_Flag = (uint8_t)0x00;
        }
        else
        { 
            if ((gu8Scheduler_Flag & (uint8_t)0x02) == (uint8_t)0x02)
            {    
               
                /*-- Allow 20 ms periodic tasks to be executed --*/
                 EXECUTE_20MS_TASKS(); 
                  
	       	    /* Scheduled tasks finished, clear control flag */
                gu8Scheduler_Flag = (uint8_t)0x00;
            }
            else
            { 
                if ((gu8Scheduler_Flag & (uint8_t)0x04) == (uint8_t)0x04)
                {
                    /*-- Allow 40 ms periodic tasks to be executed --*/
                     EXECUTE_40MS_TASKS(); 
                   
                    /* Scheduled tasks finished, clear control flag */
                    gu8Scheduler_Flag = (uint8_t)0x00;
                }
                else
                {     
                    if ((gu8Scheduler_Flag & (uint8_t)0x08) == (uint8_t)0x08)
                    {
                        /*-- Allow 80 ms group A periodic tasks to be executed --*/
                         EXECUTE_80MS_A_TASKS();
		            	/* Scheduled tasks finished, clear control flag */
                        gu8Scheduler_Flag = (uint8_t)0x00;
                    }
                    else
                    {     
                        if ((gu8Scheduler_Flag & (uint8_t)0x10) == (uint8_t)0x10)
                        {
                            /*-- Allow 80 ms group B periodic tasks to be executed --*/
			                
                            /* Scheduled tasks finished, clear control flag */
                            gu8Scheduler_Flag = (uint8_t)0x00;                 
                        }
                    }
                }
            }
        }   
   }
}

void emiosCh0ISR(void)
{
  SIU.GPDO[16].R ^= 1; 
  EMIOS.CH[0].CSR.B.FLAG=1;   /* Clear channel's flag */  
}
void vfnPit_Channel_1_Isr(void)
{
   SIU.GPDO[16].R ^= 1;
   /* Clear the real time interrupt flag */
   PIT_FLG = (PIT_FLG | PIT_CH_1);  /* Clear channel's flag */ 
}
