#include "lcd.h"
#include "lcd_config.h"
#include "MC9S08LG32.h"

unsigned int milliseconds = 0;

/////////////////////////////////////////////////////////////////////////////////////////
// Variables
/////////////////////////////////////////////////////////////////////////////////////////

const struct lcd_char_segs lcd_char_table[] = {

  // ' ' (Space)
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // '"' (Quotation Mark)
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // ''' (Apostrophe)
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // '(' (Left Parenthesis)
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // ')' (Right Parenthesis)
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // '*' (Asterisk)
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // '+' (Plus Sign)
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // ',' (Comma)
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // '-' (Minus Sign)
  {
  LCD_SEG_G,
  LCD_SEG_NONE,
  LCD_SEG_G,
  LCD_SEG_NONE
  },

  // '.' (Period)
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // '/' (Slash)
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // '0'
  {
  LCD_SEG_E|LCD_SEG_F,
  LCD_SEG_A|LCD_SEG_B|LCD_SEG_C|LCD_SEG_D,
  LCD_SEG_SPEED_C|LCD_SEG_SPEED_B,
  LCD_SEG_SPEED_A|LCD_SEG_SPEED_F|LCD_SEG_SPEED_E|LCD_SEG_SPEED_D
  },

  // '1'
  {
  LCD_SEG_NONE,
  LCD_SEG_B|LCD_SEG_C,
  LCD_SEG_SPEED_B|LCD_SEG_SPEED_C,
  LCD_SEG_NONE
  },

  // '2'
  {
  LCD_SEG_G|LCD_SEG_E,
  LCD_SEG_A|LCD_SEG_B|LCD_SEG_D,
  LCD_SEG_SPEED_B|LCD_SEG_SPEED_G,
  LCD_SEG_SPEED_A|LCD_SEG_SPEED_E|LCD_SEG_SPEED_D
  },

  // '3'
  {
  LCD_SEG_G,
  LCD_SEG_A|LCD_SEG_B|LCD_SEG_C|LCD_SEG_D,
  LCD_SEG_SPEED_B|LCD_SEG_SPEED_G|LCD_SEG_SPEED_C,
  LCD_SEG_SPEED_A|LCD_SEG_SPEED_D
  },

  // '4'
  {
  LCD_SEG_F|LCD_SEG_G,
  LCD_SEG_C|LCD_SEG_B,
  LCD_SEG_SPEED_B|LCD_SEG_SPEED_G|LCD_SEG_SPEED_C,
  LCD_SEG_SPEED_F
  },

  // '5'
  {
  LCD_SEG_F|LCD_SEG_G,
  LCD_SEG_A|LCD_SEG_C|LCD_SEG_D,
  LCD_SEG_SPEED_G|LCD_SEG_SPEED_C,
  LCD_SEG_SPEED_A|LCD_SEG_SPEED_F|LCD_SEG_SPEED_D
  },

  // '6'
  {
  LCD_SEG_F|LCD_SEG_G|LCD_SEG_E,
  LCD_SEG_A|LCD_SEG_C|LCD_SEG_D,
  LCD_SEG_SPEED_G|LCD_SEG_SPEED_C,
  LCD_SEG_SPEED_A|LCD_SEG_SPEED_F|LCD_SEG_SPEED_D|LCD_SEG_SPEED_E
  },

  // '7'
  {
  LCD_SEG_NONE,
  LCD_SEG_A|LCD_SEG_B|LCD_SEG_C,
  LCD_SEG_SPEED_B|LCD_SEG_SPEED_C,
  LCD_SEG_SPEED_A
  },

  // '8'
  {
  LCD_SEG_E|LCD_SEG_F|LCD_SEG_G,
  LCD_SEG_A|LCD_SEG_B|LCD_SEG_C|LCD_SEG_D,
  LCD_SEG_SPEED_B|LCD_SEG_SPEED_G|LCD_SEG_SPEED_C,
  LCD_SEG_SPEED_A|LCD_SEG_SPEED_F|LCD_SEG_SPEED_D|LCD_SEG_SPEED_E
  },

  // '9'
  {
  LCD_SEG_F|LCD_SEG_G,
  LCD_SEG_A|LCD_SEG_B|LCD_SEG_C|LCD_SEG_D,
  LCD_SEG_SPEED_B|LCD_SEG_SPEED_G|LCD_SEG_SPEED_C,
  LCD_SEG_SPEED_A|LCD_SEG_SPEED_F|LCD_SEG_SPEED_D
  },

  // ':'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // '=' (Equal Sign)
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'A'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'B'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'C'
  {
  LCD_SEG_F|LCD_SEG_E,
  LCD_SEG_A|LCD_SEG_D,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'D'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'E'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'F'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'G'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'H'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'I'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'J'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },
  
  // 'K'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'L'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'M'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'N'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'O'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'P'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'Q'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'R'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'S'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'T'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'U'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'V'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'W'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'X'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'Y'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // 'Z'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // '[' (Left Bracket)
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // '\' (Backslash)
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // ']' (Right Bracket)
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // '^' (Exponent)
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // '_' (Underline)
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // '|' (Vertical Bar)
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // Test
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE,
  LCD_SEG_NONE
  }
  
};

unsigned char LCDDigitPins[] = {20, 18, 16, 3, 5, 7, 9, 11, 13};

unsigned char *pLCDPIN_1, *pLCDPIN_2;

void Delay(unsigned int num_milliseconds)
{
  milliseconds = 0;
  while(milliseconds < num_milliseconds);

}

void LCDClearAllSegments()
{
  LCD_ALLFP_OFF_4XMODE
}

unsigned char LCDFindChar(unsigned char character)
{
  if(character >= '0' && character <= '9')
    return(LCD_CHAR_0+character-'0');
  else if(character == 'C')
    return(LCD_CHAR_C);
  else
    return(LCD_CHAR_TEST);
  
}

void LCDGetLCDPin(unsigned char digit)
{
  switch(digit)
  {
    case 1:
      pLCDPIN_1 = &LCDPIN21;
      pLCDPIN_2 = &LCDPIN22;
      break;
    case 2:
      pLCDPIN_1 = &LCDPIN19;
      pLCDPIN_2 = &LCDPIN20;
      break;
    case 3:
      pLCDPIN_1 = &LCDPIN17;
      pLCDPIN_2 = &LCDPIN18;
      break;
    case 4:
      pLCDPIN_1 = &LCDPIN4;
      pLCDPIN_2 = &LCDPIN5;
      break;
    case 5:
      pLCDPIN_1 = &LCDPIN6;
      pLCDPIN_2 = &LCDPIN7;
      break;
    case 6:
      pLCDPIN_1 = &LCDPIN8;
      pLCDPIN_2 = &LCDPIN9;
      break;
    case 7:
      pLCDPIN_1 = &LCDPIN10;
      pLCDPIN_2 = &LCDPIN11;
      break;
    case 8:
      pLCDPIN_1 = &LCDPIN12;
      pLCDPIN_2 = &LCDPIN13;
      break;
    case 9:
      pLCDPIN_1 = &LCDPIN14;
      pLCDPIN_2 = &LCDPIN15;
      break;
  }
}

void LCDPutChar(unsigned char character, unsigned char digit)
{
  unsigned char table_pos, mytempreg;

  if( (digit == 0) || (digit > (NUM_DIGITS+NUM_DIGITS_SPEED)) )
    return;

  table_pos = LCDFindChar(character);
  
  if(table_pos == LCD_CHAR_TEST)
  {
    //character not supported
    return;
  }
  
  LCDGetLCDPin(digit);

  if(digit > NUM_DIGITS_SPEED)
  {
    mytempreg = lcd_char_table[table_pos].FGE;
  }
  else
  {
    mytempreg = lcd_char_table[table_pos].SPEED_CGB;
  }
  *(pLCDPIN_1) |= mytempreg;

  if(digit > NUM_DIGITS_SPEED)
  {
    mytempreg = lcd_char_table[table_pos].ABCD;
  }
  else
  {
    mytempreg = lcd_char_table[table_pos].SPEED_DEFA;
  }
  *(pLCDPIN_2) |= mytempreg;
}

void LCDGlowSegment(enum symbol symb, unsigned char level)
{

  switch(symb)
  {
  
    case OIL:
      LCDPIN27 |= LCD_SEG_S1;
      break;
    case COLD:
      LCDPIN27 |= LCD_SEG_S2;
      break;
    case HOT:
      LCDPIN27 |= LCD_SEG_S4;
      break;
    case THERMOMETER:
      LCDPIN27 |= LCD_SEG_S3;
      break;
    case BATTERY:
      LCDPIN26 |= LCD_SEG_S1;
      break;
    case SERVICE:
      LCDPIN23 |= LCD_SEG_S3;
      break;
    case FREESCALE:
      LCDPIN23 |= LCD_SEG_S4;
      break;
    case FUELBORDER:
      LCDPIN2  |= LCD_SEG_S4; //fuel border
      LCDPIN2  |= LCD_SEG_S2; //fuel tank
      LCDPIN1  |= LCD_SEG_S4; //fuel level measure
      break;
    case HVACFAN:
      LCDPIN26 |= LCD_SEG_S2;
      break;
    case HVACAIRFLOW:
      LCDPIN24 |= LCD_SEG_S2;
      break;
    case HVACAIRFLOWSINGLE:
      LCDPIN24 |= LCD_SEG_S3;
      break;
    case HVACAIRFLOWDUAL:
      LCDPIN24 |= LCD_SEG_S4;
      break;
    case HVACAIRFLOWWINDOW:
      LCDPIN23 |= LCD_SEG_S2;
      break;
    case TRIP:
      LCDPIN3  |= LCD_SEG_S1;
      break;
    case TRIPA:
      LCDPIN8  |= LCD_SEG_SIGN;
      break;
    case TRIPB:
      LCDPIN6  |= LCD_SEG_SIGN;
      break;
    case KMLEFT:
      LCDPIN3  |= LCD_SEG_S2;
      LCDPIN4  |= LCD_SEG_SIGN;
      break;
    case MILEAGE:
      LCDPIN3  |= LCD_SEG_S3;
      break;
    case ODO:
      LCDPIN3  |= LCD_SEG_S4;
      break;
    case AM:
      LCDPIN16 |= LCD_SEG_S2;
      break;
    case PM:
      LCDPIN16 |= LCD_SEG_S1;
      break;
    case KMPL:
      LCDPIN16 |= LCD_SEG_S3;
      break;
    case KM_ODO:
      LCDPIN16 |= LCD_SEG_S4;
      break;
    case DEGREE:
      LCDPIN21 |= LCD_SEG_SIGN;
      break;
    case COL:
      LCDPIN12 |= LCD_SEG_SIGN;
      break;
    case DP:
      LCDPIN14 |= LCD_SEG_SIGN;
      break;
    case CLOCK:
      LCDPIN10 |= LCD_SEG_SIGN;
      break;
    case TEMPERATURE:
      LCDPIN19 |= LCD_SEG_SIGN;
      break;
    case KMPH:
      LCDPIN17 |= LCD_SEG_SIGN;
      break;
    case FUELLEVEL:
      switch(level)
      {
        case 8:
          LCDPIN1  |= LCD_SEG_S1;
        case 7:
          LCDPIN1  |= LCD_SEG_S2;
        case 6:
          LCDPIN1  |= LCD_SEG_S3;
        case 5:
          LCDPIN28 |= LCD_SEG_S1;
        case 4:
          LCDPIN28 |= LCD_SEG_S2;
        case 3:
          LCDPIN28 |= LCD_SEG_S3;
        case 2:
          LCDPIN28 |= LCD_SEG_S4;
        case 1:
          LCDPIN2  |= LCD_SEG_S3;
      }
      break;
    case BATTLEVEL:
      switch(level)
      {
        case 4:
          LCDPIN25 |= LCD_SEG_S4;
        case 3:
          LCDPIN25 |= LCD_SEG_S3;
        case 2:
          LCDPIN25 |= LCD_SEG_S2;
        case 1:
          LCDPIN25 |= LCD_SEG_S1;
      }
  }
  
}

void LCDClearSegment(enum symbol symb)
{
  switch(symb)
  {
    case OIL:
      LCDPIN27 &= ~LCD_SEG_S1;
      break;
    case COLD:
      LCDPIN27 &= ~LCD_SEG_S2;
      break;
    case HOT:
      LCDPIN27 &= ~LCD_SEG_S4;
      break;
    case THERMOMETER:
      LCDPIN27 &= ~LCD_SEG_S3;
      break;
    case BATTERY:
      LCDPIN26 &= ~LCD_SEG_S1;
      break;
    case SERVICE:
      LCDPIN23 &= ~LCD_SEG_S3;
      break;
    case FREESCALE:
      LCDPIN23 &= ~LCD_SEG_S4;
      break;
    case FUELBORDER:
      LCDPIN2  &= ~LCD_SEG_S4;
      LCDPIN2  &= ~LCD_SEG_S2;
      LCDPIN1  &= ~LCD_SEG_S4;
      break;
    case HVACFAN:
      LCDPIN26 &= ~LCD_SEG_S2;
      break;
    case HVACAIRFLOW:
      LCDPIN24 &= ~LCD_SEG_S2;
      break;
    case HVACAIRFLOWSINGLE:
      LCDPIN24 &= ~LCD_SEG_S3;
      break;
    case HVACAIRFLOWDUAL:
      LCDPIN24 &= ~LCD_SEG_S4;
      break;
    case HVACAIRFLOWWINDOW:
      LCDPIN23 &= ~LCD_SEG_S2;
      break;
    case TRIP:
      LCDPIN3  &= ~LCD_SEG_S1;
      break;
    case TRIPA:
      LCDPIN8  &= ~LCD_SEG_SIGN;
      break;
    case TRIPB:
      LCDPIN6  &= ~LCD_SEG_SIGN;
      break;
    case KMLEFT:
      LCDPIN3  &= ~LCD_SEG_S2;
      LCDPIN4  &= ~LCD_SEG_SIGN;
      break;
    case MILEAGE:
      LCDPIN3  &= ~LCD_SEG_S3;
      break;
    case ODO:
      LCDPIN3  &= ~LCD_SEG_S4;
      break;
    case AM:
      LCDPIN16 &= ~LCD_SEG_S2;
      break;
    case PM:
      LCDPIN16 &= ~LCD_SEG_S1;
      break;
    case KMPL:
      LCDPIN16 &= ~LCD_SEG_S3;
      break;
    case KM_ODO:
      LCDPIN16 &= ~LCD_SEG_S4;
      break;
    case DEGREE:
      LCDPIN21 &= ~LCD_SEG_SIGN;
      break;
    case COL:
      LCDPIN12 &= ~LCD_SEG_SIGN;
      break;
    case DP:
      LCDPIN14 &= ~LCD_SEG_SIGN;
      break;
    case CLOCK:
      LCDPIN10 &= ~LCD_SEG_SIGN;
      break;
    case TEMPERATURE:
      LCDPIN19 &= ~LCD_SEG_SIGN;
      break;
    case KMPH:
      LCDPIN17 &= ~LCD_SEG_SIGN;
      break;
    case FUELLEVEL:
      LCDPIN1  &= ~(LCD_SEG_S1|LCD_SEG_S2|LCD_SEG_S3);
      LCDPIN28 = 0;
      LCDPIN2 &= ~(LCD_SEG_S3);
      break;
    case BATTLEVEL:
      LCDPIN25 = 0;
  }
}

void LCDClearDigit(unsigned char digit)
{
  switch(digit)
  {
    case 1:
      LCDPIN21 &= ~MASK_SPEED_CGB;
      LCDPIN22 &= ~MASK_SPEED_DEFA;
      break;
    case 2:
      LCDPIN19 &= ~MASK_SPEED_CGB;
      LCDPIN20 &= ~MASK_SPEED_DEFA;
      break;
    case 3:
      LCDPIN17 &= ~MASK_SPEED_CGB;
      LCDPIN18 &= ~MASK_SPEED_DEFA;
      break;
          
    case 4:
      LCDPIN4 &= ~MASK_FGE;
      LCDPIN5 &= ~MASK_ABCD;
      break;
    case 5:
      LCDPIN6 &= ~MASK_FGE;
      LCDPIN7 &= ~MASK_ABCD;
      break;
    case 6:
      LCDPIN8 &= ~MASK_FGE;
      LCDPIN9 &= ~MASK_ABCD;
      break;
    case 7:
      LCDPIN10 &= ~MASK_FGE;
      LCDPIN11 &= ~MASK_ABCD;
      break;
    case 8:
      LCDPIN12 &= ~MASK_FGE;
      LCDPIN13 &= ~MASK_ABCD;
      break;
    case 9:
      LCDPIN14 &= ~MASK_FGE;
      LCDPIN15 &= ~MASK_ABCD;
      break;
  }
}