/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2008 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file      emios.h
*
* @author    rc574c
*
* @version   1.0.0.0
*
* @date      Dec-11-2008
*
* @brief     EMIOS 0 related
*
******************************************************************************/

#ifndef _EMIOS_H_
#define _EMIOS_H_

/******************************************************************************
* Include
******************************************************************************/

#include "typedefs.h"

/******************************************************************************
* Channel related defines
******************************************************************************/

// eMIOS PWM channel assignment
#define PWM1  1
#define PWM2  3
#define PWM3  5
#define CTRA  23
#define CTRB  0

// eMIOS channel control structure
typedef struct
{
	vuint8_t perSel;          // PWM period (100Hz, 200Hz)
	vuint8_t dutyCycle;       // PWM Duty cycle (from 0 to 200 - 0.5% step)
	vuint8_t startDelayTime;  // PWM shift to base (from 0 to 200 - 0.5% step)
	vuint8_t triggerAdc;      // ADC trigger point (from 0 to 200 - 0.5% step)
}chPar;

// PWM 100Hz period
// PWM Duty cycle 0.5% step
#define DUTY_CYCLE_STEP_100   200
// PWM Start delay 0.5% step
#define START_DELAY_TIME_STEP_100   200
// PWM ADC trigger point 0.5% step
#define TRIGGER_ADC_STEP_100  200
// PWM period counter roll over value
#define COUNTER_PERIOD_100    40000

// PWM 200Hz period
// PWM Duty cycle 0.5% step
#define DUTY_CYCLE_STEP_200   100
// PWM Start delay 0.5% step
#define START_DELAY_TIME_STEP_200   100
// PWM ADC trigger point 0.5% step
#define TRIGGER_ADC_STEP_200  100
// PWM period counter roll over value
#define COUNTER_PERIOD_200    20000

/******************************************************************************
* Function Prototypes
******************************************************************************/

// EMIOS 0 module initialization
void Mcu_Emios_0_Init(void);

// EMIOS 0 channels initial parameters storage in channel data filed
void Mcu_Emios_0_Channel_Param_Load(void);

// EMIOS 0 Timebase channels init
void Mcu_Emios_0_Channel_Timebase_Init (vuint8_t ch, vuint16_t ctr);

// EMIOS 0 OPWMT channels configuration
void Mcu_Emios_0_Channel_OPWMT_Init(vuint8_t i);


#endif /* _EMIOS_H_ */
