#/******************************************************************************
#*
#* Freescale Semiconductor Inc.
#* (c) Copyright 2008 Freescale Semiconductor, Inc.
#* ALL RIGHTS RESERVED.
#*
#*******************************************************************************
#*
#* $File Name:  Vector_vle.s$
#*
#* $Date: $
#*
#* $Version: $
#*
#* Design Reference: MPC5604B Reference Manual
#*
#* Description: Core Vector Table and Hardware Vector Mode Interrupt Vector
#*              Table
#*
#******************************************************************************/
# Note: The user interrupt service routines must create entry and exit code
# (either with assembly code or with __interrupt keyword). If not the code
# will not exit interrupts properly.

	.globl

    .set VLE, 1         # 0/1 - VLE off/on

    # define branch instruction as either the e_b or b depending on vle settings
    # set reset configuration half word
    .if VLE == 1
        .macro  br a
          e_b a
        .endm
        .set    RCW, 0x015a015a
    .else
        .macro  br a
          b a
        .endm
        .set    RCW, 0x005a005a
    .endif

    # put reset configuration halfword and application start address into .rcw
    # section
    .extern _start
    .section ".rcw","ax"
    .long RCW, _start

    # put remaining code in this file into .isrvectbl section,
    # .isrvectbl section must be aligned on 0x1000 boundary in linker command
    # file since the upper 20 bits of .isrvectbl address are used to init IVPR
    .if VLE == 1
      .vle
      .section ".isrvectbl","avx"
    .else
      .section ".isrvectbl","ax"
    .endif

  # define symbols as global to allow easier debugging
	.globl critical_input_int_handler
	.globl machine_check_int_handler
	.globl data_storage_int_handler
	.globl inst_storage_int_handler
	.globl external_input_int_handler
	.globl alignment_int_handler
	.globl program_int_handler
	.globl FP_unavailable_int_handler
	.globl system_call_int_handler
	.globl AP_unavailable_int_handler
	.globl decrementer_int_handler
	.globl FIT_int_handler
	.globl watchdog_int_handler
	.globl data_TLB_error_int_handler
	.globl inst_TLB_error_int_handler
	.globl debug_int_handler
	.globl IntcVectorTableHw
	.globl CoreVectorTable

# core vector table
CoreVectorTable:
critical_input_int_handler:
	br .					# IVOR0
	br .
	br .
	br .
machine_check_int_handler:
	br .					# IVOR1
	br .
	br .
	br .
data_storage_int_handler:
	br .					# IVOR2
	br .
	br .
	br .
inst_storage_int_handler:
	br .					# IVOR3
	br .
	br .
	br .
external_input_int_handler:
	br .					# IVOR4
	br .
	br .
	br .
alignment_int_handler:
	br .					# IVOR5
	br .
	br .
	br .
program_int_handler:
	br .					# IVOR6
	br .
	br .
	br .
FP_unavailable_int_handler:
	br .					# IVOR7
	br .
	br .
	br .
system_call_int_handler:
	br .					# IVOR8
	br .
	br .
	br .
AP_unavailable_int_handler:
	br .					# IVOR9
	br .
	br .
	br .
decrementer_int_handler:
	br .					# IVOR10
	br .
	br .
	br .
FIT_int_handler:
	br .					# IVOR11
	br .
	br .
	br .
watchdog_int_handler:
	br .					# IVOR12
	br .
	br .
	br .
data_TLB_error_int_handler:
	br .					# IVOR13
	br .
	br .
	br .
inst_TLB_error_int_handler:
	br .					# IVOR14
	br .
	br .
	br .
debug_int_handler:
	br .					# IVOR15
	br .
	br .
	br .

# dummy code up to IVPR+0x800
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .
	br .

# intc vector table for HW vector mode at IVPR+0x800
IntcVectorTableHw:
	br .		# interrupt vector 0
	br .		# interrupt vector 1
	br .		# interrupt vector 2
	br .		# interrupt vector 3
	br .		# interrupt vector 4
	br .		# interrupt vector 5
	br .		# interrupt vector 6
	br .		# interrupt vector 7
	br .		# interrupt vector 8
	br .		# interrupt vector 9
	br .		# interrupt vector 10
	br .		# interrupt vector 11
	br .		# interrupt vector 12
	br .		# interrupt vector 13
	br .		# interrupt vector 14
	br .		# interrupt vector 15
	br .		# interrupt vector 16
	br .		# interrupt vector 17
	br .		# interrupt vector 18
	br .		# interrupt vector 19
	br .		# interrupt vector 20
	br .		# interrupt vector 21
	br .		# interrupt vector 22
	br .		# interrupt vector 23
	br .		# interrupt vector 24
	br .		# interrupt vector 25
	br .		# interrupt vector 26
	br .		# interrupt vector 27
	br .		# interrupt vector 28
	br .		# interrupt vector 29
	br .		# interrupt vector 30
	br .		# interrupt vector 31
	br .		# interrupt vector 32
	br .		# interrupt vector 33
	br .		# interrupt vector 34
	br .		# interrupt vector 35
	br .		# interrupt vector 36
	br .		# interrupt vector 37
	br .		# interrupt vector 38
	br .		# interrupt vector 39
	br .		# interrupt vector 40
	br .		# interrupt vector 41
	br .		# interrupt vector 42
	br .		# interrupt vector 43
	br .		# interrupt vector 44
	br .		# interrupt vector 45
	br .      	# interrupt vector 46
	br .		# interrupt vector 47
	br .		# interrupt vector 48
	br .		# interrupt vector 49
	br .		# interrupt vector 50
	br .		# interrupt vector 51
	br .		# interrupt vector 52
	br .		# interrupt vector 53
	br .		# interrupt vector 54
	br .		# interrupt vector 55
	br .		# interrupt vector 56
	br .		# interrupt vector 57
	br .		# interrupt vector 58
	br .		# interrupt vector 59
	br .		# interrupt vector 60
	br .		# interrupt vector 61
	br .        # interrupt vector 62
	br .		# interrupt vector 63
	br .        # interrupt vector 64
	br .		# interrupt vector 65
	br .		# interrupt vector 66
	br .		# interrupt vector 67
	br .		# interrupt vector 68
	br .		# interrupt vector 69
	br .		# interrupt vector 70
	br .		# interrupt vector 71
	br .		# interrupt vector 72
	br .		# interrupt vector 73
	br .		# interrupt vector 74
	br .		# interrupt vector 75
	br .		# interrupt vector 76
	br .		# interrupt vector 77
	br .		# interrupt vector 78
	br .		# interrupt vector 79
	br .		# interrupt vector 80
	br .		# interrupt vector 81
	br .		# interrupt vector 82
	br .		# interrupt vector 83
	br .		# interrupt vector 84
	br .		# interrupt vector 85
	br .		# interrupt vector 86
	br .		# interrupt vector 87
	br .		# interrupt vector 88
	br .		# interrupt vector 89
	br .		# interrupt vector 90
	br .		# interrupt vector 91
	br .		# interrupt vector 92
	br .		# interrupt vector 93
	br .		# interrupt vector 94
	br .		# interrupt vector 95
	br .		# interrupt vector 96
	br .		# interrupt vector 97
	br .		# interrupt vector 98
	br .        # interrupt vector 99
	br .        # interrupt vector 100
	br .		# interrupt vector 101
	br .		# interrupt vector 102
	br .		# interrupt vector 103
	br .		# interrupt vector 104
	br .		# interrupt vector 105
	br .		# interrupt vector 106
	br .		# interrupt vector 107
	br .		# interrupt vector 108
	br .		# interrupt vector 109
	br .		# interrupt vector 110
	br .		# interrupt vector 111
	br .		# interrupt vector 112
	br .		# interrupt vector 113
	br .		# interrupt vector 114
	br .		# interrupt vector 115
	br .		# interrupt vector 116
	br .		# interrupt vector 117
	br .		# interrupt vector 118
	br .		# interrupt vector 119
	br .		# interrupt vector 120
	br .		# interrupt vector 121
	br .		# interrupt vector 122
	br .		# interrupt vector 123
	br .		# interrupt vector 124
	br .		# interrupt vector 125
	br .		# interrupt vector 126
	br .		# interrupt vector 127
	br .		# interrupt vector 128
	br .		# interrupt vector 129
	br .		# interrupt vector 130
	br .		# interrupt vector 131
	br .		# interrupt vector 132
	br .		# interrupt vector 133
	br .		# interrupt vector 134
	br .		# interrupt vector 135
	br .		# interrupt vector 136
	br .		# interrupt vector 137
	br .		# interrupt vector 138
	br .		# interrupt vector 139
	br .		# interrupt vector 140
	br .		# interrupt vector 141
	br .		# interrupt vector 142
	br .		# interrupt vector 143
	br .		# interrupt vector 144
	br .		# interrupt vector 145
	br .		# interrupt vector 146
	br .		# interrupt vector 147
	br .		# interrupt vector 148
	br .		# interrupt vector 149
	br .		# interrupt vector 150
	br .		# interrupt vector 151
	br .		# interrupt vector 152
	br .		# interrupt vector 153
	br .		# interrupt vector 154
	br .		# interrupt vector 155
	br .		# interrupt vector 156
	br .		# interrupt vector 157
	br .		# interrupt vector 158
	br .		# interrupt vector 159
	br .		# interrupt vector 160
	br .		# interrupt vector 161
	br .		# interrupt vector 162
	br .		# interrupt vector 163
	br .		# interrupt vector 164
	br .		# interrupt vector 165
	br .		# interrupt vector 166
	br .		# interrupt vector 167
	br .		# interrupt vector 168
	br .		# interrupt vector 169
	br .		# interrupt vector 170
	br .		# interrupt vector 171
	br .		# interrupt vector 172
	br .		# interrupt vector 173
	br .		# interrupt vector 174
	br .		# interrupt vector 175
	br .		# interrupt vector 176
	br .		# interrupt vector 177
	br .		# interrupt vector 178
	br .		# interrupt vector 179
	br .		# interrupt vector 180
	br .		# interrupt vector 181
	br .		# interrupt vector 182
	br .		# interrupt vector 183
	br .		# interrupt vector 184
	br .		# interrupt vector 185
	br .		# interrupt vector 186
	br .		# interrupt vector 187
	br .		# interrupt vector 188
	br .		# interrupt vector 189
	br .		# interrupt vector 190
	br .		# interrupt vector 191
	br .		# interrupt vector 192
	br .		# interrupt vector 193
	br .		# interrupt vector 194
	br .		# interrupt vector 195
	br .		# interrupt vector 196
	br .		# interrupt vector 197
	br .		# interrupt vector 198
	br .		# interrupt vector 199
	br .		# interrupt vector 200
	br .		# interrupt vector 201
	br .		# interrupt vector 202
	br .		# interrupt vector 203
	br .		# interrupt vector 204
	br .		# interrupt vector 205
	br .		# interrupt vector 206
	br .		# interrupt vector 207
	br .		# interrupt vector 208
	br .		# interrupt vector 209
	br .		# interrupt vector 210
	br .		# interrupt vector 211
	br .		# interrupt vector 212
	br .		# interrupt vector 213
	br .		# interrupt vector 214
	br .		# interrupt vector 215
	br .		# interrupt vector 216
	br .		# interrupt vector 217
	br .		# interrupt vector 218
	br .		# interrupt vector 219
	br .		# interrupt vector 220
	br .		# interrupt vector 221
	br .		# interrupt vector 222
	br .		# interrupt vector 223
	br .		# interrupt vector 224
	br .		# interrupt vector 225
	br .		# interrupt vector 226
	br .		# interrupt vector 227
	br .		# interrupt vector 228
	br .		# interrupt vector 229
	br .		# interrupt vector 230
	br .		# interrupt vector 231
	br .		# interrupt vector 232
	br .		# interrupt vector 233
	br .		# interrupt vector 234
	br .		# interrupt vector 235
	br .		# interrupt vector 236
	br .		# interrupt vector 237
	br .		# interrupt vector 238
	br .		# interrupt vector 239
	br .		# interrupt vector 240
	br .		# interrupt vector 241
	br .		# interrupt vector 242
	br .		# interrupt vector 243
	br .		# interrupt vector 244
	br .		# interrupt vector 245
	br .		# interrupt vector 246
	br .		# interrupt vector 247
	br .		# interrupt vector 248
	br .		# interrupt vector 249
	br .		# interrupt vector 250
	br .		# interrupt vector 251
	br .		# interrupt vector 252
	br .		# interrupt vector 253
	br .		# interrupt vector 254
	br .		# interrupt vector 255
	br .		# interrupt vector 256
	br .		# interrupt vector 257
	br .		# interrupt vector 258
	br .		# interrupt vector 259
	br .		# interrupt vector 260
	br .		# interrupt vector 261
	br .		# interrupt vector 262
	br .		# interrupt vector 263
	br .		# interrupt vector 264
	br .		# interrupt vector 265
	br .		# interrupt vector 266
	br .		# interrupt vector 267
	br .		# interrupt vector 268
	br .		# interrupt vector 269
	br .		# interrupt vector 270
	br .		# interrupt vector 271
	br .		# interrupt vector 272
	br .		# interrupt vector 273
	br .		# interrupt vector 274
	br .		# interrupt vector 275
	br .		# interrupt vector 276
	br .		# interrupt vector 277
	br .		# interrupt vector 278
	br .		# interrupt vector 279
	br .		# interrupt vector 280
	br .		# interrupt vector 281
	br .		# interrupt vector 282
	br .		# interrupt vector 283
	br .		# interrupt vector 284
	br .		# interrupt vector 285
	br .		# interrupt vector 286
	br .		# interrupt vector 287
	br .		# interrupt vector 288
	br .		# interrupt vector 289
	br .		# interrupt vector 290
	br .		# interrupt vector 291
	br .		# interrupt vector 292
	br .		# interrupt vector 293
