/*
 * (C) Copyright 2009
 * Martha Marx, Silicon Turnkey Express, mmarx@silicontkx.com
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <mpc512x.h>
#include <version.h>

#define CONFIG_521X	1	/* needed for Linux kernel header files*/

#include <ppc_asm.tmpl>
#include <ppc_defs.h>
#include <asm/bitops.h>
#include <asm/io.h>
#include <asm/cache.h>
#include <asm/mmu.h>
#include "nfc.h"

/*!
 * This function polls the NFC to wait for the basic operation to complete by
 * checking the INT bit of config2 register.
 *
 * @max_retries number of retry attempts
 */
static void wait_op_mjmdone(void)
{
	int i;
	int max_retries = 10000;
	u16 output;
	u16 temp;

	while (1) {
		max_retries--;
		output = in_be16((u16 *)(CFG_NAND_BASE + NFC_NF_CFG2));
		temp = output;
		if (output & NFC_INT) {
			out_be16((u16 *)(CFG_NAND_BASE + NFC_NF_CFG2), 0x0);
			break;
		} else
			for (i = 1000; i > 0; i--) {
				if (temp >= 0x8ffa)
					break;
			}
		if (max_retries <= 0)
			max_retries += 10000;
	}
	return;
}

void nandload(void)
{
	/* nand init */
	out_be16((u16 *)(CFG_NAND_BASE + NFC_NFC_CFG), 0x0002);
	out_be16((u16 *)(CFG_NAND_BASE + NFC_SPAS), 0x0020);
	out_be16((u16 *)(CFG_NAND_BASE + NFC_NF_CFG1), 0x0cb2);

	out_be16((u16 *)(CFG_NAND_BASE + NFC_FLASH_CMD), NAND_CMD_READ0);
	out_be16((u16 *)(CFG_NAND_BASE + NFC_NF_CFG2), NFC_CMD);
	wait_op_mjmdone();
	out_be16((u16 *)(CFG_NAND_BASE + NFC_FLASH_ADDR), 0x0);
	out_be16((u16 *)(CFG_NAND_BASE + NFC_NF_CFG2), NFC_ADDR);
	wait_op_mjmdone();
	out_be16((u16 *)(CFG_NAND_BASE + NFC_NF_CFG2), NFC_ADDR);
	wait_op_mjmdone();
	out_be16((u16 *)(CFG_NAND_BASE + NFC_NF_CFG2), NFC_ADDR);
	wait_op_mjmdone();
	out_be16((u16 *)(CFG_NAND_BASE + NFC_NF_CFG2), NFC_ADDR);
	wait_op_mjmdone();
	out_be16((u16 *)(CFG_NAND_BASE + NFC_NF_CFG2), NFC_ADDR);
	wait_op_mjmdone();
	out_be16((u16 *)(CFG_NAND_BASE + NFC_FLASH_CMD), NAND_CMD_READCACHE);
	out_be16((u16 *)(CFG_NAND_BASE + NFC_NF_CFG2), NFC_CMD);
	wait_op_mjmdone();
	unsigned long *i, *j;
	int k;
	int num_pages = NUMPAGES;
	unsigned long *mem_idx = (unsigned long *)0x100;

	i = (unsigned long *)CFG_NAND_U_BOOT_DST;
	do {
		/* readout a page and copy to mem --
		   cache mode means we can skip the address cycle
		 */
		out_be16((u16 *)(CFG_NAND_BASE + NFC_RAM_BUF_ADDR),
			RAM_BUFFER_ADDRESS_RBA_4);
		out_be16((u16 *)(CFG_NAND_BASE + NFC_NF_CFG2), NFC_OUTPUT);
		/* Wait for operation to complete */
		wait_op_mjmdone();

		for (j = (u32 *)(CFG_NAND_BASE + TWO_K), k = 0;
				k < TWO_K/4; i++, j++, k++) {
			*i = *j;
		/* put exception vectors at 0x0 - vector size is 0x13ff */
			if (i >= (u32 *)(CFG_NAND_U_BOOT_DST + TWO_K + 0x100)
					 && mem_idx < (u32 *)0x1400)
				(*(mem_idx++)) = *j;
		}
		num_pages--;
	} while (num_pages > 0);

	out_be16((u16 *)(CFG_NAND_BASE + NFC_FLASH_CMD), NAND_CMD_READCACHEND);
	out_be16((u16 *)(CFG_NAND_BASE + NFC_NF_CFG2), NFC_CMD);
	wait_op_mjmdone();
	return;
}


