/************************************************************************************
*
* (c) Copyright 2009, Freescale, Inc.  All rights reserved.
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale.
*
************************************************************************************/
#ifndef _ENGINE_H_
#define _ENGINE_H_

/************************************************************************************
*************************************************************************************
* Public macros
*************************************************************************************
************************************************************************************/
#define ENG_BUFFER_SIZE    0x200  //read/write maximum buffer size

/************************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
************************************************************************************/
typedef enum {
  engReadReq_c      = 0x01,
  engReadResp_c     = 0x02,
  engWriteReq_c     = 0x03,
  engCommitReq_c    = 0x04,
  engEraseReq_c     = 0x05,
  engCmdCnf_c       = 0xF0
} ENGCommandId_t;

typedef enum {
  gEngValidReq_c = 0x00,
  gEngInvalidReq_c,
  gEngSuccessOp_c,
  gEngWriteError_c,
  gEngReadError_c,
  gEngCRCError_c,
  gEngCommError_c,
  gEngExecError_c,
  gEngNoConfirm_c
} ENGCmdStatus_t;

typedef enum
{
  engSecured_c    = 0xC3,
  engUnsecured_c  = 0x3C
} ENGSecureOption_t;

//pack all structures
#pragma pack(1)
typedef struct ENGReadReq_tag
{
  uint32_t        startAddress;  //start address in FLASH for the read operation
  uint16_t        length;        //number of bytes to read
} ENGReadReq_t;

typedef struct ENGReadResp_tag
{
  ENGCmdStatus_t  cmdStatus;     //previous read operation status
  uint16_t        length;        //valid data bytes in the buffer
  uint8_t         buffer[ENG_BUFFER_SIZE];
} ENGReadResp_t;

typedef struct ENGWriteReq_tag
{
  uint32_t        startAddress;  //start address for the write operation
  uint16_t        length;        //number of bytes to be written from the command buffer
  uint8_t         buffer[ENG_BUFFER_SIZE];
} ENGWriteReq_t;

typedef struct ENGCommitReq_tag
{
  uint32_t        binLength;     //length of the binary commited to FLASH
  uint8_t         secured;       //secured option
} ENGCommitReq_t;

typedef struct ENGEraseReq_tag
{
  uint32_t        address;       //the bits from [AMS-A12] are used to determine the sector to be erased. For all F's, all FLASH will be erased.
} ENGEraseReq_t;

typedef struct ENGCmdCnf_tag
{
  ENGCmdStatus_t  cmdStatus;     //previous erase operation status
} ENGCmdCnf_t;

typedef union ENGFields_tag
{
  ENGReadReq_t         readReq;
  ENGReadResp_t        readResp;
  ENGWriteReq_t        writeReq;
  ENGCommitReq_t       commitReq;
  ENGEraseReq_t        eraseReq;
  ENGCmdCnf_t          cmdCnf;
} ENGFields_t;

typedef struct ENGCommand_tag
{
  ENGCommandId_t  commandId;
  ENGFields_t     fields;
} ENGCommand_t;

//return to default packing
#pragma pack()

/************************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
************************************************************************************/

/************************************************************************************
*  Wait for and execute (if valid) one command received over the serial link.
*
*  Input parameters:
*  - None.
*  Return:
*  - Nothing.
************************************************************************************/
void ENG_Process(void);

#endif // _ENGINE_H_
